/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.editor.configuration.tizen.privilege.support;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.TreeSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.tizen.common.ui.color.TizenColors;
import org.tizen.common.ui.dialog.PopupDialog;
import org.tizen.common.ui.font.TizenFonts;
import org.tizen.common.ui.widget.ITextValidator;
import org.tizen.common.ui.widget.TextWithErrorLabel;
import org.tizen.common.util.SWTUtil;
import org.tizen.web.editor.configuration.ITizenConfigurator;
import org.tizen.web.editor.configuration.Messages;
import org.tizen.web.editor.configuration.tizen.privilege.support.AddPrivilegeContentProvider;
import org.tizen.web.editor.configuration.tizen.privilege.support.AddPrivilegeLabelProvider;
import org.tizen.web.editor.configuration.tizen.privilege.support.PrivilegeFileTextValidator;
import org.tizen.web.editor.configuration.tizen.privilege.support.PrivilegeFilter;
import org.tizen.web.editor.configuration.tizen.privilege.support.PrivilegeNameTextValidator;
import org.tizen.web.editor.widl.model.PrivilegeWrapper;

public class AddPrivilegeDialog
extends PopupDialog {
    private static final String[] ACCEPTED_EXTENSIONS = new String[]{"*.xml;*.widlprocxml"};
    private static final int PRIVILEGE_INTERNAL_IDX = 0;
    private static final int PRIVILEGE_CUSTOM_IDX = 1;
    private static final int PRIVILEGE_FILE_IDX = 2;
    private static final int RADIO_BUTTON_WIDTH = 150;
    private static final int CONTENT_MARGIN_WIDTH = 20;
    private static final int CONTENT_MARGIN_HEIGHT = 20;
    private static final int CONTENT_WIDTH = 450;
    private static final int TABLE_HEIGHT = 134;
    private static final int ERROR_LABEL_HORIZONTAL_INDENT = 10;
    private static final int ERROR_LABEL_VERTICAL_SPACING = 1;
    private ITizenConfigurator configurator;
    private CheckboxTableViewer privilegeTableViewer;
    private Text txDesc;
    private Button btInternal;
    private Button btCustom;
    private Button btFile;
    private Label lSelectCount;
    private TextWithErrorLabel txCustom;
    private TextWithErrorLabel txFile;
    private Composite internalComposite;
    private Composite customComposite;
    private Composite fileComposite;
    private Composite[] composites = new Composite[3];
    private PrivilegeFilter privilegeFilter;

    public AddPrivilegeDialog(Shell parentShell, String title, ITizenConfigurator configurator) {
        super(parentShell, title);
        this.configurator = configurator;
    }

    protected void setShellStyle(int newShellStyle) {
        super.setShellStyle(newShellStyle | 0x10 | 0x400);
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        this.setInput();
        this.btInternal.setSelection(true);
        this.btInternal.notifyListeners(13, null);
        this.validate();
        return control;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 20;
        layout.marginHeight = 20;
        layout.verticalSpacing = 0;
        composite.setLayout((Layout)layout);
        GridData layoutData = new GridData(1808);
        composite.setLayoutData((Object)layoutData);
        this.btInternal = this.createRadioButton(composite, Messages.AddPrivilegeDialog_InternalCheckboxLabel, 0);
        this.internalComposite = this.createInternalComposite(composite);
        this.btCustom = this.createRadioButton(composite, Messages.AddPrivilegeDialog_PrivilegeNameTextLabel, 1);
        this.customComposite = this.createCustomComposite(composite);
        this.btFile = this.createRadioButton(composite, Messages.AddPrivilegeDialog_FileTextLabel, 2);
        this.fileComposite = this.createFileComposite(composite);
        this.composites[0] = this.internalComposite;
        this.composites[1] = this.customComposite;
        this.composites[2] = this.fileComposite;
        return composite;
    }

    private Button createRadioButton(Composite parent, String name, int idx) {
        Button button = new Button(parent, 16);
        GridData layoutData = new GridData(2);
        layoutData.widthHint = 150;
        button.setLayoutData((Object)layoutData);
        button.setText(name);
        button.setData((Object)idx);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button widget = (Button)e.widget;
                AddPrivilegeDialog.this.enableComposite((Integer)widget.getData(), widget.getSelection());
                AddPrivilegeDialog.this.validate();
            }
        });
        return button;
    }

    private Composite createInternalComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 5;
        layout.marginBottom = 20;
        composite.setLayout((Layout)layout);
        GridData layoutData = new GridData(1808);
        composite.setLayoutData((Object)layoutData);
        Text txInternal = new Text(composite, 2176);
        txInternal.setMessage(Messages.SEARCH_TEXT_MESSAGE);
        layoutData = new GridData(768);
        layoutData.widthHint = 450;
        txInternal.setLayoutData((Object)layoutData);
        txInternal.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                Text txControl = (Text)event.widget;
                AddPrivilegeDialog.this.privilegeFilter.setSearchText(txControl.getText());
                AddPrivilegeDialog.this.privilegeTableViewer.refresh();
                AddPrivilegeDialog.this.updateSelectCountLabel();
            }
        });
        this.createInternalTable(composite);
        this.createInternalTableDesc(composite);
        return composite;
    }

    private void createInternalTable(Composite parent) {
        this.lSelectCount = new Label(parent, 0);
        GridData layoutData = new GridData(128);
        this.lSelectCount.setText(MessageFormat.format(Messages.AddPrivilegeDialog_PrivilegeSelectionCount, 0));
        this.lSelectCount.setLayoutData((Object)layoutData);
        Composite tableComp = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        tableComp.setLayout((Layout)layout);
        tableComp.setLayoutData((Object)new GridData(1808));
        Table table = new Table(tableComp, 2848);
        this.privilegeTableViewer = new CheckboxTableViewer(table);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.privilegeTableViewer);
        table.setHeaderVisible(false);
        table.setLinesVisible(true);
        GridData data = new GridData(1808);
        data.heightHint = 134;
        table.setLayoutData((Object)data);
        new TableViewerColumn((TableViewer)this.privilegeTableViewer, 0);
        TableLayout tableLayout = new TableLayout();
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(1));
        this.privilegeTableViewer.getTable().setLayout((Layout)tableLayout);
        this.privilegeTableViewer.setContentProvider((IContentProvider)new AddPrivilegeContentProvider());
        this.privilegeTableViewer.setLabelProvider((IBaseLabelProvider)new AddPrivilegeLabelProvider());
        this.privilegeFilter = new PrivilegeFilter();
        this.privilegeTableViewer.addFilter((ViewerFilter)this.privilegeFilter);
        this.privilegeTableViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                AddPrivilegeDialog.this.updateSelectCountLabel();
                AddPrivilegeDialog.this.validate();
            }
        });
        this.privilegeTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)AddPrivilegeDialog.this.privilegeTableViewer.getSelection();
                if (selection.isEmpty()) {
                    return;
                }
                String desc = ((PrivilegeWrapper)selection.getFirstElement()).getPrivilgeDesc();
                if (desc == null) {
                    AddPrivilegeDialog.this.txDesc.setText("");
                } else {
                    AddPrivilegeDialog.this.txDesc.setText(desc);
                }
            }
        });
    }

    private void createInternalTableDesc(Composite parent) {
        Composite base = new Composite(parent, 0);
        GridLayout grid = new GridLayout(1, false);
        grid.marginHeight = 0;
        grid.marginWidth = 0;
        grid.horizontalSpacing = 0;
        grid.marginTop = 10;
        grid.verticalSpacing = 7;
        base.setLayout((Layout)grid);
        base.setLayoutData((Object)new GridData(768));
        Label desc = new Label(base, 0);
        GridData layoutData = new GridData(1);
        desc.setText(Messages.DESCRIPTION_LABEL);
        desc.setLayoutData((Object)layoutData);
        this.txDesc = new Text(base, 2634);
        layoutData = new GridData(768);
        layoutData.heightHint = 55;
        this.txDesc.setLayoutData((Object)layoutData);
    }

    private Composite createCustomComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 1;
        layout.marginBottom = 5;
        composite.setLayout((Layout)layout);
        GridData layoutData = new GridData(768);
        composite.setLayoutData((Object)layoutData);
        this.txCustom = new TextWithErrorLabel(composite, 2048, (ITextValidator)new PrivilegeNameTextValidator(this.configurator));
        layoutData = new GridData(768);
        layoutData.widthHint = 450;
        this.txCustom.setLayoutData((Object)layoutData);
        Label lCustomError = new Label(composite, 64);
        layoutData = new GridData(768);
        layoutData.horizontalIndent = 10;
        lCustomError.setLayoutData((Object)layoutData);
        lCustomError.setForeground(TizenColors.getTizenRed());
        lCustomError.setFont(TizenFonts.getSmallFont());
        this.txCustom.setErrorLabel(lCustomError);
        this.txCustom.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                AddPrivilegeDialog.this.validate();
            }
        });
        return composite;
    }

    private Composite createFileComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = 10;
        layout.verticalSpacing = 1;
        composite.setLayout((Layout)layout);
        GridData layoutData = new GridData(768);
        composite.setLayoutData((Object)layoutData);
        this.txFile = new TextWithErrorLabel(composite, 2056, (ITextValidator)new PrivilegeFileTextValidator(this.configurator));
        layoutData = new GridData(768);
        this.txFile.setLayoutData((Object)layoutData);
        Button btBrowse = new Button(composite, 0);
        btBrowse.setText(org.tizen.common.Messages.BrowserButtonLabel);
        btBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                AddPrivilegeDialog.this.browseFiles();
            }
        });
        Label lFileError = new Label(composite, 64);
        layoutData = new GridData(768);
        layoutData.horizontalSpan = 2;
        layoutData.horizontalIndent = 10;
        lFileError.setLayoutData((Object)layoutData);
        lFileError.setFont(TizenFonts.getSmallFont());
        lFileError.setForeground(TizenColors.getTizenRed());
        this.txFile.setErrorLabel(lFileError);
        this.txFile.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                AddPrivilegeDialog.this.validate();
            }
        });
        return composite;
    }

    private void updateSelectCountLabel() {
        int selectionCount = this.privilegeTableViewer.getCheckedElements().length;
        this.lSelectCount.setText(MessageFormat.format(Messages.AddPrivilegeDialog_PrivilegeSelectionCount, selectionCount));
        this.lSelectCount.pack();
        this.lSelectCount.getParent().layout();
    }

    private void validate() {
        boolean validation = true;
        if (this.btFile.getSelection()) {
            validation = this.txFile.validate();
        } else if (this.btCustom.getSelection()) {
            validation = this.txCustom.validate();
        } else if (this.btInternal.getSelection()) {
            validation = this.privilegeTableViewer.getCheckedElements().length > 0;
        }
        this.getButton(0).setEnabled(validation);
    }

    private void setInput() {
        TreeSet<PrivilegeWrapper> availablePrivilegeNames = new TreeSet<PrivilegeWrapper>();
        for (PrivilegeWrapper privilegeWrapper : this.configurator.getKnownPrivileges()) {
            availablePrivilegeNames.add(privilegeWrapper);
        }
        for (PrivilegeWrapper privilegeWrapper : this.configurator.getUsedPrivileges()) {
            availablePrivilegeNames.remove(privilegeWrapper);
        }
        this.privilegeTableViewer.setInput(availablePrivilegeNames);
    }

    protected void okPressed() {
        if (this.btFile.getSelection()) {
            File privilegeFile = new File(this.txFile.getText());
            try {
                this.importExternalFile(privilegeFile);
            }
            catch (CoreException ex) {
                ErrorDialog.openError(null, (String)Messages.AddPrivilegeDialog_FinshError, (String)ex.getMessage(), (IStatus)ex.getStatus());
                return;
            }
        }
        if (this.btCustom.getSelection()) {
            String privilegeName = this.txCustom.getText();
            this.configurator.createPrivilege(privilegeName);
        }
        if (this.btInternal.getSelection()) {
            Object[] objs;
            Object[] objectArray = objs = this.privilegeTableViewer.getCheckedElements();
            int n = objs.length;
            int n2 = 0;
            while (n2 < n) {
                Object privilege = objectArray[n2];
                if (privilege instanceof PrivilegeWrapper) {
                    this.configurator.createPrivilege(((PrivilegeWrapper)privilege).getName());
                }
                ++n2;
            }
        }
        super.okPressed();
    }

    private void browseFiles() {
        FileDialog dialog = new FileDialog(this.getShell());
        dialog.setFilterExtensions(ACCEPTED_EXTENSIONS);
        dialog.setText(Messages.AddPrivilegeDialog_FileDialogTitle);
        String fileName = this.txFile.getText();
        if (!fileName.isEmpty()) {
            dialog.setFilterPath(fileName);
        } else {
            dialog.setFilterPath(null);
        }
        String resultLocation = dialog.open();
        if (resultLocation != null) {
            this.txFile.setText(resultLocation);
        }
        this.validate();
    }

    private void importExternalFile(File privilegeFile) throws CoreException {
        IProject project = this.configurator.getProject();
        IFolder externalIDLFolder = project.getFolder("external-idls");
        if (!externalIDLFolder.exists()) {
            externalIDLFolder.create(true, true, null);
        }
        try {
            String fileName = privilegeFile.getName();
            IFile file = externalIDLFolder.getFile(fileName);
            file.create((InputStream)new FileInputStream(privilegeFile), true, null);
            SWTUtil.refreshLocal((IProject)project, (int)2);
            this.configurator.addExternalDefinition(file);
        }
        catch (FileNotFoundException ex) {
            throw new CoreException((IStatus)new Status(4, "org.tizen.web.editor.configuration", ex.getLocalizedMessage(), (Throwable)ex));
        }
    }

    private void enableComposite(int compositeIdx, boolean enabled) {
        int i = 0;
        while (i < this.composites.length) {
            if (i == compositeIdx) {
                this.enableComposite(this.composites[i], enabled);
            } else {
                this.enableComposite(this.composites[i], !enabled);
            }
            ++i;
        }
    }

    public void enableComposite(Composite composite, boolean enabled) {
        Control[] children = composite.getChildren();
        int i = 0;
        while (i < children.length) {
            if (children[i] instanceof Composite) {
                this.enableComposite((Composite)children[i], enabled);
            } else {
                children[i].setEnabled(enabled);
            }
            ++i;
        }
        composite.setEnabled(enabled);
    }
}

