/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.privilege.visitor;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.Expression;
import org.eclipse.wst.jsdt.core.dom.FieldAccess;
import org.eclipse.wst.jsdt.core.dom.FunctionInvocation;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.IVariableBinding;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.StringLiteral;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationFragment;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationStatement;
import org.eclipse.wst.jsdt.internal.core.LocalVariable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.web.privilege.Messages;
import org.tizen.web.privilege.core.Api;
import org.tizen.web.privilege.core.Issue;
import org.tizen.web.privilege.core.Module;
import org.tizen.web.privilege.core.Modules;
import org.tizen.web.privilege.visitor.VariableDeclarationStatementFinder;

public class PrivilegeErrorVisitor
extends ASTVisitor {
    protected final Logger logger = LoggerFactory.getLogger(PrivilegeErrorVisitor.class);
    private JavaScriptUnit jsDomUnit;
    private HashSet<String> alreadySetPrivileges;
    private Modules usableLibs;
    private Collection<String> supportApis;
    private Collection<Issue> issues = new HashSet<Issue>();
    private static final String JS_FUNCTION_INVOCATION_SEPARATOR = "\\.";
    public static final int PRIVILEGE_MARKER_SEVERITY = 2;
    public static final int PRIVILEGE_MARKER_PRIORITY = 1;

    public PrivilegeErrorVisitor(JavaScriptUnit jsDomUnit, Modules usableLibs2, HashSet<String> alreadySetPrivileges, Collection<String> supportApiPrefixes) {
        this.jsDomUnit = jsDomUnit;
        this.usableLibs = usableLibs2;
        this.alreadySetPrivileges = alreadySetPrivileges;
        this.supportApis = supportApiPrefixes;
    }

    public void preVisit(ASTNode node) {
        switch (node.getNodeType()) {
            case 32: {
                Expression expression;
                FunctionInvocation functionInvocation = (FunctionInvocation)node;
                SimpleName name = functionInvocation.getName();
                List argumentList = functionInvocation.arguments();
                if (name == null || !((expression = ((FunctionInvocation)node).getExpression()) instanceof FieldAccess)) break;
                this.checkNode(expression, name, argumentList);
            }
        }
    }

    private void checkNode(Expression expression, SimpleName simpleName, List<String> argumentList) {
        Module module = null;
        String api = "";
        String expressionString = expression.toString();
        String[] splitedExpressionString = expressionString.split(JS_FUNCTION_INVOCATION_SEPARATOR);
        String identifier = simpleName.getIdentifier();
        if (identifier != null && !identifier.trim().equals("") && splitedExpressionString != null && splitedExpressionString.length <= 3) {
            api = identifier;
            Expression checkRootExpression = this.getRootExpression(expression);
            SimpleName moduleSimpleName = ((FieldAccess)expression).getName();
            if (checkRootExpression instanceof SimpleName && moduleSimpleName != null) {
                String checkRoot;
                List fragments;
                VariableDeclarationStatement foundDeclaredVariable;
                IJavaScriptElement javaElement;
                IBinding resolveBinding = ((SimpleName)checkRootExpression).resolveBinding();
                if (resolveBinding instanceof IVariableBinding && (javaElement = ((IVariableBinding)resolveBinding).getJavaElement()) instanceof LocalVariable && (foundDeclaredVariable = this.getFoundDeclaredVariable(this.jsDomUnit, javaElement)) != null && (fragments = foundDeclaredVariable.fragments()).size() > 0) {
                    int i = 0;
                    while (i < fragments.size()) {
                        String initializerIdentifier;
                        Expression initializer;
                        Object object = fragments.get(i);
                        if (object instanceof VariableDeclarationFragment && (initializer = ((VariableDeclarationFragment)object).getInitializer()) instanceof SimpleName && (initializerIdentifier = ((SimpleName)initializer).getIdentifier()) != null && this.supportApis.contains(initializerIdentifier)) {
                            module = this.findModule(moduleSimpleName.getIdentifier());
                            break;
                        }
                        ++i;
                    }
                }
                if (module == null && (checkRoot = ((SimpleName)checkRootExpression).getIdentifier()) != null && this.supportApis.contains(checkRoot)) {
                    module = this.findModule(moduleSimpleName.getIdentifier());
                }
            }
            String privilege = this.getPrivilege(module, api);
            if (this.getArgumentPrivilegeCount(module, api) > 0) {
                int i = 0;
                while (i < argumentList.size()) {
                    String argumentText;
                    String argumentPrivilege;
                    String o = argumentList.get(i);
                    if (o != null && o instanceof StringLiteral && (argumentPrivilege = this.getPrivilege(module, api, argumentText = ((StringLiteral)o).getLiteralValue(), i + 1)) != null && !this.isAlreadySet(argumentPrivilege)) {
                        this.addIssue(argumentPrivilege, expression.getStartPosition());
                    }
                    ++i;
                }
            } else if (privilege != null && !this.isAlreadySet(privilege)) {
                this.addIssue(privilege, expression.getStartPosition());
            }
        }
    }

    private Expression getRootExpression(Expression ex) {
        if (ex == null) {
            return null;
        }
        if (ex instanceof FunctionInvocation) {
            return this.getRootExpression(((FunctionInvocation)ex).getExpression());
        }
        if (ex instanceof FieldAccess) {
            return this.getRootExpression(((FieldAccess)ex).getExpression());
        }
        return ex;
    }

    private void addIssue(String privilege, int offset) {
        int line = this.jsDomUnit.getLineNumber(offset);
        this.issues.add(new Issue(line, MessageFormat.format(Messages.PROBLEMS_VIEW_MESSAGE, privilege)));
    }

    public Collection<Issue> getIssues() {
        return this.issues;
    }

    private String getPrivilege(Module module, String api) {
        if (module == null) {
            return null;
        }
        return module.getPrivilege(api);
    }

    private int getArgumentPrivilegeCount(Module module, String apiName) {
        if (module == null) {
            return 0;
        }
        Api api = module.getApi(apiName);
        if (api == null) {
            return 0;
        }
        return api.getArgumentsSize();
    }

    private String getPrivilege(Module module, String apiName, String argumentText, int argumentIndex) {
        if (module == null) {
            return null;
        }
        Api api = module.getApi(apiName);
        if (api == null) {
            return null;
        }
        return api.getArgumentPrivilege(argumentText, argumentIndex);
    }

    private boolean isAlreadySet(String privilege) {
        return this.alreadySetPrivileges.contains(privilege);
    }

    private Module findModule(String moduleProtoTypeName) {
        for (Map.Entry elem : this.usableLibs.entrySet()) {
            String symbol = ((Module)elem.getValue()).getSymbol();
            if (symbol == null || !symbol.equals(moduleProtoTypeName)) continue;
            return (Module)elem.getValue();
        }
        return null;
    }

    private VariableDeclarationStatement getFoundDeclaredVariable(JavaScriptUnit jsUnit, IJavaScriptElement javaElement) {
        VariableDeclarationStatementFinder vdsFinder = new VariableDeclarationStatementFinder(javaElement);
        jsUnit.accept((ASTVisitor)vdsFinder);
        return vdsFinder.getVariableDeclarationStatement();
    }
}

