/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.zimlaunch.step;

import org.eclipse.osgi.util.NLS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.launch.context.ILaunchContext;
import org.tizen.common.util.log.UserLogger;
import org.tizen.sdblib.IDevice;
import org.tizen.web.zimlaunch.core.CompositeStep;
import org.tizen.web.zimlaunch.core.IStep;
import org.tizen.web.zimlaunch.debug.core.InspectorManager;
import org.tizen.web.zimlaunch.exception.TizenWebIDEException;
import org.tizen.web.zimlaunch.exception.TizenWebIDEExceptionCode;
import org.tizen.web.zimlaunch.notification.TizenWebNotifier;
import org.tizen.web.zimlaunch.resource.ZimLaunchResource;
import org.tizen.web.zimlaunch.step.Messages;
import org.tizen.web.zimlaunch.util.CommandLauncher;
import org.tizen.web.zimlaunch.util.PortUtil;

public class KillStep
extends CompositeStep {
    protected static final Logger logger = LoggerFactory.getLogger(KillStep.class);
    public static final String name = Messages.STEP_KILL;
    protected CommandLauncher launcher;
    protected TizenWebNotifier notifier;
    protected ZimLaunchResource resource;
    protected boolean isInstalled;
    protected IDevice device;
    protected String appID;
    protected int percent;

    public KillStep() {
        super(new IStep[0]);
    }

    @Override
    public void executeStep(ILaunchContext ctx) throws Exception {
        UserLogger.start((String)"web.launch", (String)".kill");
        this.preExecuteStep(ctx);
        InspectorManager.getInstance().killInspector(this.resource.getAppinfo().getAppID());
        if (!this.isInstalled || !this.launcher.isRunningWidget(this.resource)) {
            logger.debug(Messages.getSuccessMessage((String)Messages.STEP_KILL), (Object)this.getWorkCount(100));
            UserLogger.end((String)"web.launch", (String)".kill");
            return;
        }
        this.handleCancelEvent(this.notifier, this.notifier.getMonitor());
        int oldlport = PortUtil.getInstance().getLocalPort(this.device.getSerialNumber(), this.appID);
        int oldrport = PortUtil.getInstance().getRemotePort(this.device.getSerialNumber(), this.appID);
        if (oldlport > 0 && oldrport > 0) {
            this.launcher.removeForward(this.appID, oldlport, oldrport);
        }
        this.handleCancelEvent(this.notifier, this.notifier.getMonitor());
        UserLogger.end((String)"web.launch", (String)".kill");
    }

    protected void preExecuteStep(ILaunchContext ctx) throws Exception {
        String errMsg = "";
        int code = 0;
        this.launcher = (CommandLauncher)ctx.getValue((Object)"command launcher");
        String eMsg = Messages.getFailMessage((String)Messages.TRANSFER_PACKAGE);
        if (this.launcher == null) {
            code = TizenWebIDEExceptionCode.WEB_IDE_STEPCONTEXT_CAN_NOT_FIND_COMMNAD_LAUNCHER.getCode();
            errMsg = NLS.bind((String)Messages.UNEXPECTED_OPERATION, (Object)Messages.STEP_CONTEXT_HANDLE);
            TizenWebIDEException.abort(eMsg, new TizenWebIDEException(errMsg, code), new TizenWebNotifier[0]);
        }
        this.resource = (ZimLaunchResource)ctx.getValue((Object)"resource");
        if (this.resource == null) {
            code = TizenWebIDEExceptionCode.WEB_IDE_STEPCONTEXT_CAN_NOT_FIND_LAUNCH_RESOURCE.getCode();
            errMsg = NLS.bind((String)Messages.UNEXPECTED_OPERATION, (Object)Messages.STEP_CONTEXT_HANDLE);
            TizenWebIDEException.abort(eMsg, new TizenWebIDEException(errMsg, code), new TizenWebNotifier[0]);
        }
        this.notifier = (TizenWebNotifier)ctx.getValue((Object)"notifier");
        this.isInstalled = (Boolean)ctx.getValue((Object)"widget installation");
        this.device = this.resource.getDeviceinfo().getDevice();
        this.appID = this.resource.getAppinfo().getAppID();
        this.work = 100;
        this.rwork = 100;
        this.percent = 10;
        this.pwork = this.notifier.getRemainWork() < 20 ? this.notifier.getPercentRemainWork(this.percent) : 10;
    }

    @Override
    public String getStepName() {
        return name;
    }
}

