/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.editor.html.refactoring;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.internal.core.refactoring.resource.UndoDeleteResourceChange;
import org.eclipse.ltk.internal.core.refactoring.resource.undostates.ResourceUndoState;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;
import org.eclipse.wst.html.core.internal.document.DOMStyleModelImpl;
import org.eclipse.wst.html.core.internal.document.DocumentStyleImpl;
import org.eclipse.wst.html.core.internal.document.ElementStyleImpl;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.xml.core.internal.document.CommentImpl;
import org.eclipse.wst.xml.core.internal.document.NodeImpl;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.web.editor.Activator;
import org.tizen.web.editor.contentassist.WebResourceManager;
import org.tizen.web.editor.html.refactoring.DeleteRefactorUndoData;
import org.tizen.web.editor.html.refactoring.WebFileDeleteChange;
import org.tizen.web.editor.html.refactoring.WebFileRefactoringConstants;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WebFileDeleteUndoChange
extends UndoDeleteResourceChange
implements WebFileRefactoringConstants {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private IFile srcFile = null;
    private String fileName = null;
    private IPath resourcePath = null;
    private Map<String, IResource> htmlFiles = null;
    private Map<IFile, DeleteRefactorUndoData> undoDataMap = null;

    public WebFileDeleteUndoChange(IPath resourcePath, IFile srcFile, String fileName, ResourceUndoState resourceDescription, Map<IFile, DeleteRefactorUndoData> undoDataMap) {
        super(resourceDescription);
        this.srcFile = srcFile;
        this.resourcePath = resourcePath;
        this.fileName = fileName;
        IProject project = this.srcFile.getProject();
        WebResourceManager resourceManager = new WebResourceManager(project);
        resourceManager.makeProjectManagedResourceMap();
        this.htmlFiles = resourceManager.getHtmlFiles();
        this.undoDataMap = undoDataMap;
    }

    public Change perform(IProgressMonitor pm) throws CoreException {
        this.refactoring(pm);
        WebFileDeleteChange change = new WebFileDeleteChange(this.resourcePath, this.srcFile, this.fileName, true);
        change.setValidationMethod(3);
        return change;
    }

    private void refactoring(IProgressMonitor monitor) {
        String extension = this.srcFile.getFileExtension();
        WebFileRefactoringConstants.FileExtension fileExtension = WebFileRefactoringConstants.FileExtension.getFileExtension(extension);
        if (fileExtension == null) {
            fileExtension = WebFileRefactoringConstants.FileExtension.IMAGE;
        }
        if (fileExtension == WebFileRefactoringConstants.FileExtension.HTML || fileExtension == WebFileRefactoringConstants.FileExtension.HTM) {
            IProject project = this.srcFile.getProject();
            WebResourceManager resourceManager = new WebResourceManager(project);
            resourceManager.makeProjectManagedResourceMap();
            this.htmlFiles = resourceManager.getHtmlFiles();
        }
        Set<Map.Entry<String, IResource>> entrySet = this.htmlFiles.entrySet();
        for (Map.Entry<String, IResource> fileEntry : entrySet) {
            IFile file = (IFile)fileEntry.getValue();
            try {
                IModelManager modelManager = StructuredModelManager.getModelManager();
                IStructuredModel model = modelManager.getModelForEdit(file);
                if (model == null) continue;
                DOMStyleModelImpl dom = (DOMStyleModelImpl)model;
                IDOMDocument document = dom.getDocument();
                this.refactoring(file, fileExtension, document);
                IStructuredDocument structuredDocument = model.getStructuredDocument();
                modelManager.saveStructuredDocument(structuredDocument, file);
            }
            catch (IOException e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
            catch (CoreException e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private void refactoring(IFile file, WebFileRefactoringConstants.FileExtension fileExtension, IDOMDocument document) {
        String tagName = null;
        String attributeName = null;
        switch (fileExtension) {
            case HTML: 
            case HTM: {
                tagName = "a";
                attributeName = "href";
                this.processRefactoring(file, document, tagName, attributeName);
                tagName = "iframe";
                attributeName = "src";
                this.processRefactoring(file, document, tagName, attributeName);
                break;
            }
            case CSS: {
                tagName = "link";
                attributeName = "href";
                this.processRefactoring(file, document, tagName, attributeName);
                break;
            }
            case JS: {
                tagName = "script";
                attributeName = "src";
                this.processRefactoring(file, document, tagName, attributeName);
                break;
            }
            case IMAGE: {
                tagName = "img";
                attributeName = "src";
                this.processRefactoring(file, document, tagName, attributeName);
                break;
            }
        }
    }

    private void processRefactoring(IFile file, IDOMDocument document, String tagName, String attributeName) {
        if (this.undoDataMap == null) {
            return;
        }
        DeleteRefactorUndoData deleteRefactorUndoData = this.undoDataMap.get(file);
        if (deleteRefactorUndoData == null) {
            return;
        }
        Node parentNode = deleteRefactorUndoData.getParentNode();
        if (parentNode != null) {
            Node matchedNode;
            Node deletedNode = deleteRefactorUndoData.getDeletedNode();
            String deletedNodeSource = deleteRefactorUndoData.getDeletedNodeSource();
            Node matchedParentNode = this.getMatchedNode(document, parentNode);
            if (matchedParentNode != null && (matchedNode = this.getMatchedCommentNode(document, matchedParentNode, deletedNodeSource)) != null) {
                Element createDeletedNode = this.createDeletedNode(document, deletedNode);
                matchedNode.getParentNode().replaceChild(createDeletedNode, matchedNode);
                IStructuredDocumentRegion startStructuredDocumentRegion = ((NodeImpl)createDeletedNode).getStartStructuredDocumentRegion();
                int start = startStructuredDocumentRegion.getStart();
                IStructuredDocument parentDocument = startStructuredDocumentRegion.getParentDocument();
                int lineOfOffset = parentDocument.getLineOfOffset(start) + 1;
                this.print(file, "[DELETE REFACTOR] " + file.getName() + "(" + lineOfOffset + ")" + " is changed at '" + startStructuredDocumentRegion.getFullText() + "'.");
            }
        }
    }

    private Element createDeletedNode(IDOMDocument document, Node deletedNode) {
        Element createdNode = document.createElement(deletedNode.getNodeName());
        NamedNodeMap attributes = deletedNode.getAttributes();
        if (attributes != null) {
            int i = 0;
            while (i < attributes.getLength()) {
                Attr attr = (Attr)attributes.item(i);
                createdNode.setAttribute(attr.getName(), attr.getValue());
                ++i;
            }
        }
        return createdNode;
    }

    private Node getMatchedCommentNode(IDOMDocument document, Node parentNode, String findNodeSource) {
        Node matchedCommentNode = null;
        NodeList childNodes = parentNode.getChildNodes();
        if (childNodes != null) {
            int i = 0;
            while (i < childNodes.getLength()) {
                String targetNodeValue;
                Node item = childNodes.item(i);
                if (item instanceof CommentImpl && (targetNodeValue = item.getNodeValue()) != null && targetNodeValue.equals(findNodeSource)) {
                    matchedCommentNode = item;
                    break;
                }
                ++i;
            }
        }
        return matchedCommentNode;
    }

    private Node getMatchedNode(IDOMDocument document, Node parentNode) {
        Node matchedNode = null;
        IStructuredDocumentRegion sourceStartStructuredDocumentRegion = ((ElementStyleImpl)parentNode).getStartStructuredDocumentRegion();
        int sourceStart = sourceStartStructuredDocumentRegion.getStart();
        String tagName = parentNode.getNodeName();
        NodeList nodeList = ((DocumentStyleImpl)document).getElementsByTagName(tagName);
        if (nodeList != null) {
            int i = 0;
            while (i < nodeList.getLength()) {
                Node item = nodeList.item(i);
                IStructuredDocumentRegion targetStartStructuredDocumentRegion = ((NodeImpl)item).getStartStructuredDocumentRegion();
                int targetStart = targetStartStructuredDocumentRegion.getStart();
                if (targetStart == sourceStart) {
                    matchedNode = item;
                    break;
                }
                ++i;
            }
        }
        return matchedNode;
    }

    private void print(IFile file, String message) {
        try {
            MessageConsole refactorConsole = Activator.getDefault().getRefactorConsole();
            ConsolePlugin.getDefault().getConsoleManager().addConsoles(new IConsole[]{refactorConsole});
            ConsolePlugin.getDefault().getConsoleManager().showConsoleView((IConsole)refactorConsole);
            MessageConsoleStream stream = refactorConsole.newMessageStream();
            stream.setActivateOnWrite(true);
            stream.println(message);
            stream.close();
        }
        catch (IOException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
    }
}

