/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.packager.ui.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.tizen.common.ITizenNativeProject;
import org.tizen.common.ITizenNativeXMLStore;
import org.tizen.common.TizenPlatformConstants;
import org.tizen.common.TizenProjectType;
import org.tizen.common.core.application.PackageResourceInfo;
import org.tizen.common.core.application.TizenPackageInfoStore;
import org.tizen.common.core.application.TizenProjectDescription;
import org.tizen.common.file.FileHandler;
import org.tizen.common.file.Filter;
import org.tizen.common.file.SimpleFileFilter;
import org.tizen.common.file.VirtualFileHandler;
import org.tizen.common.file.filter.WildCardFilterFactory;
import org.tizen.common.packager.PackageResource;
import org.tizen.common.ui.dialog.LinkDialog;
import org.tizen.common.util.Assert;
import org.tizen.common.util.CollectionUtil;
import org.tizen.common.util.FileUtil;
import org.tizen.common.util.IOUtil;
import org.tizen.common.util.SWTUtil;
import org.tizen.common.util.StringUtil;
import org.tizen.web.common.WebCommonActivator;
import org.tizen.web.common.util.ProjectUtil;
import org.tizen.web.config.schema.model.Profile;
import org.tizen.web.config.schema.model.Widget;
import org.tizen.web.editor.configuration.ConfigurationException;
import org.tizen.web.editor.configuration.ConfiguratorFactory;
import org.tizen.web.editor.configuration.ITizenConfigurator;
import org.tizen.web.packager.core.PackageProcessType;
import org.tizen.web.packager.core.exception.PackageException;
import org.tizen.web.packager.ui.Messages;
import org.tizen.web.packager.ui.QuestionDialog;

public class PackageUtil
extends org.tizen.web.common.util.PackageUtil {
    public static org.tizen.common.file.IResource makeNativeManifestFile(IProject project, FileHandler fh) throws ConfigurationException, CoreException, IOException {
        Assert.notNull((Object)project);
        Assert.notNull((Object)fh);
        ITizenConfigurator configurator = ConfiguratorFactory.unmarshalWidgetConfiguration((IProject)project);
        String packageId = configurator.getApplicationPackage();
        String version = configurator.getVersion();
        IProject[] refNativeProjects = ProjectUtil.getReferencedNativeProjects((IProject)project);
        if (refNativeProjects.length == 0) {
            return null;
        }
        ITizenNativeXMLStore rootStore = null;
        IProject refNativeRootProject = PackageUtil.getReferencedNativeRootProject(project, refNativeProjects);
        if (refNativeRootProject == null) {
            return null;
        }
        rootStore = ProjectUtil.getTizenNativeXmlStore((IProject)refNativeRootProject);
        if (rootStore == null) {
            return null;
        }
        org.tizen.common.file.IResource resource = null;
        PackageUtil.mergeNativeManifest(rootStore, refNativeRootProject, refNativeProjects, packageId);
        String manifestFileName = TizenPlatformConstants.MANIFEST_XML_FILE_NAME;
        String remotePath = FileUtil.appendPath((String)"info", (String)manifestFileName);
        if (ProjectUtil.isTizenNativeCoreProject((IProject)refNativeRootProject)) {
            remotePath = manifestFileName = TizenPlatformConstants.CORE_MANIFEST_XML_FILE_NAME;
            rootStore.setPackage(packageId);
            rootStore.setVersion(version);
        }
        PackageUtil.setNativeAppId(rootStore, packageId);
        resource = PackageUtil.getManifestResource(rootStore, fh, manifestFileName, remotePath);
        return resource;
    }

    private static boolean setNativeAppId(ITizenNativeXMLStore store, String packageId) {
        List executableNames = store.getExecutableNames();
        if (executableNames != null && !executableNames.isEmpty()) {
            store.setId(String.valueOf(packageId) + "." + (String)executableNames.get(0));
            return true;
        }
        return false;
    }

    private static org.tizen.common.file.IResource getManifestResource(ITizenNativeXMLStore rootStore, FileHandler fh, String manifestFileName, String remotePath) throws IOException {
        FileInputStream is = null;
        PackageResource resource = null;
        File tempManifestFile = new File(FileUtil.appendPath((String)fh.getCurrentWorkingDirectory(), (String)("." + manifestFileName)));
        rootStore.storeXml(tempManifestFile);
        if (!tempManifestFile.exists()) {
            return resource;
        }
        try {
            resource = new PackageResource(fh, manifestFileName, remotePath);
            is = new FileInputStream(tempManifestFile);
            resource.setContents(IOUtil.getBytes((InputStream)is));
        }
        catch (Throwable throwable) {
            IOUtil.tryClose((Object[])new Object[]{is});
            tempManifestFile.delete();
            throw throwable;
        }
        IOUtil.tryClose((Object[])new Object[]{is});
        tempManifestFile.delete();
        return resource;
    }

    private static void mergeNativeManifest(ITizenNativeXMLStore rootStore, IProject refNativeRootProject, IProject[] refNativeProjects, String packageId) throws CoreException {
        int i = 0;
        while (i < refNativeProjects.length) {
            IProject refSubNativeProject = refNativeProjects[i];
            if (refSubNativeProject != refNativeRootProject) {
                ITizenNativeXMLStore refStore = null;
                refStore = ProjectUtil.getTizenNativeXmlStore((IProject)refSubNativeProject);
                if (refStore == null) {
                    return;
                }
                if (ProjectUtil.isTizenNativeCoreProject((IProject)refNativeRootProject)) {
                    PackageUtil.setNativeAppId(refStore, packageId);
                    rootStore.mergeManifest(refStore);
                } else {
                    rootStore.mergeAppData(refStore);
                    rootStore.mergePrivData(refStore);
                }
            }
            ++i;
        }
    }

    private static IProject getReferencedNativeRootProject(IProject project, IProject[] refNativeProjects) throws CoreException {
        IProject refNativeRootProject = null;
        if (refNativeProjects == null) {
            return refNativeRootProject;
        }
        String referencedNativeRootProjectName = ProjectUtil.getReferencedNativeRootProjectName((IProject)project);
        if (referencedNativeRootProjectName == null) {
            refNativeRootProject = refNativeProjects[0];
        } else {
            IProject[] iProjectArray = refNativeProjects;
            int n = refNativeProjects.length;
            int n2 = 0;
            while (n2 < n) {
                IProject refNativeProject = iProjectArray[n2];
                if (referencedNativeRootProjectName.equals(refNativeProject.getName())) {
                    refNativeRootProject = refNativeProject;
                }
                ++n2;
            }
        }
        return refNativeRootProject;
    }

    public static boolean continueToPackage(String title, String message, String togglePreferenceKey) {
        QuestionDialog questionDialog = new QuestionDialog(title, message, togglePreferenceKey);
        Display.getDefault().syncExec((Runnable)questionDialog);
        return questionDialog.wantToContinue();
    }

    public static String getProfile(IProject project) throws PackageException {
        TizenProjectDescription description;
        String profileName = "";
        IFile configFile = project.getFile("config.xml");
        if (configFile.isAccessible()) {
            List contents;
            InputStream configIs;
            block9: {
                configIs = null;
                configIs = configFile.getContents();
                Widget widget = ConfiguratorFactory.unmarshal((InputStream)configIs);
                contents = widget.getContent();
                if (contents != null) break block9;
                String string = profileName;
                IOUtil.tryClose((Object[])new Object[]{configIs});
                return string;
            }
            try {
                try {
                    for (Object content : contents) {
                        if (!(content instanceof Profile)) continue;
                        profileName = ((Profile)content).getName();
                        break;
                    }
                }
                catch (CoreException e) {
                    throw new PackageException((Exception)((Object)e), e.getLocalizedMessage());
                }
                catch (ConfigurationException e) {
                    throw new PackageException((Exception)((Object)e), e.getLocalizedMessage());
                }
            }
            catch (Throwable throwable) {
                IOUtil.tryClose((Object[])new Object[]{configIs});
                throw throwable;
            }
            IOUtil.tryClose((Object[])new Object[]{configIs});
        }
        if (StringUtil.isEmpty((CharSequence)profileName) && (description = ProjectUtil.getTizenProjectDescription((IProject)project)) != null) {
            profileName = description.getProfileName();
        }
        return profileName;
    }

    public static String getNativeProfile(IProject nativeProject) throws PackageException {
        TizenProjectDescription description;
        String profileName = "";
        try {
            ITizenNativeXMLStore store = ProjectUtil.getTizenNativeXmlStore((IProject)nativeProject);
            if (store == null) {
                return profileName;
            }
            profileName = store.getProfileName();
        }
        catch (CoreException e) {
            throw new PackageException((Exception)((Object)e));
        }
        if (StringUtil.isEmpty((CharSequence)profileName) && (description = ProjectUtil.getTizenProjectDescription((IProject)nativeProject)) != null) {
            profileName = description.getProfileName();
        }
        return profileName;
    }

    public static HashSet<org.tizen.common.file.IResource> getNativeResources(PackageProcessType type, ITizenNativeProject tproject, FileHandler fh, String ... excludes) throws IOException {
        SimpleFileFilter filter = new SimpleFileFilter(true);
        WildCardFilterFactory filterFactory = new WildCardFilterFactory();
        String[] stringArray = excludes;
        int n = excludes.length;
        int n2 = 0;
        while (n2 < n) {
            String exclude = stringArray[n2];
            filter.addExcludes(new Filter[]{(Filter)filterFactory.create((Object)exclude)});
            ++n2;
        }
        List<PackageResourceInfo> pris = new ArrayList<PackageResourceInfo>();
        TizenPackageInfoStore pkgStore = tproject.getTizenPkgInfoStore();
        List packageRes = pkgStore.getPackageRes();
        for (PackageResourceInfo pri : packageRes) {
            if (!filter.accept(fh.getCurrentWorkingDirectory(), pri.getName()) || PackageUtil.contains((PackageResourceInfo)pri, (List)pkgStore.getBlackList()) && !PackageUtil.contains((PackageResourceInfo)pri, (List)pkgStore.getExcludeList())) continue;
            pris.add(pri);
        }
        List invisibleRes = pkgStore.getInvisiblePkgRes();
        for (PackageResourceInfo pri : invisibleRes) {
            if (pri == null || !filter.accept(fh.getCurrentWorkingDirectory(), pri.getName()) || !pri.isRequirement()) continue;
            pris.add(pri);
        }
        if (PackageProcessType.RELEASE.equals((Object)type)) {
            pris = PackageUtil.optimizeNativeResources(tproject, fh.getCurrentWorkingDirectory(), pris);
        }
        return PackageUtil.getResources(fh, pris, excludes);
    }

    private static HashSet<org.tizen.common.file.IResource> getResources(FileHandler fh, List<PackageResourceInfo> pris, String ... excludes) throws IOException {
        HashSet<org.tizen.common.file.IResource> resources = new HashSet<org.tizen.common.file.IResource>();
        for (PackageResourceInfo pri : pris) {
            String relativeResourcePath = pri.getName();
            if (relativeResourcePath.startsWith("/")) {
                relativeResourcePath = relativeResourcePath.substring(1);
            }
            SimpleFileFilter filter = new SimpleFileFilter(true);
            WildCardFilterFactory filterFactory = new WildCardFilterFactory();
            String[] stringArray = excludes;
            int n = excludes.length;
            int n2 = 0;
            while (n2 < n) {
                String exclude = stringArray[n2];
                if (exclude.startsWith("/")) {
                    exclude = exclude.substring(1);
                }
                filter.addExcludes(new Filter[]{(Filter)filterFactory.create((Object)exclude)});
                ++n2;
            }
            HashSet tempResources = PackageUtil.getResources((FileHandler)fh, (String)relativeResourcePath, (String)pri.remotePath(), (SimpleFileFilter)filter);
            if (tempResources.isEmpty()) {
                VirtualFileHandler vfh = new VirtualFileHandler();
                vfh.setCurrentWorkingDirectory(fh.getCurrentWorkingDirectory());
                vfh.makeDirectory(relativeResourcePath, true);
                tempResources.add(new PackageResource((FileHandler)vfh, relativeResourcePath, pri.remotePath()));
            }
            resources.addAll(tempResources);
        }
        return resources;
    }

    private static List<PackageResourceInfo> optimizeNativeResources(ITizenNativeProject tproject, String cwd, List<PackageResourceInfo> pris) {
        return tproject.optimize(pris);
    }

    public static List<TizenProjectDescription.RefTizenProject> getMigratingReferencedProjectsForWeb(IProject targetProject) {
        List refTizenProjects = PackageUtil.getMigratingReferencedProjects((IProject)targetProject);
        if (CollectionUtil.isEmpty((Collection)refTizenProjects)) {
            return refTizenProjects;
        }
        TizenProjectType ttpt = ProjectUtil.getTizenProjectType((IProject)targetProject);
        boolean nativeMainSetAlready = false;
        boolean companionSetAlready = false;
        String style = null;
        for (TizenProjectDescription.RefTizenProject rtp : refTizenProjects) {
            String appName;
            if (PackageUtil.isCompanionApp(ttpt, rtp)) {
                appName = PackageUtil.getPersistentProperty((IResource)targetProject, WebCommonActivator.companionWearableWebAppQName);
                style = "companion";
                companionSetAlready = PackageUtil.setStyle(rtp, appName, style, companionSetAlready);
                continue;
            }
            if (!PackageUtil.isNativeMultiApp(ttpt, rtp)) continue;
            appName = PackageUtil.getPersistentProperty((IResource)targetProject, WebCommonActivator.rootNativeAppQName);
            style = "native main";
            nativeMainSetAlready = PackageUtil.setStyle(rtp, appName, style, nativeMainSetAlready);
        }
        return refTizenProjects;
    }

    private static boolean setStyle(TizenProjectDescription.RefTizenProject rtp, String appName, String style, boolean setAlready) {
        boolean result = false;
        if (StringUtil.isEmpty((CharSequence)appName)) {
            if (!setAlready) {
                rtp.setStyle(style);
                result = true;
            }
        } else if (rtp.getName().equals(appName)) {
            rtp.setStyle(style);
            result = true;
        }
        return result;
    }

    private static boolean isNativeMultiApp(TizenProjectType targetProjectType, TizenProjectDescription.RefTizenProject rtp) {
        IProject referenceProject = ProjectUtil.getProject((String)rtp.getName());
        TizenProjectType rtpt = ProjectUtil.getTizenProjectType((IProject)referenceProject);
        TizenProjectType.SelectableReferenceNum selectableNum = targetProjectType.getSelectableReferenceNum(rtpt);
        return rtpt.isNativeProject() && TizenProjectType.SelectableReferenceNum.NATURAL.equals((Object)selectableNum);
    }

    private static boolean isCompanionApp(TizenProjectType targetProjectType, TizenProjectDescription.RefTizenProject rtp) {
        IProject referenceProject = ProjectUtil.getProject((String)rtp.getName());
        TizenProjectType rtpt = ProjectUtil.getTizenProjectType((IProject)referenceProject);
        TizenProjectType.SelectableReferenceNum selectableNum = targetProjectType.getSelectableReferenceNum(rtpt);
        return rtpt.isWebProject() && TizenProjectType.SelectableReferenceNum.ONE.equals((Object)selectableNum);
    }

    private static String getPersistentProperty(IResource resource, QualifiedName key) {
        String value = null;
        try {
            value = resource.getPersistentProperty(key);
        }
        catch (CoreException coreException) {}
        return value;
    }

    public static void showMigrationCompleteDialog(final IProject project, String propertyPageId) {
        SWTUtil.syncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                SelectionListener listner = new SelectionListener(){

                    public void widgetSelected(SelectionEvent arg0) {
                        PreferenceDialog dialog = PreferencesUtil.createPropertyDialogOn((Shell)SWTUtil.getActiveShell(), (IAdaptable)project, (String)"org.tizen.web.packager.ui.properties.multi.MultiPropertyPage", (String[])new String[]{"org.tizen.web.packager.ui.properties.multi.MultiPropertyPage"}, (Object)Collections.EMPTY_MAP);
                        if (dialog != null) {
                            dialog.open();
                        }
                    }

                    public void widgetDefaultSelected(SelectionEvent arg0) {
                    }
                };
                LinkDialog dialog = new LinkDialog(SWTUtil.getActiveShell(), listner, Messages.MIGRATE_REFERENCE_INFORMATION_TITLE, Messages.MIGRATE_REFERENCE_INFORMATION_DESC);
                dialog.open();
            }
        });
    }
}

