/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.zimlaunch.cli.command;

import java.text.MessageFormat;
import org.tizen.common.core.command.ExecutionContext;
import org.tizen.common.core.command.Executor;
import org.tizen.common.util.Assert;
import org.tizen.web.zimlaunch.cli.command.WRTCommand;
import org.tizen.web.zimlaunch.cli.command.WgtInfoCommand;

public class KillCommand
extends WRTCommand {
    protected static final String WRT_LAUNCHER_KILL_COMMAND = "/usr/bin/wrt-launcher --kill";
    protected String widgetID;

    public String getWidgetID() {
        return this.widgetID;
    }

    public KillCommand(String widgetID) {
        this.widgetID = widgetID;
    }

    protected String getAppId(Executor executor, ExecutionContext context) throws Exception {
        WgtInfoCommand getWgtInfoCommand = new WgtInfoCommand(this.getWidgetID());
        getWgtInfoCommand.setDevice(this.getDevice());
        getWgtInfoCommand.setPrintOption(this.isPrintOption());
        getWgtInfoCommand.run(executor, context);
        return getWgtInfoCommand.getAppId();
    }

    @Override
    protected boolean checkCommandReturnCode() {
        String result = this.getResult();
        Assert.notNull((Object)result);
        if (!result.contains("result: killed")) {
            return false;
        }
        return super.checkCommandReturnCode();
    }

    @Override
    public void run(Executor executor, ExecutionContext context) throws Exception {
        String killingKey = this.getAppId(executor, context);
        Assert.notNull((Object)killingKey);
        this.setCommand("/usr/bin/wrt-launcher --kill " + killingKey);
        super.run(executor, context);
        String msg = this.checkCommandReturnCode() ? MessageFormat.format("''{0}'' kill successful.", this.getWidgetID()) : MessageFormat.format("''{0}'' kill failed.", this.getWidgetID());
        if (this.isPrintOption()) {
            context.getPrompter().notify(msg);
        }
        this.clearResult();
        this.setResult(msg);
    }

    @Override
    public void undo(Executor executor, ExecutionContext context) throws Exception {
        super.undo(executor, context);
    }
}

