/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.unittest.resultview.model;

import java.util.ArrayList;
import java.util.List;
import org.tizen.web.unittest.resultview.model.WUTGlobalFailure;
import org.tizen.web.unittest.resultview.model.WUTResultTestSuite;

public class WUTResult {
    private int totalAssertionCount;
    private int errorCount;
    private int failedAssertionCount;
    private double elapsedTime;
    private List<WUTResultTestSuite> testSuiteList;
    private List<WUTGlobalFailure> globalFailureList;

    public WUTResult(int totalAssertionCount, int failedAssertionCount, double elapsedTime) {
        this.totalAssertionCount = totalAssertionCount;
        this.errorCount = 0;
        this.failedAssertionCount = failedAssertionCount;
        this.elapsedTime = elapsedTime;
        this.testSuiteList = new ArrayList<WUTResultTestSuite>();
        this.globalFailureList = new ArrayList<WUTGlobalFailure>();
    }

    public int getTotalAssertionCount() {
        return this.totalAssertionCount;
    }

    public void subtractTotalAssertionCount() {
        --this.totalAssertionCount;
    }

    public int getErrorCount() {
        return this.errorCount;
    }

    public void addErrorCount() {
        ++this.errorCount;
    }

    public int getFailedAssertionCount() {
        return this.failedAssertionCount;
    }

    public void subtractFailedAssertionCount() {
        --this.failedAssertionCount;
    }

    public double getElapsedTime() {
        return this.elapsedTime;
    }

    public List<WUTResultTestSuite> getTestSuiteList() {
        return this.testSuiteList;
    }

    public void addTestSuite(WUTResultTestSuite testSuite) {
        this.testSuiteList.add(testSuite);
    }

    public void addGlobalFailure(WUTGlobalFailure globalFailure) {
        this.globalFailureList.add(globalFailure);
    }

    public List<WUTGlobalFailure> getGlobalFailureList() {
        return this.globalFailureList;
    }
}

