/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.livereload;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Observable;
import java.util.Observer;
import javax.servlet.Servlet;
import org.eclipse.jetty.servlet.DefaultServlet;
import org.eclipse.jetty.util.resource.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.util.CollectionUtil;
import org.tizen.common.util.FilenameUtil;
import org.tizen.common.util.IOUtil;
import org.tizen.web.livereload.IResourceProvider;
import org.tizen.web.livereload.daemon.WebServer;
import org.tizen.web.livereload.servlet.LiveReloadSocketManager;
import org.tizen.web.livereload.servlet.VirtualResource;
import org.tizen.web.livereload.servlet.WebSocketMessage;
import org.tizen.web.livereload.util.CompositeInputStream;

public class LiveReload
implements Observer,
Closeable {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected static byte[] INJECTION = null;
    protected static String INJECTION_FORMAT = "<script>\nport = (location.port || location.host.split(':')[1] );\nif ( !port || port.length == 0 ) { portStr = ''; } else { portStr = ':' + port; }code = '<script src=\"http://'\n + (location.host || 'localhost').split(':')[0]\n + portStr  + '/livereload.js?snipver=1\"><\\/script>';\nconsole.log( code );\ndocument.write( code );\n</script>\n<style type=\"text/css\">[tizen-ide-status='selected'] {\n-moz-box-shadow:    inset 0 0 10px %s;\n-webkit-box-shadow: inset 0 0 10px %s;\nbox-shadow:         inset 0 0 10px %s;\n}</style>";
    protected boolean bEnabled = true;
    protected WebServer webServer;
    protected DefaultServlet servlet = new DefaultServlet(){
        private static final long serialVersionUID = 2320825957794195737L;

        public Resource getResource(String pathInContext) {
            try {
                Resource resource = LiveReload.this.getVirtualResource(pathInContext);
                if (resource == null) {
                    return super.getResource(pathInContext);
                }
                return resource;
            }
            catch (IOException iOException) {
                return super.getResource(pathInContext);
            }
        }
    };
    protected byte[] livereload;
    protected HashSet<String> loaded = new HashSet();
    protected final LiveReloadSocketManager webSocketManager = new LiveReloadSocketManager();
    protected IResourceProvider resourceProvider;

    public synchronized byte[] getLiveReload() throws IOException {
        if (this.livereload == null) {
            String path = String.valueOf(this.getClass().getPackage().getName().replace('.', '/')) + "/livereload.js";
            InputStream in = null;
            try {
                in = this.getClass().getClassLoader().getResourceAsStream(path);
                this.livereload = IOUtil.getBytes((InputStream)in, (boolean)true);
            }
            catch (Throwable throwable) {
                IOUtil.tryClose((Object[])new Object[]{in});
                throw throwable;
            }
            IOUtil.tryClose((Object[])new Object[]{in});
        }
        return this.livereload;
    }

    public byte[] getLiveReloadInjection() {
        return INJECTION;
    }

    public static void setLiveReloadInjection(String color) {
        INJECTION = String.format(INJECTION_FORMAT, color, color, color).getBytes();
    }

    public WebServer getWebServer() {
        return this.webServer;
    }

    public void setWebServer(WebServer webServer) {
        this.webServer = webServer;
    }

    public LiveReloadSocketManager getSocketManager() {
        return this.webSocketManager;
    }

    public Servlet getServlet() {
        return this.servlet;
    }

    public void setEnabled(boolean bEnabled) {
        this.bEnabled = bEnabled;
    }

    @Override
    public void update(Observable o, Object arg) {
        this.logger.trace("Observable: {}, Arg: {}", (Object)o, arg);
        if (arg instanceof WebSocketMessage) {
            try {
                this.webSocketManager.broadcast((WebSocketMessage)arg);
            }
            catch (IOException e) {
                this.logger.error("Can't send request", (Throwable)e);
            }
            return;
        }
        if (arg == null) {
            this.loaded.clear();
            this.reload(null);
            return;
        }
        Collection changed = (Collection)arg;
        this.logger.debug("changed :{}", (Object)changed);
        this.logger.debug("Before :{}", this.loaded);
        int before = this.loaded.size();
        for (String change : changed) {
            this.loaded.remove(FilenameUtil.getCanonicalForm((String)change));
        }
        this.logger.debug("After: {}", this.loaded);
        int after = this.loaded.size();
        if (before == after) {
            this.logger.info("No changed");
            return;
        }
        if (1 == changed.size()) {
            this.reload((String)CollectionUtil.pickupFirst((Collection)changed));
        } else {
            this.reload(null);
        }
    }

    public void reload(String path) {
        try {
            this.webSocketManager.reload(path);
            this.logger.info("Send reload request via websocket");
        }
        catch (IOException e) {
            this.logger.error("Can't send request", (Throwable)e);
        }
    }

    public Resource getVirtualResource(String path) throws IOException {
        this.logger.trace("Path :{}", (Object)path);
        if ("/livereload.js".equals(path)) {
            this.logger.trace("Injection mode");
            return new VirtualResource(null, new ByteArrayInputStream(this.getLiveReload()), this.getLiveReload().length);
        }
        InputStream in = this.getVirtualResourceAsStream(path);
        this.loaded.add(FilenameUtil.getCanonicalForm((String)path));
        this.logger.debug("Added {}", (Object)path);
        if (in == null) {
            this.logger.debug("Resource[{}] not found", (Object)path);
            return null;
        }
        this.logger.debug("Resource[{}] found", (Object)path);
        if (path.endsWith(".html")) {
            byte[] suffix = this.bEnabled ? this.getLiveReloadInjection() : "".getBytes();
            return new VirtualResource(null, new CompositeInputStream(Arrays.asList(in, new ByteArrayInputStream(suffix))), this.getVirtualResourceSize(path) + (long)suffix.length);
        }
        return new VirtualResource(null, in, this.getVirtualResourceSize(path));
    }

    protected InputStream getVirtualResourceAsStream(String path) throws IOException {
        return this.resourceProvider.getContents(path);
    }

    protected long getVirtualResourceSize(String path) throws IOException {
        return Math.max(0L, this.resourceProvider.getSize(path));
    }

    public IResourceProvider getResourceProvider() {
        return this.resourceProvider;
    }

    public void setResourceProvider(IResourceProvider resourceProvider) {
        this.resourceProvider = resourceProvider;
        this.logger.info("Resource provider: {}", (Object)resourceProvider);
    }

    @Override
    public void close() throws IOException {
        IOUtil.tryClose((Object[])new Object[]{this.webSocketManager});
    }
}

