/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.editor.javascript.navigation;

import org.eclipse.core.resources.IFile;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.dom.ASTNode;

class SymbolInformation
implements Comparable<SymbolInformation> {
    private ASTNode astNode = null;
    private String symbolName = null;
    private int symbolOffset = 0;
    private int symbolLength = 0;
    private int symbolLine = 0;
    private IFile file = null;
    private boolean isEditable = false;
    private IJavaScriptElement javaScriptElement = null;
    private String className = null;

    SymbolInformation(ASTNode astNode, String symbolName, int symbolOffset, int symbolLength, int symbolLine, IFile file, boolean isEditable, IJavaScriptElement javaScriptElement) {
        this.astNode = astNode;
        this.symbolName = symbolName;
        this.symbolOffset = symbolOffset;
        this.symbolLength = symbolLength;
        this.symbolLine = symbolLine;
        this.file = file;
        this.isEditable = isEditable;
        this.javaScriptElement = javaScriptElement;
    }

    SymbolInformation(ASTNode astNode, String symbolName, int symbolOffset, int symbolLength, int symbolLine, IFile file, boolean isEditable, IJavaScriptElement javaScriptElement, String className) {
        this.astNode = astNode;
        this.symbolName = symbolName;
        this.symbolOffset = symbolOffset;
        this.symbolLength = symbolLength;
        this.symbolLine = symbolLine;
        this.file = file;
        this.isEditable = isEditable;
        this.javaScriptElement = javaScriptElement;
        this.className = className;
    }

    public ASTNode getAstNode() {
        return this.astNode;
    }

    public void setAstNode(ASTNode astNode) {
        this.astNode = astNode;
    }

    public String getSymbolName() {
        return this.symbolName;
    }

    public void setSymbolName(String symbolName) {
        this.symbolName = symbolName;
    }

    public int getSymbolOffset() {
        return this.symbolOffset;
    }

    public void setSymbolOffset(int symbolOffset) {
        this.symbolOffset = symbolOffset;
    }

    public int getSymbolLength() {
        return this.symbolLength;
    }

    public void setSymbolLength(int symbolLength) {
        this.symbolLength = symbolLength;
    }

    public int getSymbolLine() {
        return this.symbolLine;
    }

    public void setSymbolLine(int symbolLine) {
        this.symbolLine = symbolLine;
    }

    public IFile getFile() {
        return this.file;
    }

    public void setFile(IFile file) {
        this.file = file;
    }

    public boolean isEditable() {
        return this.isEditable;
    }

    public void setEditable(boolean isEditable) {
        this.isEditable = isEditable;
    }

    public IJavaScriptElement getJavaScriptElement() {
        return this.javaScriptElement;
    }

    public void setJavaScriptElement(IJavaScriptElement javaScriptElement) {
        this.javaScriptElement = javaScriptElement;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    @Override
    public int compareTo(SymbolInformation compareObject) {
        String currentFileName = this.getFile().getName();
        String compareFileName = compareObject.getFile().getName();
        if (currentFileName != null && currentFileName.compareTo(compareFileName) == 0) {
            int compareSymbolType;
            int currentSymbolType = this.getAstNode().getNodeType();
            if (currentSymbolType == (compareSymbolType = compareObject.getAstNode().getNodeType())) {
                String currentSymbolName = this.getSymbolName();
                String compareSymbolName = compareObject.getSymbolName();
                if (currentSymbolName != null) {
                    if (currentSymbolName.equals(compareSymbolName)) {
                        String currentClassName = this.getClassName();
                        String compareClassName = compareObject.getClassName();
                        if (currentClassName != null && !currentClassName.equals(compareClassName)) {
                            return currentClassName.compareTo(compareClassName);
                        }
                        int currentSymbolLine = this.getSymbolLine();
                        int compareSymbolLine = compareObject.getSymbolLine();
                        return currentSymbolLine - compareSymbolLine;
                    }
                    return currentSymbolName.compareTo(compareSymbolName);
                }
            }
            return (currentSymbolType - compareSymbolType) / Math.abs(currentSymbolType - compareSymbolType);
        }
        if (currentFileName != null) {
            return currentFileName.compareTo(compareFileName);
        }
        return -1;
    }
}

