/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.css;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import org.w3c.css.css.DocumentParser;
import org.w3c.css.css.StyleReport;
import org.w3c.css.css.StyleReportFactory;
import org.w3c.css.css.StyleSheet;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.CssVersion;
import org.w3c.css.util.HTTPURL;
import org.w3c.css.util.Util;
import org.w3c.tools.resources.ProtocolException;
import org.w3c.www.mime.MimeType;

public class CssValidator {
    ApplContext ac;
    PrintWriter out;
    ArrayList<String> uris = new ArrayList();
    HashMap<String, String> params;
    static boolean showCSS = false;

    public CssValidator() {
        this.params = new HashMap();
        this.params.put("profile", CssVersion.getDefault().toString());
        this.params.put("medium", "all");
        this.params.put("output", "text");
        this.params.put("lang", "en");
        this.params.put("warning", "2");
        this.params.put("vextwarning", "false");
    }

    public CssValidator(String profile, String medium, String lang, int warninglevel, boolean vextwarning, boolean followlinks) {
        this.ac = new ApplContext(lang);
        this.ac.setCssVersionAndProfile(profile);
        this.ac.setMedium(medium);
        this.ac.setTreatVendorExtensionsAsWarnings(vextwarning);
        this.ac.setWarningLevel(warninglevel);
        this.ac.setFollowlinks(followlinks);
    }

    public void setOptionsFromParams() {
        String profile = this.params.get("profile");
        this.ac.setCssVersionAndProfile(profile);
        this.ac.setMedium(this.params.get("medium"));
        String vextwarn = this.params.get("vextwarning");
        this.ac.setTreatVendorExtensionsAsWarnings("true".equalsIgnoreCase(vextwarn));
    }

    public static void main(String[] args) throws IOException, MalformedURLException {
        CssValidator style = new CssValidator();
        try {
            style.getParams(args);
            style.ac = new ApplContext(style.params.get("lang"));
            System.out.println(style.params);
        }
        catch (Exception e) {
            System.out.println("Usage: java org.w3c.css.css.CssValidator  [OPTIONS] | [URL]*");
            System.out.println("OPTIONS");
            System.out.println("\t-p, --printCSS");
            System.out.println("\t\tPrints the validated CSS (only with text output, the CSS is printed with other outputs)");
            System.out.println("\t-profile PROFILE, --profile=PROFILE");
            System.out.println("\t\tChecks the Stylesheet against PROFILE");
            System.out.println("\t\tPossible values for PROFILE are css1, css2, css21 (default), css3, svg, svgbasic, svgtiny, atsc-tv, mobile, tv");
            System.out.println("\t-medium MEDIUM, --medium=MEDIUM");
            System.out.println("\t\tChecks the Stylesheet using the medium MEDIUM");
            System.out.println("\t\tPossible values for MEDIUM are all (default), aural, braille, embossed, handheld, print, projection, screen, tty, tv, presentation");
            System.out.println("\t-output OUTPUT, --output=OUTPUT");
            System.out.println("\t\tPrints the result in the selected format");
            System.out.println("\t\tPossible values for OUTPUT are text (default), xhtml, html (same result as xhtml), soap12");
            System.out.println("\t-lang LANG, --lang=LANG");
            System.out.println("\t\tPrints the result in the specified language");
            System.out.println("\t\tPossible values for LANG are de, en (default), es, fr, ja, ko, nl, zh-cn, pl, it");
            System.out.println("\t-warning WARN, --warning=WARN");
            System.out.println("\t\tWarnings verbosity level");
            System.out.println("\t\tPossible values for WARN are -1 (no warning), 0, 1, 2 (default, all the warnings");
            System.out.println("\t-vextwarning true, --vextwarning=true");
            System.out.println("\t\tTreat Vendor Extensions as warnings");
            System.out.println("\t\tPossible values for vextwarning are true or false (default, is false");
            System.out.println();
            System.out.println("URL");
            System.out.println("\tURL can either represent a distant web resource (http://) or a local file (file:/)");
            System.exit(1);
        }
        style.setOptionsFromParams();
        String encoding = style.ac.getMsg().getString("output-encoding-name");
        style.out = encoding != null ? new PrintWriter(new OutputStreamWriter((OutputStream)System.out, encoding)) : new PrintWriter(new OutputStreamWriter(System.out));
        for (int i = 0; i < style.uris.size(); ++i) {
            String uri = style.uris.get(i);
            if (uri == null) continue;
            try {
                uri = HTTPURL.getURL(uri).toString();
                DocumentParser URLparser = new DocumentParser(style.ac, uri);
                style.handleRequest(style.ac, uri, URLparser.getStyleSheet(), style.params.get("output"), Integer.parseInt(style.params.get("warning")), true);
                continue;
            }
            catch (ProtocolException pex) {
                if (!Util.onDebug) continue;
                pex.printStackTrace();
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void handleRequest(ApplContext ac, String title, StyleSheet styleSheet, String output, int warningLevel, boolean errorReport) throws Exception {
        if (styleSheet == null) {
            throw new IOException(ac.getMsg().getServletString("process") + " " + title);
        }
        styleSheet.findConflicts(ac);
        StyleReport style = StyleReportFactory.getStyleReport(ac, title, styleSheet, output, warningLevel);
        if (!errorReport) {
            style.desactivateError();
        }
        style.print(this.out);
    }

    public void handleCSSStyleSheet(ApplContext ac, Reader reader, URL docref) {
        DocumentParser parser = null;
        try {
            parser = new DocumentParser(ac, reader, docref.toString(), MimeType.TEXT_CSS);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        StyleSheet sheet = parser.getStyleSheet();
        sheet.findConflicts(ac);
    }

    public void handleHTMLStyleSheet(ApplContext ac, Reader reader, URL docref) {
        DocumentParser parser = null;
        try {
            parser = new DocumentParser(ac, reader, docref.toString(), MimeType.TEXT_HTML);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        StyleSheet sheet = parser.getStyleSheet();
        sheet.findConflicts(ac);
    }

    public void handleXMLStyleSheet(ApplContext ac, Reader reader, URL docref) {
        DocumentParser parser = null;
        try {
            parser = new DocumentParser(ac, reader, docref.toString(), MimeType.APPLICATION_XML);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        StyleSheet sheet = parser.getStyleSheet();
        sheet.findConflicts(ac);
    }

    private void getParams(String[] args) throws Exception {
        Iterator<String> iterator = Arrays.asList(args).iterator();
        while (iterator.hasNext()) {
            String paramName = "";
            String paramValue = "";
            String param = iterator.next();
            if (param.equals("--printCSS") || param.equals("-p")) {
                showCSS = true;
            } else if (param.startsWith("--")) {
                int separator = param.indexOf("=");
                paramName = param.substring(2, separator);
                paramValue = param.substring(separator + 1);
            } else if (param.startsWith("-")) {
                paramName = param.substring(1);
                paramValue = iterator.hasNext() ? iterator.next() : "";
            } else {
                this.uris.add(param);
            }
            if (paramName.length() == 0 || !this.params.containsKey(paramName)) continue;
            if (paramValue.length() == 0) {
                throw new Exception("You must specify a value for the parameter " + paramName);
            }
            this.params.put(paramName, paramValue);
        }
    }
}

