/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.zimlaunch.notification;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.swt.graphics.Color;
import org.tizen.common.launch.LaunchMessages;
import org.tizen.common.util.StringUtil;
import org.tizen.web.zimlaunch.notification.TizenWebConsole;
import org.tizen.web.zimlaunch.notification.TizenWebMoniter;

public class TizenWebNotifier {
    protected TizenWebConsole cs = null;
    protected TizenWebMoniter monitor = null;
    protected int totalWork = 100;
    protected int remainWork = 100;

    public TizenWebNotifier() {
    }

    public TizenWebNotifier(TizenWebMoniter monitor) {
        this.monitor = monitor;
    }

    public void notifyStep(String msg) {
        TizenWebConsole cs = this.getConsole();
        TizenWebMoniter mt = this.getMonitor();
        String name = String.valueOf(TizenWebConsole.NAME) + " <running> " + msg;
        this.changeConsoleName(name);
        cs.println(LaunchMessages.getStepTitle((String)msg));
        mt.subTask(msg);
    }

    public void notifyContents(String msg, int work) {
        TizenWebConsole cs = this.getConsole();
        TizenWebMoniter mt = this.getMonitor();
        if (!StringUtil.isEmpty((CharSequence)msg)) {
            cs.println(LaunchMessages.getStepMessage((String)msg));
            mt.subTask(msg);
        }
        if (this.remainWork > 1 && work < this.remainWork) {
            mt.worked(work);
            this.setRemainWork(this.remainWork - work);
        }
    }

    public void notifyContents(String msg) {
        TizenWebConsole cs = this.getConsole();
        TizenWebMoniter mt = this.getMonitor();
        if (!StringUtil.isEmpty((CharSequence)msg)) {
            cs.println(msg);
            mt.subTask(msg);
        }
    }

    public void notifyStart(String msg, int totalWork) {
        TizenWebConsole cs = this.getConsole();
        TizenWebMoniter mt = this.getMonitor();
        if (totalWork > 0) {
            this.setTotalWork(totalWork);
            this.setRemainWork(totalWork);
        }
        String name = String.valueOf(TizenWebConsole.NAME) + " <running> " + msg;
        this.changeConsoleName(name);
        cs.clear();
        cs.println(msg);
        mt.beginTask(name, totalWork);
        mt.subTask(msg);
    }

    public void notifyEnd(String msg, Color color) {
        TizenWebConsole cs = this.getConsole();
        TizenWebMoniter mt = this.getMonitor();
        String name = String.valueOf(TizenWebConsole.NAME) + " <terminated> " + msg;
        this.changeConsoleName(name);
        if (color != null) {
            cs.println(msg, 1, color);
        } else {
            cs.println(msg);
        }
        mt.done();
    }

    public TizenWebConsole getConsole() {
        if (this.cs == null) {
            this.cs = TizenWebConsole.getInstance();
        }
        return this.cs;
    }

    public void setConsole(TizenWebConsole console) {
        if (console == null) {
            return;
        }
        this.cs = console;
    }

    protected void changeConsoleName(String name) {
        TizenWebConsole cs = this.getConsole();
        try {
            cs.changeConsoleName(name);
        }
        catch (Exception exception) {}
    }

    public void setMonitor(TizenWebMoniter monitor) {
        if (monitor != null) {
            this.monitor = monitor;
        }
    }

    public TizenWebMoniter getMonitor() {
        if (this.monitor == null) {
            this.monitor = new TizenWebMoniter((IProgressMonitor)new NullProgressMonitor());
        }
        return this.monitor;
    }

    public void setTotalWork(int totalWork) {
        this.totalWork = totalWork < 0 ? 0 : totalWork;
    }

    public int getTotalWork() {
        return this.totalWork;
    }

    public void setRemainWork(int remainWork) {
        this.remainWork = remainWork < 0 ? 0 : remainWork;
    }

    public int getRemainWork() {
        return this.remainWork;
    }

    public int getPercentRemainWork(int percentage) {
        return (int)Math.round((double)(this.remainWork * percentage) / 100.0);
    }
}

