/*
 * Decompiled with CFR 0.152.
 */
package json.validation;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.Map;
import json.JsonLog;
import json.validation.JsonTextValidator;
import json.validation.Messages;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;

public class IncrementalJsonValidator
extends IncrementalProjectBuilder {
    public static final String BUILDER_ID = "json.validation.builder";
    public static final String MARKER_ID = "json.validation.marker";

    public static void addBuilderToProject(IProject project) {
        ICommand[] cmds;
        IProjectDescription description;
        if (!project.isOpen()) {
            return;
        }
        try {
            description = project.getDescription();
        }
        catch (CoreException e) {
            JsonLog.logError(Messages.IncrementalJsonValidator_3, e);
            return;
        }
        ICommand[] iCommandArray = cmds = description.getBuildSpec();
        int n = cmds.length;
        int n2 = 0;
        while (n2 < n) {
            ICommand cmd = iCommandArray[n2];
            if (cmd.getBuilderName().equals(BUILDER_ID)) {
                return;
            }
            ++n2;
        }
        ICommand newCmd = description.newCommand();
        newCmd.setBuilderName(BUILDER_ID);
        LinkedList<ICommand> newCmds = new LinkedList<ICommand>();
        newCmds.addAll(Arrays.asList(cmds));
        newCmds.add(newCmd);
        description.setBuildSpec(newCmds.toArray(new ICommand[newCmds.size()]));
        try {
            project.setDescription(description, null);
        }
        catch (CoreException e) {
            JsonLog.logError(Messages.IncrementalJsonValidator_2, e);
        }
    }

    public static void removeBuilderFromProject(IProject project) {
        IProjectDescription description;
        if (!project.isOpen()) {
            return;
        }
        try {
            description = project.getDescription();
        }
        catch (CoreException e) {
            JsonLog.logError(Messages.IncrementalJsonValidator_1, e);
            return;
        }
        ICommand[] cmds = description.getBuildSpec();
        LinkedList<ICommand> cmdsList = new LinkedList<ICommand>();
        cmdsList.addAll(Arrays.asList(cmds));
        ICommand removeCmd = null;
        for (ICommand cmd : cmdsList) {
            if (!cmd.getBuilderName().equals(BUILDER_ID)) continue;
            removeCmd = cmd;
        }
        if (removeCmd == null) {
            return;
        }
        cmdsList.addAll(Arrays.asList(cmds));
        cmdsList.remove(removeCmd);
        description.setBuildSpec(cmdsList.toArray(new ICommand[cmdsList.size()]));
        try {
            project.setDescription(description, null);
        }
        catch (CoreException e) {
            JsonLog.logError(Messages.IncrementalJsonValidator_0, e);
        }
    }

    protected IProject[] build(final int kind, Map args, IProgressMonitor monitor) throws CoreException {
        ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                IncrementalJsonValidator.this.validateJson(kind, monitor);
            }
        }, monitor);
        return null;
    }

    protected void clean(IProgressMonitor monitor) throws CoreException {
        super.clean(monitor);
    }

    private void validateJson(int kind, IProgressMonitor monitor) throws CoreException {
        final LinkedList validateFiles = new LinkedList();
        if (kind == 6) {
            IncrementalJsonValidator.deleteValidationMarkers(this.getProject());
            this.getProject().accept(new IResourceProxyVisitor(){

                public boolean visit(IResourceProxy proxy) throws CoreException {
                    String filename;
                    if (!proxy.isDerived() && (filename = proxy.requestFullPath().getFileExtension()) != null && filename.equalsIgnoreCase("json")) {
                        IFile file = IncrementalJsonValidator.this.getProject().getFile(proxy.requestResource().getProjectRelativePath());
                        validateFiles.add(file);
                    }
                    return true;
                }
            }, 0);
        } else {
            this.getDelta(this.getProject()).accept(new IResourceDeltaVisitor(){

                public boolean visit(IResourceDelta delta) throws CoreException {
                    String filename;
                    int deltaKind = delta.getKind();
                    if (deltaKind == 2 || deltaKind == 16) {
                        return true;
                    }
                    if (!delta.getResource().isDerived() && (filename = delta.getProjectRelativePath().getFileExtension()) != null && filename.equalsIgnoreCase("json")) {
                        IFile file = IncrementalJsonValidator.this.getProject().getFile(delta.getProjectRelativePath());
                        validateFiles.add(file);
                    }
                    return true;
                }
            });
        }
        if (validateFiles.size() == 0) {
            return;
        }
        monitor.beginTask(Messages.IncrementalJsonValidator_4, validateFiles.size());
        try {
            if (this.checkCancel(monitor)) {
                return;
            }
            for (IFile file : validateFiles) {
                this.deleteValidationMarker((IResource)file);
                JsonTextValidator jsonTextValidator = new JsonTextValidator(file);
                jsonTextValidator.parse();
                monitor.worked(1);
                if (!this.checkCancel(monitor)) continue;
                return;
            }
        }
        finally {
            monitor.done();
        }
    }

    private boolean checkCancel(IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        return this.isInterrupted();
    }

    public boolean deleteValidationMarker(IResource resource) {
        try {
            resource.deleteMarkers(MARKER_ID, false, 2);
            return true;
        }
        catch (CoreException e) {
            JsonLog.logError(e);
            return false;
        }
    }

    public static boolean deleteValidationMarkers(IProject project) {
        try {
            project.deleteMarkers(MARKER_ID, false, 2);
            return true;
        }
        catch (CoreException e) {
            JsonLog.logError(e);
            return false;
        }
    }
}

