/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.editor.configuration.validation;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.core.application.TizenProjectDescription;
import org.tizen.common.util.ProjectUtil;
import org.tizen.web.editor.configuration.validation.Input;
import org.tizen.web.editor.configuration.validation.SchemaBasedValidator;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;

public class ResourceResolver
implements LSResourceResolver {
    private Set<String> resoures = new HashSet<String>();
    private IProject project;
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    public ResourceResolver(IProject project) {
        this.project = project;
    }

    @Override
    public LSInput resolveResource(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
        if (this.resoures.contains(systemId)) {
            return null;
        }
        this.resoures.add(systemId);
        TizenProjectDescription tizenDesc = ProjectUtil.getTizenProjectDescription((IProject)this.project);
        if (!ProjectUtil.isSupportedPlatform((TizenProjectDescription)tizenDesc)) {
            return null;
        }
        String schemaFilePath = String.valueOf(tizenDesc.getPlatformInfo().getPlatformPath(tizenDesc.getVersion())) + SchemaBasedValidator.SCHEMAS_PATH + systemId;
        File file = new File(schemaFilePath);
        if (file.exists()) {
            Input input = new Input();
            try {
                input.setByteStream(new FileInputStream(file));
            }
            catch (FileNotFoundException e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
            return input;
        }
        return null;
    }
}

