/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.project.builder;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.tizen.common.util.ProjectUtil;

public class WebWidgetNature
implements IProjectNature {
    public static final String WEB_WIDGET_NATURE_ID = "org.tizen.web.project.builder.WebWidgetNature";
    private IProject project;
    private static Map<String, String> buildArgs = new HashMap<String, String>();

    public void configure() throws CoreException {
        ProjectUtil.setBuildCommandWithArgument((IProject)this.getProject(), (String)"org.tizen.web.project.builder.WebWidgetBuilder", buildArgs, null);
    }

    public void deconfigure() throws CoreException {
    }

    public IProject getProject() {
        return this.project;
    }

    public void setProject(IProject project) {
        this.project = project;
    }

    public static void addNature(IProject project, Map<String, String> newBuildArgs, IProgressMonitor monitor) throws CoreException {
        String[] natures;
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if (!project.exists()) {
            throw new CoreException((IStatus)new Status(4, "org.tizen.web.project", "Project does not exist. a nature cannot be added"));
        }
        IProjectDescription description = project.getDescription();
        String[] stringArray = natures = description.getNatureIds();
        int n = natures.length;
        int n2 = 0;
        while (n2 < n) {
            String nature = stringArray[n2];
            if (nature.equals(WEB_WIDGET_NATURE_ID)) {
                return;
            }
            ++n2;
        }
        if (!buildArgs.isEmpty()) {
            buildArgs.clear();
        }
        if (newBuildArgs != null) {
            buildArgs.putAll(newBuildArgs);
        }
        String[] newNatures = Arrays.copyOf(natures, natures.length + 1);
        newNatures[natures.length] = WEB_WIDGET_NATURE_ID;
        description.setNatureIds(newNatures);
        project.setDescription(description, monitor);
    }

    public static void addWebNature(IProject project, IProgressMonitor monitor) throws CoreException {
        String[] natures;
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if (!project.exists()) {
            throw new CoreException((IStatus)new Status(4, "org.tizen.web.project", "Project does not exist. a nature cannot be added"));
        }
        IProjectDescription description = project.getDescription();
        String[] stringArray = natures = description.getNatureIds();
        int n = natures.length;
        int n2 = 0;
        while (n2 < n) {
            String nature = stringArray[n2];
            if (nature.equals("org.tizen.web.project.builder.WebNature")) {
                return;
            }
            ++n2;
        }
        String[] newNatures = Arrays.copyOf(natures, natures.length + 1);
        newNatures[natures.length] = "org.tizen.web.project.builder.WebNature";
        description.setNatureIds(newNatures);
        project.setDescription(description, monitor);
    }
}

