/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.editor.javascript.hyperlink;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.ui.dialogs.ListDialog;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.html.core.internal.document.DOMStyleModelImpl;
import org.eclipse.wst.html.core.internal.document.ElementStyleImpl;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.xml.core.internal.document.AttrImpl;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.web.editor.contentassist.WebResourceManager;
import org.tizen.web.editor.javascript.JavaScriptEditorConstants;
import org.tizen.web.editor.javascript.hyperlink.OpenFileInformation;
import org.tizen.web.editor.javascript.hyperlink.StringLiteralHyperLinkOpenInformation;
import org.tizen.web.editor.javascript.util.JavaScriptEditorUtil;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class StringLiteralHyperLink
implements IHyperlink,
JavaScriptEditorConstants {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private ITextEditor textEditor;
    private final IRegion fRegion;
    private final StringLiteralHyperLinkOpenInformation linkInformation;
    private IFile javaScriptFile;
    private List<OpenFileInformation> openInformations = new ArrayList<OpenFileInformation>();

    public StringLiteralHyperLink(ITextEditor textEditor, IRegion fRegion, StringLiteralHyperLinkOpenInformation linkInformation, IFile javaScriptFile) {
        this.textEditor = textEditor;
        this.fRegion = fRegion;
        this.linkInformation = linkInformation;
        this.javaScriptFile = javaScriptFile;
        WebResourceManager resourceManager = new WebResourceManager(javaScriptFile.getProject());
        resourceManager.makeProjectManagedResourceMap();
        this.computeLinkInformation(resourceManager);
    }

    public IRegion getHyperlinkRegion() {
        return this.fRegion;
    }

    public String getTypeLabel() {
        return null;
    }

    public String getHyperlinkText() {
        return null;
    }

    public void open() {
        OpenFileInformation openFileInformation = null;
        if (this.openInformations == null || this.openInformations.size() == 0) {
            return;
        }
        if (this.openInformations.size() == 1) {
            openFileInformation = this.openInformations.get(0);
        } else if (this.openInformations.size() > 1 && (openFileInformation = this.openSelectionDialog()) == null) {
            return;
        }
        if (openFileInformation == null) {
            return;
        }
        IFile file = openFileInformation.getFile();
        int linkedValueOffset = openFileInformation.getLinkedValueOffset();
        int linkedValueLength = openFileInformation.getLinkedValueLength();
        JavaScriptEditorUtil.openEditor(file, linkedValueOffset, linkedValueLength);
    }

    private OpenFileInformation openSelectionDialog() {
        Object[] result;
        LabelProvider labelProvider = new LabelProvider(){

            public String getText(Object element) {
                OpenFileInformation openFileInformation = (OpenFileInformation)element;
                return String.valueOf(openFileInformation.getText()) + " (" + openFileInformation.getFile().getName() + " : " + openFileInformation.getLineNumber() + ")";
            }
        };
        ArrayContentProvider contentProvider = new ArrayContentProvider();
        ListDialog dialog = new ListDialog(this.textEditor.getSite().getShell());
        dialog.setTitle("Open Declaration of Parameter");
        dialog.setMessage("Select an item in order to open its location.");
        dialog.setLabelProvider((ILabelProvider)labelProvider);
        dialog.setInput(this.openInformations);
        dialog.setContentProvider((IStructuredContentProvider)contentProvider);
        dialog.setAddCancelButton(true);
        dialog.setHelpAvailable(false);
        dialog.setInitialElementSelections(Collections.singletonList(this.openInformations.get(0)));
        if (dialog.open() == 0 && (result = dialog.getResult()) != null && result.length > 0) {
            return (OpenFileInformation)result[0];
        }
        return null;
    }

    public StringLiteralHyperLinkOpenInformation getStringLiteralHyperLinkOpenInformation() {
        return this.linkInformation;
    }

    public void computeLinkInformation(WebResourceManager resourceManager) {
        Map htmlFiles = resourceManager.getHtmlFiles();
        if (htmlFiles == null || htmlFiles.size() == 0) {
            return;
        }
        List<IFile> foundLinkedHtmls = JavaScriptEditorUtil.findLinkedHtml(htmlFiles, this.javaScriptFile.getFullPath().toString());
        if (foundLinkedHtmls == null || foundLinkedHtmls.size() == 0) {
            return;
        }
        if (this.linkInformation != null) {
            switch (this.linkInformation.getType()) {
                case ID: {
                    this.findIdInformation(foundLinkedHtmls, this.linkInformation.getHyperLinkText());
                    break;
                }
                case NAME: {
                    this.findNameInformation(foundLinkedHtmls, this.linkInformation.getHyperLinkText());
                    break;
                }
                case TAG: {
                    this.findTagInformation(foundLinkedHtmls, this.linkInformation.getHyperLinkText());
                    break;
                }
                case CLASS: {
                    this.findClassInformation(foundLinkedHtmls, this.linkInformation.getHyperLinkText());
                    break;
                }
                case QUERY_SELECTOR: {
                    this.findSelectorInformation(foundLinkedHtmls, this.linkInformation.getHyperLinkText());
                    break;
                }
            }
        }
    }

    private void findSelectorInformation(List<IFile> foundLinkedHtmls, String hyperLinkText) {
        if (hyperLinkText == null || hyperLinkText.trim().equals("")) {
            return;
        }
        if (hyperLinkText.startsWith("#")) {
            hyperLinkText = hyperLinkText.substring(1);
            this.findIdInformation(foundLinkedHtmls, hyperLinkText);
        } else if (hyperLinkText.startsWith(".")) {
            hyperLinkText = hyperLinkText.substring(1);
            this.findClassInformation(foundLinkedHtmls, hyperLinkText);
        } else {
            this.findTagInformation(foundLinkedHtmls, hyperLinkText);
        }
    }

    private void findClassInformation(List<IFile> foundLinkedHtmls, String hyperLinkText) {
        int i = 0;
        while (i < foundLinkedHtmls.size()) {
            try {
                IDOMDocument document;
                List<ElementStyleImpl> elementsHaveClassAttribute;
                IFile file = foundLinkedHtmls.get(i);
                IStructuredModel model = StructuredModelManager.getModelManager().getModelForEdit(file);
                if (model != null && (elementsHaveClassAttribute = JavaScriptEditorUtil.getElementsHaveGivenNameAttribute(document = ((DOMStyleModelImpl)model).getDocument(), "class")).size() > 0) {
                    for (ElementStyleImpl element : elementsHaveClassAttribute) {
                        Attr attributeNode = element.getAttributeNode("class");
                        if (attributeNode == null || !hyperLinkText.equals(attributeNode.getValue())) continue;
                        int lineOfOffset = JavaScriptEditorUtil.getLineNumberOfElement((Node)element);
                        int elementStartOffset = element.getStartOffset();
                        ITextRegion valueRegion = ((AttrImpl)attributeNode).getValueRegion();
                        int start = elementStartOffset + valueRegion.getStart();
                        int length = valueRegion.getLength();
                        OpenFileInformation openFileInformation = new OpenFileInformation(JavaScriptEditorConstants.AdvanceStringLiteralHyperlinkType.ID, file, hyperLinkText, lineOfOffset, start, length);
                        this.openInformations.add(openFileInformation);
                    }
                }
            }
            catch (IOException e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
            catch (CoreException e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
            ++i;
        }
    }

    private void findTagInformation(List<IFile> foundLinkedHtmls, String hyperLinkText) {
        int i = 0;
        while (i < foundLinkedHtmls.size()) {
            try {
                IDOMDocument document;
                NodeList elementsByTagName;
                IFile file = foundLinkedHtmls.get(i);
                IStructuredModel model = StructuredModelManager.getModelManager().getModelForEdit(file);
                if (model != null && (elementsByTagName = (document = ((DOMStyleModelImpl)model).getDocument()).getElementsByTagName(hyperLinkText)) != null && elementsByTagName.getLength() > 0) {
                    int j = 0;
                    while (j < elementsByTagName.getLength()) {
                        Node item = elementsByTagName.item(j);
                        int lineOfOffset = JavaScriptEditorUtil.getLineNumberOfElement(item);
                        int start = ((ElementStyleImpl)item).getStartOffset();
                        int length = ((ElementStyleImpl)item).getLength();
                        OpenFileInformation openFileInformation = new OpenFileInformation(JavaScriptEditorConstants.AdvanceStringLiteralHyperlinkType.TAG, file, hyperLinkText, lineOfOffset, start, length);
                        this.openInformations.add(openFileInformation);
                        ++j;
                    }
                }
            }
            catch (IOException e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
            catch (CoreException e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
            ++i;
        }
    }

    private void findNameInformation(List<IFile> foundLinkedHtmls, String hyperLinkText) {
        int i = 0;
        while (i < foundLinkedHtmls.size()) {
            try {
                IDOMDocument document;
                List<ElementStyleImpl> elementsHaveIdAttribute;
                IFile file = foundLinkedHtmls.get(i);
                IStructuredModel model = StructuredModelManager.getModelManager().getModelForEdit(file);
                if (model != null && (elementsHaveIdAttribute = JavaScriptEditorUtil.getElementsHaveGivenNameAttribute(document = ((DOMStyleModelImpl)model).getDocument(), "name")).size() > 0) {
                    for (ElementStyleImpl element : elementsHaveIdAttribute) {
                        Attr attributeNode = element.getAttributeNode("name");
                        if (attributeNode == null || !hyperLinkText.equals(attributeNode.getValue())) continue;
                        int lineOfOffset = JavaScriptEditorUtil.getLineNumberOfElement((Node)element);
                        int elementStartOffset = element.getStartOffset();
                        ITextRegion valueRegion = ((AttrImpl)attributeNode).getValueRegion();
                        int start = elementStartOffset + valueRegion.getStart();
                        int length = valueRegion.getLength();
                        OpenFileInformation openFileInformation = new OpenFileInformation(JavaScriptEditorConstants.AdvanceStringLiteralHyperlinkType.NAME, file, hyperLinkText, lineOfOffset, start, length);
                        this.openInformations.add(openFileInformation);
                    }
                }
            }
            catch (IOException e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
            catch (CoreException e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
            ++i;
        }
    }

    private void findIdInformation(List<IFile> foundLinkedHtmls, String hyperLinkText) {
        int i = 0;
        while (i < foundLinkedHtmls.size()) {
            try {
                IDOMDocument document;
                List<ElementStyleImpl> elementsHaveIdAttribute;
                IFile file = foundLinkedHtmls.get(i);
                IStructuredModel model = StructuredModelManager.getModelManager().getModelForEdit(file);
                if (model != null && (elementsHaveIdAttribute = JavaScriptEditorUtil.getElementsHaveGivenNameAttribute(document = ((DOMStyleModelImpl)model).getDocument(), "id")).size() > 0) {
                    for (ElementStyleImpl element : elementsHaveIdAttribute) {
                        Attr attributeNode = element.getAttributeNode("id");
                        if (attributeNode == null || !hyperLinkText.equals(attributeNode.getValue())) continue;
                        int lineOfOffset = JavaScriptEditorUtil.getLineNumberOfElement((Node)element);
                        int elementStartOffset = element.getStartOffset();
                        ITextRegion valueRegion = ((AttrImpl)attributeNode).getValueRegion();
                        int start = elementStartOffset + valueRegion.getStart();
                        int length = valueRegion.getLength();
                        OpenFileInformation openFileInformation = new OpenFileInformation(JavaScriptEditorConstants.AdvanceStringLiteralHyperlinkType.ID, file, hyperLinkText, lineOfOffset, start, length);
                        this.openInformations.add(openFileInformation);
                    }
                }
            }
            catch (IOException e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
            catch (CoreException e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
            ++i;
        }
    }
}

