/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.project.wizard.ui;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.IOverwriteQuery;
import org.eclipse.ui.dialogs.WorkingSetGroup;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.wizards.datatransfer.DataTransferMessages;
import org.eclipse.ui.internal.wizards.datatransfer.ZipLeveledStructureProvider;
import org.eclipse.ui.wizards.datatransfer.FileSystemStructureProvider;
import org.eclipse.ui.wizards.datatransfer.IImportStructureProvider;
import org.eclipse.ui.wizards.datatransfer.ImportOperation;
import org.mihalis.opal.utils.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.core.application.InstallPathConfig;
import org.tizen.common.core.application.ProfileInfo;
import org.tizen.common.project.util.ProjectValidationUtil;
import org.tizen.common.sign.util.SignatureUtility;
import org.tizen.common.util.ArrayUtil;
import org.tizen.common.util.IOUtil;
import org.tizen.common.util.ProjectUtil;
import org.tizen.common.util.WorkspaceUtil;
import org.tizen.web.editor.configuration.ConfigurationException;
import org.tizen.web.project.wizard.WizardMessages;
import org.tizen.web.project.wizard.extension.ITemplateContributor;
import org.tizen.web.project.wizard.extension.ITemplateOptionControl;
import org.tizen.web.project.wizard.extension.WebProjectCreator;
import org.tizen.web.project.wizard.model.ProjectTemplate;
import org.tizen.web.project.wizard.model.SourceProject;
import org.tizen.web.project.wizard.operation.AbstractProjectTemplateOperation;
import org.tizen.web.project.wizard.operation.ContentAssistOperation;
import org.tizen.web.project.wizard.operation.DefaultNatureOperation;
import org.tizen.web.project.wizard.operation.IProjectTemplateOperation;
import org.tizen.web.project.wizard.ui.UIMessages;

public class WebProjectMigrationWizardPage
extends WizardPage
implements IOverwriteQuery {
    protected final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private static final String[] FILE_IMPORT_MASK = new String[]{"*.wgt"};
    private static String previouslyBrowsedDirectory = "";
    private static String previouslyBrowsedArchive = "";
    private IStructuredSelection currentSelection;
    protected Button projectFromDirectoryRadio;
    protected Text directoryPathField;
    protected Button browseDirectoriesButton;
    protected Button projectFromArchiveRadio;
    protected Text archivePathField;
    protected Button browseArchivesButton;
    protected Label currentProfileLabel;
    protected Text currentProfileField;
    protected Label toProfileLabel;
    protected Combo toProfileSelection;
    protected Text projectNameField;
    private WorkingSetGroup workingSetGroup;
    private SourceProject sourceProject = null;
    private List<String> allPlatforms;
    private String alwaysQueryState;

    public WebProjectMigrationWizardPage(String pageName, IStructuredSelection currentSelection) {
        super(pageName);
        this.currentSelection = currentSelection;
        this.setTitle(WizardMessages.WebProjectMigrationWizardPage_PageTitle);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite workArea = new Composite(parent, 0);
        this.setControl((Control)workArea);
        workArea.setLayout((Layout)new GridLayout());
        workArea.setLayoutData((Object)new GridData(1808));
        this.createProjectsRoot(workArea);
        this.createMigration(workArea);
        this.createWorkingSetGroup(workArea);
        this.updateInformation();
        Dialog.applyDialogFont((Control)workArea);
    }

    protected void createProjectsRoot(Composite workArea) {
        Composite projectGroup = new Composite(workArea, 0);
        GridLayout layout = new GridLayout(3, false);
        layout.marginWidth = 0;
        projectGroup.setLayout((Layout)layout);
        projectGroup.setLayoutData((Object)new GridData(768));
        this.projectFromDirectoryRadio = this.createRadioButton(projectGroup, WizardMessages.WebProjectMigrationWizardPage_DirectoryRadio, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WebProjectMigrationWizardPage.this.handleRadioSelected();
            }
        });
        this.directoryPathField = this.createTextField(projectGroup, true, new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 4) {
                    e.doit = false;
                    WebProjectMigrationWizardPage.this.updateCurrentProfile();
                    WebProjectMigrationWizardPage.this.updateInformation();
                }
            }
        }, (FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                WebProjectMigrationWizardPage.this.updateCurrentProfile();
                WebProjectMigrationWizardPage.this.updateInformation();
            }
        });
        this.directoryPathField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                WebProjectMigrationWizardPage.this.updateCurrentProfile();
                WebProjectMigrationWizardPage.this.updateInformation();
            }
        });
        this.browseDirectoriesButton = this.createPushButton(projectGroup, DataTransferMessages.DataTransfer_browse, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WebProjectMigrationWizardPage.this.handleLocationDirectoryButtonPressed();
            }
        });
        this.projectFromArchiveRadio = this.createRadioButton(projectGroup, UIMessages.getString("org.tizen.web.import.wizardpage.archivedialog.message"), (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WebProjectMigrationWizardPage.this.handleRadioSelected();
            }
        });
        this.archivePathField = this.createTextField(projectGroup, true, new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 4) {
                    e.doit = false;
                    WebProjectMigrationWizardPage.this.updateCurrentProfile();
                    WebProjectMigrationWizardPage.this.updateInformation();
                }
            }
        }, (FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                WebProjectMigrationWizardPage.this.updateCurrentProfile();
                WebProjectMigrationWizardPage.this.updateInformation();
            }
        });
        this.archivePathField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                WebProjectMigrationWizardPage.this.updateCurrentProfile();
                WebProjectMigrationWizardPage.this.updateInformation();
            }
        });
        this.browseArchivesButton = this.createPushButton(projectGroup, DataTransferMessages.DataTransfer_browse, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WebProjectMigrationWizardPage.this.handleLocationArchiveButtonPressed();
            }
        });
        this.projectFromDirectoryRadio.setSelection(true);
        this.archivePathField.setEnabled(false);
        this.browseArchivesButton.setEnabled(false);
    }

    private void handleRadioSelected() {
        boolean firstSelected = this.projectFromDirectoryRadio.getSelection();
        this.directoryPathField.setEnabled(firstSelected);
        this.browseDirectoriesButton.setEnabled(firstSelected);
        this.archivePathField.setEnabled(!firstSelected);
        this.browseArchivesButton.setEnabled(!firstSelected);
        if (firstSelected) {
            this.directoryPathField.setFocus();
        } else {
            this.archivePathField.setFocus();
        }
        this.updateCurrentProfile();
        this.updateInformation();
    }

    protected void handleLocationDirectoryButtonPressed() {
        DirectoryDialog dialog = new DirectoryDialog(this.directoryPathField.getShell(), 0x10000000);
        dialog.setMessage("");
        String dirName = this.directoryPathField.getText().trim();
        if (dirName.length() == 0) {
            dirName = previouslyBrowsedDirectory;
        }
        if (dirName.length() == 0) {
            dialog.setFilterPath(IDEWorkbenchPlugin.getPluginWorkspace().getRoot().getLocation().toOSString());
        } else {
            File path = new File(dirName);
            if (path.exists()) {
                dialog.setFilterPath(new Path(dirName).toOSString());
            }
        }
        String selectedDirectory = dialog.open();
        if (selectedDirectory != null) {
            previouslyBrowsedDirectory = selectedDirectory;
            this.directoryPathField.setText(previouslyBrowsedDirectory);
            this.updateCurrentProfile();
            this.updateInformation();
        }
    }

    protected void handleLocationArchiveButtonPressed() {
        FileDialog dialog = new FileDialog(this.archivePathField.getShell(), 0x10000000);
        dialog.setFilterExtensions(FILE_IMPORT_MASK);
        dialog.setText("");
        String fileName = this.archivePathField.getText().trim();
        if (fileName.length() == 0) {
            fileName = previouslyBrowsedArchive;
        }
        if (fileName.length() == 0) {
            dialog.setFilterPath(IDEWorkbenchPlugin.getPluginWorkspace().getRoot().getLocation().toOSString());
        } else {
            File path = new File(fileName).getParentFile();
            if (path != null && path.exists()) {
                dialog.setFilterPath(path.toString());
            }
        }
        String selectedArchive = dialog.open();
        if (selectedArchive != null) {
            previouslyBrowsedArchive = selectedArchive;
            this.archivePathField.setText(previouslyBrowsedArchive);
            this.updateCurrentProfile();
            this.updateInformation();
        }
    }

    private String getSelectedPath() {
        if (this.projectFromDirectoryRadio.getSelection()) {
            return this.directoryPathField.getText().trim();
        }
        return this.archivePathField.getText().trim();
    }

    private void updateCurrentProfile() {
        String path = this.getSelectedPath();
        this.sourceProject = new SourceProject(path);
        this.currentProfileField.setText(this.sourceProject.getPlatformName());
    }

    protected boolean isValidProject() {
        return this.sourceProject.isAvailableProject();
    }

    private void updateInformation() {
        String path = this.getSelectedPath();
        if (StringUtil.isEmpty((String)path)) {
            this.setMessage(UIMessages.getString("org.tizen.web.import.wizard.message"));
            this.setPageComplete(false);
            return;
        }
        File pathFile = new File(path);
        if (this.sourceProject == null || !pathFile.exists() || !this.projectFromDirectoryRadio.getSelection() && !this.sourceProject.isZipFile()) {
            this.setMessage("Not selected a source project directory or package file for migration", 3);
            this.setPageComplete(false);
            return;
        }
        if (!this.isValidProject()) {
            this.setMessage("It is not an importable project or a web application package", 3);
            this.setPageComplete(false);
            return;
        }
        if (this.toProfileSelection.getSelectionIndex() == -1) {
            this.setMessage("No selected profile for migration.", 3);
            this.setPageComplete(false);
            return;
        }
        String name = this.projectNameField.getText().trim();
        if (StringUtil.isEmpty((String)name)) {
            this.setMessage(WizardMessages.WebProjectMigrationWizardPage_EmptyProjectName, 3);
            this.setPageComplete(false);
            return;
        }
        if (!ProjectValidationUtil.isValidName((String)name)) {
            this.setMessage(WizardMessages.WebProjectMigrationWizardPage_InvalidProjectName, 3);
            this.setPageComplete(false);
            return;
        }
        boolean projectInWorkspace = this.isProjectInWorkspace(name);
        if (projectInWorkspace) {
            this.setMessage(DataTransferMessages.WizardProjectsImportPage_projectsInWorkspace, 3);
            this.setPageComplete(false);
            return;
        }
        this.setMessage("");
        this.setPageComplete(true);
    }

    private boolean isProjectInWorkspace(String projectName) {
        IProject[] workspaceProjects;
        if (StringUtil.isEmpty((String)projectName)) {
            return false;
        }
        IProject[] iProjectArray = workspaceProjects = IDEWorkbenchPlugin.getPluginWorkspace().getRoot().getProjects();
        int n = workspaceProjects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (projectName.equals(project.getName())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private ZipFile getSpecifiedZipSourceFile(String fileName) {
        if (StringUtil.isEmpty((String)fileName)) {
            return null;
        }
        try {
            return new ZipFile(fileName);
        }
        catch (ZipException zipException) {
            this.displayErrorDialog("");
        }
        catch (IOException iOException) {
            this.displayErrorDialog("");
        }
        this.archivePathField.setFocus();
        return null;
    }

    protected void displayErrorDialog(String message) {
        MessageDialog.open((int)1, (Shell)this.getContainer().getShell(), (String)"", (String)message, (int)0x10000000);
    }

    protected void createMigration(Composite workArea) {
        Composite composite = new Composite(workArea, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(768));
        this.currentProfileLabel = this.createLabel(composite, WizardMessages.WebProjectMigrationWizardPage_CurrentProfileLabel);
        this.currentProfileField = this.createTextField(composite, false, null, null);
        this.currentProfileField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Object[] allProfiles = WebProjectMigrationWizardPage.this.getAllProfiles();
                WebProjectMigrationWizardPage.this.toProfileSelection.setItems((String[])allProfiles);
                if (!ArrayUtil.isEmpty((Object[])allProfiles)) {
                    WebProjectMigrationWizardPage.this.toProfileSelection.select(0);
                }
            }
        });
        this.toProfileLabel = this.createLabel(composite, WizardMessages.WebProjectMigrationWizardPage_MigrateToLabel);
        this.toProfileSelection = this.createSelection(composite, this.getAllProfiles(), null);
        this.createLabel(composite, WizardMessages.WebProjectMigrationWizardPage_ProjectNameLabel);
        this.projectNameField = this.createTextField(composite, true, null, null);
        this.projectNameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                WebProjectMigrationWizardPage.this.updateInformation();
            }
        });
    }

    private String[] getAllProfiles() {
        if (this.allPlatforms == null) {
            ArrayList<String> result = new ArrayList<String>();
            for (ProfileInfo info : InstallPathConfig.flattenPlatformPathInfos()) {
                result.add(info.getLatestPlatformName());
            }
            this.allPlatforms = result;
        }
        return this.allPlatforms.toArray(new String[0]);
    }

    private ProfileInfo getProfileInfo(String platform) {
        for (ProfileInfo info : InstallPathConfig.flattenPlatformPathInfos()) {
            if (!platform.equals(info.getLatestPlatformName())) continue;
            return info;
        }
        return null;
    }

    protected void createWorkingSetGroup(Composite workArea) {
        this.workingSetGroup = new WorkingSetGroup(workArea, this.currentSelection, WorkspaceUtil.getIdsOfWorkingSetDescriptors());
    }

    private void addToWorkingSets(IProject createdProject) {
        IWorkingSet[] selectedWorkingSets = this.workingSetGroup.getSelectedWorkingSets();
        if (selectedWorkingSets == null || selectedWorkingSets.length == 0) {
            return;
        }
        IWorkingSetManager workingSetManager = PlatformUI.getWorkbench().getWorkingSetManager();
        workingSetManager.addToWorkingSets((IAdaptable)createdProject, selectedWorkingSets);
    }

    private void clearProject(String projectName) {
        if (StringUtil.isEmpty((String)projectName)) {
            return;
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject project = workspace.getRoot().getProject(projectName);
        try {
            project.delete(true, true, null);
        }
        catch (CoreException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public boolean createProject() {
        final String projectName = this.projectNameField.getText().trim();
        final String migrationProfile = this.toProfileSelection.getText().trim();
        final AtomicReference reference = new AtomicReference();
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    try {
                        monitor.beginTask("", 1);
                        IProject project = WebProjectMigrationWizardPage.this.createTo(projectName, migrationProfile, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                        reference.set(project);
                    }
                    catch (Exception e) {
                        WebProjectMigrationWizardPage.this.clearProject(projectName);
                        if (e instanceof InterruptedException) {
                            throw (InterruptedException)e;
                        }
                        if (e instanceof InvocationTargetException) {
                            throw (InvocationTargetException)e;
                        }
                        throw new InvocationTargetException(e);
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            this.getContainer().run(true, true, (IRunnableWithProgress)op);
            this.addToWorkingSets((IProject)reference.get());
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            String message = "";
            Object status = t instanceof CoreException ? ((CoreException)t).getStatus() : new Status(4, "org.eclipse.ui.ide", 1, message, t);
            ErrorDialog.openError((Shell)this.getShell(), (String)message, null, (IStatus)status);
            this.logger.error(t.getMessage(), t);
            return false;
        }
        return true;
    }

    public IProject createTo(String projectName, String toMigration, IProgressMonitor monitor) throws IOException, CoreException, InvocationTargetException, InterruptedException, ConfigurationException {
        String[] natures;
        IProjectDescription projectDesc;
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject project = workspace.getRoot().getProject(projectName);
        File projectDescriptionFile = this.sourceProject.getProjectDescriptioinFile();
        if (projectDescriptionFile != null) {
            FileInputStream is = new FileInputStream(projectDescriptionFile);
            try {
                projectDesc = workspace.loadProjectDescription((InputStream)is);
            }
            catch (Throwable throwable) {
                IOUtil.tryClose((Object[])new Object[]{is});
                throw throwable;
            }
            IOUtil.tryClose((Object[])new Object[]{is});
        } else {
            projectDesc = workspace.newProjectDescription(projectName);
        }
        projectDesc.setName(projectName);
        if (this.sourceProject.isZipFile()) {
            ZipLeveledStructureProvider structureProvider = null;
            try {
                structureProvider = this.sourceProject.getStructureProvider();
                List fileSystemObjects = structureProvider.getChildren(structureProvider.getRoot());
                fileSystemObjects = this.filterZipSourceList(fileSystemObjects, new File(this.sourceProject.getPath()));
                ImportOperation operation = new ImportOperation(project.getFullPath(), structureProvider.getRoot(), (IImportStructureProvider)structureProvider, (IOverwriteQuery)this, fileSystemObjects);
                operation.setContext(this.getShell());
                operation.run(monitor);
            }
            finally {
                if (structureProvider != null) {
                    structureProvider.closeArchive();
                }
            }
        }
        File importSource = null;
        URI locationURI = projectDesc.getLocationURI();
        if (locationURI != null) {
            importSource = new File(locationURI);
            IProjectDescription desc = workspace.newProjectDescription(projectName);
            desc.setBuildSpec(projectDesc.getBuildSpec());
            desc.setComment(projectDesc.getComment());
            desc.setDynamicReferences(projectDesc.getDynamicReferences());
            desc.setNatureIds(projectDesc.getNatureIds());
            desc.setReferencedProjects(projectDesc.getReferencedProjects());
            projectDesc = desc;
        }
        try {
            try {
                monitor.beginTask("", 100);
                project.create(projectDesc, (IProgressMonitor)new SubProgressMonitor(monitor, 30));
                project.open((IProgressMonitor)new SubProgressMonitor(monitor, 70));
            }
            catch (CoreException e) {
                throw new InvocationTargetException(e);
            }
        }
        finally {
            monitor.done();
        }
        File sourcePathFile = new File(this.sourceProject.getPath());
        List filesToImport = FileSystemStructureProvider.INSTANCE.getChildren((Object)sourcePathFile);
        this.filterFileSourceList(filesToImport, sourcePathFile);
        ImportOperation operation = new ImportOperation(project.getFullPath(), (Object)importSource, (IImportStructureProvider)FileSystemStructureProvider.INSTANCE, (IOverwriteQuery)this, filesToImport);
        operation.setContext(this.getShell());
        operation.setOverwriteResources(true);
        operation.setCreateContainerStructure(false);
        operation.run(monitor);
        Collection<IProjectTemplateOperation> operations = this.getProjectTemplateOperations(toMigration);
        for (IProjectTemplateOperation operation2 : operations) {
            if (operation2.execute(null, project, null)) continue;
            throw new OperationCanceledException();
        }
        IProjectDescription description = project.getDescription();
        String[] stringArray = natures = description.getNatureIds();
        int n = natures.length;
        int n2 = 0;
        while (n2 < n) {
            String nature = stringArray[n2];
            if (nature.equals("org.tizen.webuibuilder.nature")) {
                ITemplateContributor contributor = this.getUIBuilderContributeExtension();
                if (contributor == null) break;
                contributor.doAfter(project, new ITemplateOptionControl[0]);
                break;
            }
            ++n2;
        }
        WebProjectCreator creator = new WebProjectCreator(project);
        creator.initializeConfiguration(null);
        project.refreshLocal(2, null);
        return project;
    }

    protected Collection<IProjectTemplateOperation> getProjectTemplateOperations(final String toMigration) {
        AbstractProjectTemplateOperation migrateOperation = new AbstractProjectTemplateOperation(){

            @Override
            public boolean operation(ProjectTemplate template, IProject project, IProgressMonitor monitor) throws CoreException, IOException {
                ProfileInfo profileInfo = WebProjectMigrationWizardPage.this.getProfileInfo(toMigration);
                if (profileInfo != null) {
                    ProjectUtil.updateTizenProjectDescription((IProject)project, (ProfileInfo)profileInfo);
                }
                return true;
            }
        };
        migrateOperation.setMainTask(WizardMessages.WebProjectMigrationWizardPage_ProgressTask);
        LinkedList<IProjectTemplateOperation> operations = new LinkedList<IProjectTemplateOperation>();
        operations.add(migrateOperation);
        operations.add(new DefaultNatureOperation());
        operations.add(migrateOperation);
        operations.add(new ContentAssistOperation());
        return operations;
    }

    private void filterFileSourceList(List sources, File sourceRootPath) {
        sources.remove(new File(sourceRootPath, String.valueOf(sourceRootPath.getName()) + ".wgt"));
        sources.remove(new File(sourceRootPath, SignatureUtility.getAuthorFilename()));
        sources.remove(new File(sourceRootPath, SignatureUtility.getDistributorFilename((int)1)));
        sources.remove(new File(sourceRootPath, SignatureUtility.getDistributorFilename((int)2)));
    }

    private List filterZipSourceList(List sources, File sourceRootPath) {
        Object[] filterList = new String[]{sourceRootPath.getName(), SignatureUtility.getAuthorFilename(), SignatureUtility.getDistributorFilename((int)1), SignatureUtility.getDistributorFilename((int)2)};
        ArrayList<ZipEntry> filteredResult = new ArrayList<ZipEntry>();
        for (Object source : sources) {
            ZipEntry zipSource;
            String name;
            if (!(source instanceof ZipEntry) || ArrayUtil.contains((Object[])filterList, (Object)(name = (zipSource = (ZipEntry)source).getName()))) continue;
            filteredResult.add(zipSource);
        }
        return filteredResult;
    }

    public String queryOverwrite(String pathString) {
        String returnCode;
        if ("ALL".equals(this.alwaysQueryState)) {
            return "ALL";
        }
        if ("NOALL".equals(this.alwaysQueryState)) {
            return "NOALL";
        }
        Path path = new Path(pathString);
        String messageString = path.getFileExtension() == null || path.segmentCount() < 2 ? NLS.bind((String)IDEWorkbenchMessages.WizardDataTransfer_existsQuestion, (Object)pathString) : NLS.bind((String)IDEWorkbenchMessages.WizardDataTransfer_overwriteNameAndPathQuestion, (Object)path.lastSegment(), (Object)path.removeLastSegments(1).toOSString());
        final Dialog dialog = this.createQueryMessageDialog(messageString);
        this.getControl().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                dialog.open();
            }
        });
        String[] response = new String[]{"YES", "ALL", "NO", "NOALL", "CANCEL"};
        String string = returnCode = dialog.getReturnCode() < 0 ? "CANCEL" : response[dialog.getReturnCode()];
        if ("ALL".equals(returnCode) || "NOALL".equals(returnCode)) {
            this.alwaysQueryState = returnCode;
        }
        return returnCode;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            if (this.projectFromDirectoryRadio.getSelection()) {
                this.directoryPathField.setFocus();
            } else {
                this.archivePathField.setFocus();
            }
        }
    }

    private Dialog createQueryMessageDialog(String msg) {
        return new MessageDialog(this.getContainer().getShell(), "", null, msg, 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.YES_TO_ALL_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.NO_TO_ALL_LABEL, IDialogConstants.CANCEL_LABEL}, 0){

            protected int getShellStyle() {
                return super.getShellStyle() | 0x10000000;
            }
        };
    }

    private Button createPushButton(Composite parent, String text, SelectionListener selectionListener) {
        Button button = new Button(parent, 8);
        button.setText(text);
        this.setButtonLayoutData(button);
        if (selectionListener != null) {
            button.addSelectionListener(selectionListener);
        }
        return button;
    }

    private Button createRadioButton(Composite parent, String text, SelectionListener selectionListener) {
        Button button = new Button(parent, 16);
        button.setText(text);
        if (selectionListener != null) {
            button.addSelectionListener(selectionListener);
        }
        return button;
    }

    private Text createTextField(Composite parent, boolean modifiable, TraverseListener traverseListener, FocusListener focusListener) {
        Text field = new Text(parent, 2048);
        GridData directoryPathData = new GridData(4, 0, true, false);
        directoryPathData.widthHint = new PixelConverter((Control)field).convertWidthInCharsToPixels(25);
        field.setLayoutData((Object)directoryPathData);
        field.setEnabled(modifiable);
        if (traverseListener != null) {
            field.addTraverseListener(traverseListener);
        }
        if (focusListener != null) {
            field.addFocusListener(focusListener);
        }
        return field;
    }

    private Label createLabel(Composite parent, String text) {
        Label label = new Label(parent, 0);
        label.setText(text);
        return label;
    }

    private Combo createSelection(Composite parent, String[] items, SelectionListener selectionListener) {
        Combo combo = new Combo(parent, 2060);
        GridData directoryPathData = new GridData(4, 0, true, false);
        directoryPathData.widthHint = new PixelConverter((Control)combo).convertWidthInCharsToPixels(25);
        combo.setLayoutData((Object)directoryPathData);
        combo.setItems(items);
        if (combo.getItemCount() > 0) {
            combo.select(0);
        }
        if (selectionListener != null) {
            combo.addSelectionListener(selectionListener);
        }
        return combo;
    }

    private ITemplateContributor getUIBuilderContributeExtension() throws CoreException {
        IConfigurationElement[] configurationElements;
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = configurationElements = reg.getConfigurationElementsFor("org.tizen.web.project.templates");
        int n = configurationElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if ("template".equals(element.getName())) {
                IConfigurationElement[] iConfigurationElementArray2 = element.getChildren("contributeTemplate");
                int n3 = iConfigurationElementArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    Object obj;
                    IConfigurationElement childElement = iConfigurationElementArray2[n4];
                    String type = childElement.getAttribute("type");
                    if (type != null && type.equalsIgnoreCase("UIBuilder") && (obj = childElement.createExecutableExtension("class")) instanceof ITemplateContributor) {
                        return (ITemplateContributor)obj;
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return null;
    }
}

