/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.zimlaunch.deployer;

import java.util.concurrent.CancellationException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.model.LaunchConfigurationDelegate;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.CommonPlugin;
import org.tizen.common.connection.ConnectionPlugin;
import org.tizen.common.core.application.ProfileInfo;
import org.tizen.common.core.application.Version;
import org.tizen.common.core.command.Executor;
import org.tizen.common.launch.LaunchMessages;
import org.tizen.common.launch.context.ILaunchContext;
import org.tizen.common.launch.context.LaunchContext;
import org.tizen.common.sign.preferences.UIMessages;
import org.tizen.common.sign.ui.SigningPrompter;
import org.tizen.common.ui.CommonColor;
import org.tizen.common.util.Assert;
import org.tizen.common.util.DialogUtil;
import org.tizen.common.util.PlatformInformationUtil;
import org.tizen.common.util.SWTUtil;
import org.tizen.common.util.log.FileAppender;
import org.tizen.common.util.log.UserLogger;
import org.tizen.sdblib.IDevice;
import org.tizen.web.common.util.ProjectUtil;
import org.tizen.web.editor.configuration.ConfigurationException;
import org.tizen.web.project.builder.BuildResourceManager;
import org.tizen.web.project.builder.HybridAppBuilder;
import org.tizen.web.zimlaunch.Activator;
import org.tizen.web.zimlaunch.constants.LaunchType;
import org.tizen.web.zimlaunch.constants.TizenWebLaunchConstants;
import org.tizen.web.zimlaunch.core.CompositeStep;
import org.tizen.web.zimlaunch.core.IStep;
import org.tizen.web.zimlaunch.deployer.IStepFactory;
import org.tizen.web.zimlaunch.deployer.Messages;
import org.tizen.web.zimlaunch.deployer.StepFactory;
import org.tizen.web.zimlaunch.exception.TizenWebIDEException;
import org.tizen.web.zimlaunch.notification.TizenWebMoniter;
import org.tizen.web.zimlaunch.notification.TizenWebNotifier;
import org.tizen.web.zimlaunch.resource.TizenDeviceInfo;
import org.tizen.web.zimlaunch.resource.TizenWebAppInfo;
import org.tizen.web.zimlaunch.resource.ZimLaunchResource;
import org.tizen.web.zimlaunch.step.InitLaunchStep;
import org.tizen.web.zimlaunch.util.ExtensionUtil;
import org.tizen.web.zimlaunch.util.LaunchUtil;

public class ZimLaunchDelegate
extends LaunchConfigurationDelegate {
    protected static final Logger logger = LoggerFactory.getLogger(ZimLaunchDelegate.class);
    public static String USER_STOP_MSG = "User stop progress...";
    public static String UNEXPECTED_STOP_MSG = "Unexpected stop progress...";
    protected TizenWebMoniter monitor = null;
    protected boolean isUsersToStop = false;
    protected boolean isExceptionToStop = false;
    protected TizenWebNotifier notifier = null;
    public static final String PREF_KEY_HYBRID_DEBUG = "org.tizen.web.zimlaunch.deployer.hybriddebug";
    public static final String PREF_KEY_HYBRID_MULTI_DEBUG = "org.tizen.web.zimlaunch.deployer.hybridmultidebug";

    public boolean preLaunchCheck(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        boolean launchAvailable;
        IDevice device = null;
        IProject project = null;
        project = LaunchUtil.getProject((ILaunchConfiguration)configuration);
        try {
            device = ConnectionPlugin.getDefault().getTargetToolBarManager().getDefaultLaunchTarget(project, monitor);
        }
        catch (CoreException coreException) {
            logger.info("Launch is going to stop because default target is not ready");
            return false;
        }
        if (device == null) {
            return false;
        }
        try {
            if (LaunchUtil.isWebServiceApplication(project)) {
                String check = org.tizen.common.sign.preferences.Messages.bind((String)UIMessages.getString((String)"org.tizen.common.sign.partnerlevelcertificatecheck"), (Object)UIMessages.getString((String)"org.tizen.common.sign.preference"));
                SigningPrompter sp = new SigningPrompter();
                sp.check(check, project);
            }
        }
        catch (ConfigurationException configurationException) {
            logger.error("Fail to check of application type");
        }
        if (ProjectUtil.isWebWidgetProject((IProject)project)) {
            if (this.isDebug(mode)) {
                Executor executor = CommonPlugin.getDefault().getExecutor();
                executor.getContext().getPrompter().notify(Messages.DEBUG_MESSAGE_WEB_WIDGET);
                return false;
            }
            if (!this.isSupportedWebWidget(device)) {
                return false;
            }
        }
        if (!(launchAvailable = LaunchUtil.checkProfile((IDevice)device, (IProject)LaunchUtil.getProject((ILaunchConfiguration)configuration)))) {
            return false;
        }
        String deviceSerialNum = device.getSerialNumber();
        this.setDeviceNo(configuration, deviceSerialNum);
        try {
            configuration.getAttribute(TizenWebLaunchConstants.ATTR_LATEST_LAUNCH_TYPE, LaunchType.UNKNOWN.ordinal());
        }
        catch (CoreException e) {
            logger.error(e.getMessage(), (Throwable)e);
            ILaunchConfigurationWorkingCopy wc = configuration.getWorkingCopy();
            wc.setAttribute(TizenWebLaunchConstants.ATTR_LATEST_LAUNCH_TYPE, LaunchType.UNKNOWN.ordinal());
        }
        return super.preLaunchCheck(configuration, mode, monitor) && !monitor.isCanceled();
    }

    private boolean isDebug(String mode) {
        return mode.equals("debug");
    }

    private boolean isSupportedWebWidget(IDevice device) {
        Version version = null;
        String profileName = null;
        try {
            version = new Version(PlatformInformationUtil.getPlatformVersion((IDevice)device));
            profileName = device.getPlatformInfo().getProfileName();
        }
        catch (Exception e) {
            logger.error("Platform version is not distinct", (Throwable)e);
            return false;
        }
        if (version.compareTo(new Version("2.3.2")) < 0 || !profileName.equals("wearable")) {
            Executor executor = CommonPlugin.getDefault().getExecutor();
            executor.getContext().getPrompter().notify(Messages.ERR_MESSAGE_WEB_WIDGET);
            return false;
        }
        return true;
    }

    private void setDeviceNo(ILaunchConfiguration configuration, String deviceSerialNum) throws CoreException {
        ILaunchConfigurationWorkingCopy wc = configuration.getWorkingCopy();
        wc.setAttribute("org.tizen.commonCONFIG_ATTR_DEVICE_SERIAL_NO", deviceSerialNum);
        configuration = wc.doSave();
    }

    private void preLaunch(ILaunchConfiguration configuration, String mode, ILaunch launch, LaunchContext ctx, IProgressMonitor monitor) throws Exception {
        this.isUsersToStop = false;
        this.isExceptionToStop = false;
        this.monitor = new TizenWebMoniter((IProgressMonitor)(monitor != null ? monitor : new NullProgressMonitor()));
        this.notifier = new TizenWebNotifier(this.monitor);
        this.notifier.getConsole().show();
        FileAppender fileAppender = (FileAppender)org.apache.log4j.Logger.getRootLogger().getAppender("TIZEN_FILE_APPENDER");
        String logPath = fileAppender != null ? fileAppender.getLogPath() : "";
        this.notifier.notifyStart(NLS.bind((String)LaunchMessages.LAUNCH_START, (Object)logPath), 200);
        ctx.setValue((Object)"notifier", (Object)this.notifier);
        CompositeStep step = new CompositeStep(new InitLaunchStep(configuration, mode, launch));
        step.executeStep((ILaunchContext)ctx);
    }

    /*
     * Loose catch block
     */
    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        block79: {
            IProject project;
            Long startTime;
            Exception ex;
            block78: {
                Throwable throwable222;
                block80: {
                    IStep step;
                    LaunchContext context;
                    block76: {
                        block77: {
                            IDevice device;
                            block74: {
                                block75: {
                                    ex = null;
                                    startTime = System.currentTimeMillis();
                                    project = LaunchUtil.getProject((ILaunchConfiguration)configuration);
                                    Assert.notNull((Object)project);
                                    UserLogger.start((String)"web.launch");
                                    device = LaunchUtil.getDevice((ILaunchConfiguration)configuration, (String)"org.tizen.commonCONFIG_ATTR_DEVICE_SERIAL_NO");
                                    if (device == null) {
                                        device = ConnectionPlugin.getDefault().getCurrentDevice();
                                    }
                                    if ((context = this.initContext(project, device, mode)) == null) {
                                        TizenWebIDEException.abort("A problem occurred while checking context", null, new TizenWebNotifier[0]);
                                    }
                                    this.preLaunch(configuration, mode, launch, context, monitor);
                                    if (this.checkConfigFile(project)) break block74;
                                    try {
                                        DebugPlugin.getDefault().getLaunchManager().removeLaunch(launch);
                                        if (project != null) {
                                            BuildResourceManager.setProjectCleanBuildState((IProject)project, (Boolean)false);
                                            project.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
                                            this.setLatestLaunchType(configuration, project, mode);
                                        }
                                        if (!this.isExceptionToStop && !this.isUsersToStop) {
                                            monitor.worked(200);
                                            try {
                                                this.notifier.notifyEnd(LaunchMessages.LAUNCH_END, null);
                                                if (!LaunchUtil.canRun(project)) {
                                                    this.notifier.notifyEnd(NLS.bind((String)Messages.LAUNCH_END_WITHOUT_RUN, (Object)mode), null);
                                                }
                                                break block75;
                                            }
                                            catch (ConfigurationException configurationException) {}
                                            break block75;
                                        }
                                        if (this.isExceptionToStop && ex != null) {
                                            this.notifier.notifyEnd(UNEXPECTED_STOP_MSG, CommonColor.RED);
                                            Throwable cause = ex;
                                            while (cause.getCause() != null) {
                                                cause = cause.getCause();
                                            }
                                            TizenWebIDEException.abort(ex.getMessage(), cause, new TizenWebNotifier[0]);
                                        }
                                    }
                                    finally {
                                        monitor.done();
                                        this.notifier.notifyContents(LaunchMessages.getElapsedTimeMessage((Long)startTime, (Long)System.currentTimeMillis()));
                                        UserLogger.end((String)"web.launch");
                                    }
                                }
                                return;
                            }
                            if (project == null) {
                                TizenWebIDEException.abort(LaunchMessages.PROJECT_NOT_FOUND, null, new TizenWebNotifier[0]);
                            }
                            if (device == null) {
                                TizenWebIDEException.abort(Messages.CONNECT_DEVICE_FAILED, null, new TizenWebNotifier[0]);
                            }
                            if ("launched already".equals(launch.getAttribute("LAUNCH_ATTR_KEY_IS_LAUNCHING"))) {
                                logger.debug("the {} project is already launching.(device serial: {})", (Object)project.getName(), (Object)device.getSerialNumber());
                                throw new CoreException((IStatus)new Status(4, "org.tizen.web.zimlaunch", NLS.bind((String)LaunchMessages.LAUNCHED_ALREADY, (Object)project.getName())));
                            }
                            step = this.createStep(device, configuration, mode, (Boolean)context.getValue((Object)"widget installation"));
                            if (step != null) break block76;
                            try {
                                DebugPlugin.getDefault().getLaunchManager().removeLaunch(launch);
                                if (project != null) {
                                    BuildResourceManager.setProjectCleanBuildState((IProject)project, (Boolean)false);
                                    project.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
                                    this.setLatestLaunchType(configuration, project, mode);
                                }
                                if (!this.isExceptionToStop && !this.isUsersToStop) {
                                    monitor.worked(200);
                                    try {
                                        this.notifier.notifyEnd(LaunchMessages.LAUNCH_END, null);
                                        if (!LaunchUtil.canRun(project)) {
                                            this.notifier.notifyEnd(NLS.bind((String)Messages.LAUNCH_END_WITHOUT_RUN, (Object)mode), null);
                                        }
                                        break block77;
                                    }
                                    catch (ConfigurationException configurationException) {}
                                    break block77;
                                }
                                if (this.isExceptionToStop && ex != null) {
                                    this.notifier.notifyEnd(UNEXPECTED_STOP_MSG, CommonColor.RED);
                                    Throwable cause = ex;
                                    while (cause.getCause() != null) {
                                        cause = cause.getCause();
                                    }
                                    TizenWebIDEException.abort(ex.getMessage(), cause, new TizenWebNotifier[0]);
                                }
                            }
                            finally {
                                monitor.done();
                                this.notifier.notifyContents(LaunchMessages.getElapsedTimeMessage((Long)startTime, (Long)System.currentTimeMillis()));
                                UserLogger.end((String)"web.launch");
                            }
                        }
                        return;
                    }
                    try {
                        IProject[] refNativeProjects = ProjectUtil.getReferencedNativeProjects((IProject)project);
                        if (this.isDebug(mode) && refNativeProjects.length > 0) {
                            this.openDebuggingHybridAppMsgDlg(refNativeProjects.length);
                        }
                        step.executeStep((ILaunchContext<?>)context);
                        LaunchUtil.setFullInstall(project, false);
                        break block78;
                    }
                    catch (CancellationException cancellationException) {
                        logger.debug(Messages.LAUNCH_CANCELED);
                        this.isExceptionToStop = true;
                        try {
                            DebugPlugin.getDefault().getLaunchManager().removeLaunch(launch);
                            if (project != null) {
                                BuildResourceManager.setProjectCleanBuildState((IProject)project, (Boolean)false);
                                project.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
                                this.setLatestLaunchType(configuration, project, mode);
                            }
                            if (!this.isExceptionToStop && !this.isUsersToStop) {
                                monitor.worked(200);
                                try {
                                    this.notifier.notifyEnd(LaunchMessages.LAUNCH_END, null);
                                    if (!LaunchUtil.canRun(project)) {
                                        this.notifier.notifyEnd(NLS.bind((String)Messages.LAUNCH_END_WITHOUT_RUN, (Object)mode), null);
                                    }
                                    break block79;
                                }
                                catch (ConfigurationException configurationException) {}
                                break block79;
                            }
                            if (this.isExceptionToStop && ex != null) {
                                this.notifier.notifyEnd(UNEXPECTED_STOP_MSG, CommonColor.RED);
                                Throwable cause = ex;
                                while (cause.getCause() != null) {
                                    cause = cause.getCause();
                                }
                                TizenWebIDEException.abort(ex.getMessage(), cause, new TizenWebNotifier[0]);
                            }
                            break block79;
                        }
                        finally {
                            monitor.done();
                            this.notifier.notifyContents(LaunchMessages.getElapsedTimeMessage((Long)startTime, (Long)System.currentTimeMillis()));
                            UserLogger.end((String)"web.launch");
                        }
                    }
                    catch (Exception e) {
                        this.isExceptionToStop = true;
                        logger.debug(e.getMessage());
                        ex = e;
                        try {
                            DebugPlugin.getDefault().getLaunchManager().removeLaunch(launch);
                            if (project != null) {
                                BuildResourceManager.setProjectCleanBuildState((IProject)project, (Boolean)false);
                                project.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
                                this.setLatestLaunchType(configuration, project, mode);
                            }
                            if (!this.isExceptionToStop && !this.isUsersToStop) {
                                monitor.worked(200);
                                try {
                                    this.notifier.notifyEnd(LaunchMessages.LAUNCH_END, null);
                                    if (!LaunchUtil.canRun(project)) {
                                        this.notifier.notifyEnd(NLS.bind((String)Messages.LAUNCH_END_WITHOUT_RUN, (Object)mode), null);
                                    }
                                    break block79;
                                }
                                catch (ConfigurationException configurationException) {}
                                break block79;
                            }
                            if (this.isExceptionToStop && ex != null) {
                                this.notifier.notifyEnd(UNEXPECTED_STOP_MSG, CommonColor.RED);
                                Throwable cause = ex;
                                while (cause.getCause() != null) {
                                    cause = cause.getCause();
                                }
                                TizenWebIDEException.abort(ex.getMessage(), cause, new TizenWebNotifier[0]);
                            }
                            break block79;
                        }
                        finally {
                            monitor.done();
                            this.notifier.notifyContents(LaunchMessages.getElapsedTimeMessage((Long)startTime, (Long)System.currentTimeMillis()));
                            UserLogger.end((String)"web.launch");
                        }
                        catch (Throwable throwable222) {
                            try {
                                DebugPlugin.getDefault().getLaunchManager().removeLaunch(launch);
                                if (project != null) {
                                    BuildResourceManager.setProjectCleanBuildState((IProject)project, (Boolean)false);
                                    project.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
                                    this.setLatestLaunchType(configuration, project, mode);
                                }
                                if (!this.isExceptionToStop && !this.isUsersToStop) {
                                    monitor.worked(200);
                                    try {
                                        this.notifier.notifyEnd(LaunchMessages.LAUNCH_END, null);
                                        if (!LaunchUtil.canRun(project)) {
                                            this.notifier.notifyEnd(NLS.bind((String)Messages.LAUNCH_END_WITHOUT_RUN, (Object)mode), null);
                                        }
                                        break block80;
                                    }
                                    catch (ConfigurationException configurationException) {}
                                    break block80;
                                }
                                if (this.isExceptionToStop && ex != null) {
                                    this.notifier.notifyEnd(UNEXPECTED_STOP_MSG, CommonColor.RED);
                                    Throwable cause = ex;
                                    while (cause.getCause() != null) {
                                        cause = cause.getCause();
                                    }
                                    TizenWebIDEException.abort(ex.getMessage(), cause, new TizenWebNotifier[0]);
                                }
                            }
                            finally {
                                monitor.done();
                                this.notifier.notifyContents(LaunchMessages.getElapsedTimeMessage((Long)startTime, (Long)System.currentTimeMillis()));
                                UserLogger.end((String)"web.launch");
                            }
                        }
                    }
                }
                throw throwable222;
            }
            try {
                DebugPlugin.getDefault().getLaunchManager().removeLaunch(launch);
                if (project != null) {
                    BuildResourceManager.setProjectCleanBuildState((IProject)project, (Boolean)false);
                    project.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
                    this.setLatestLaunchType(configuration, project, mode);
                }
                if (!this.isExceptionToStop && !this.isUsersToStop) {
                    monitor.worked(200);
                    try {
                        this.notifier.notifyEnd(LaunchMessages.LAUNCH_END, null);
                        if (!LaunchUtil.canRun(project)) {
                            this.notifier.notifyEnd(NLS.bind((String)Messages.LAUNCH_END_WITHOUT_RUN, (Object)mode), null);
                        }
                        break block79;
                    }
                    catch (ConfigurationException configurationException) {}
                    break block79;
                }
                if (this.isExceptionToStop && ex != null) {
                    this.notifier.notifyEnd(UNEXPECTED_STOP_MSG, CommonColor.RED);
                    Throwable cause = ex;
                    while (cause.getCause() != null) {
                        cause = cause.getCause();
                    }
                    TizenWebIDEException.abort(ex.getMessage(), cause, new TizenWebNotifier[0]);
                }
            }
            finally {
                monitor.done();
                this.notifier.notifyContents(LaunchMessages.getElapsedTimeMessage((Long)startTime, (Long)System.currentTimeMillis()));
                UserLogger.end((String)"web.launch");
            }
        }
    }

    protected IStepFactory getStepFactory(IDevice device, String profile, Version version) throws CoreException {
        IStepFactory extendedStepFactory = ExtensionUtil.getExtendedExecutable(IStepFactory.class, "stepFactory", "org.tizen.web.zimlaunch", device, profile, version);
        if (extendedStepFactory != null) {
            return extendedStepFactory;
        }
        return new StepFactory();
    }

    private IStep createStep(IDevice device, ILaunchConfiguration configuration, String mode, boolean isInstalled) throws CoreException, ConfigurationException {
        IProject project = LaunchUtil.getProject((ILaunchConfiguration)configuration);
        ProfileInfo info = ProjectUtil.getTizenProjectDescription((IProject)project).getPlatformInfo();
        String profile = info.isProduct() ? info.getParentProfile() : info.getProfile();
        Version version = new Version(ProjectUtil.getTizenProjectDescription((IProject)project).getVersion());
        return this.getStepFactory(device, profile, version).createStep(configuration, mode, isInstalled);
    }

    private void setLatestLaunchType(ILaunchConfiguration configuration, IProject project, String mode) throws CoreException {
        int launchType = LaunchUtil.getCurrentLaunchType(configuration, project, mode);
        IResource resource = (IResource)project.getAdapter(IResource.class);
        resource.setPersistentProperty(new QualifiedName("org.tizen.web.zimlaunch", String.valueOf(TizenWebLaunchConstants.ATTR_LATEST_LAUNCH_TYPE) + configuration.getAttribute("org.tizen.commonCONFIG_ATTR_DEVICE_SERIAL_NO", "")), Integer.toString(launchType));
    }

    private void openDebuggingHybridAppMsgDlg(final int numRefProjects) {
        if (numRefProjects < 1) {
            return;
        }
        SWTUtil.syncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                Shell shell;
                IPreferenceStore store;
                String msg = Messages.DEBUG_HYBRID_APP;
                String dialogKey = ZimLaunchDelegate.PREF_KEY_HYBRID_DEBUG;
                if (numRefProjects > 1) {
                    dialogKey = ZimLaunchDelegate.PREF_KEY_HYBRID_MULTI_DEBUG;
                    msg = Messages.CANNOT_SUPPORT_DEBUG_MULTI_HYBRID_APP;
                }
                if (!(store = Activator.getDefault().getPreferenceStore()).getBoolean(dialogKey) && (shell = DialogUtil.getActiveShell()) != null) {
                    boolean toggleState = MessageDialogWithToggle.openInformation((Shell)shell, (String)"Debugging hybrid application", (String)msg, (String)"Do not show this message again.", (boolean)false, (IPreferenceStore)store, (String)dialogKey).getToggleState();
                    store.setValue(dialogKey, toggleState);
                }
                ZimLaunchDelegate.this.notifier.notifyContents(msg, 0);
            }
        });
    }

    public boolean buildForLaunch(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        IDevice device;
        boolean result = false;
        IProject project = LaunchUtil.getProject((ILaunchConfiguration)configuration);
        if (project == null) {
            return false;
        }
        if (!project.isSynchronized(2)) {
            project.refreshLocal(2, null);
        }
        try {
            device = LaunchUtil.getDevice((ILaunchConfiguration)configuration, (String)"org.tizen.commonCONFIG_ATTR_DEVICE_SERIAL_NO");
            if (device != null) {
                HybridAppBuilder.checkArchitecture((IProject)project, (IDevice)device);
            }
        }
        catch (Exception e) {
            TizenWebIDEException.abort("A problem occurred while checking architectures", e, new TizenWebNotifier[0]);
        }
        String devSerialNum = (device = LaunchUtil.getDevice((ILaunchConfiguration)configuration, (String)"org.tizen.commonCONFIG_ATTR_DEVICE_SERIAL_NO")) != null ? device.getSerialNumber() : null;
        result = super.buildForLaunch(configuration, mode, monitor);
        logger.debug("build ended. project: {}, device serial: {}", (Object)project.getName(), (Object)devSerialNum);
        return result;
    }

    private boolean checkConfigFile(IProject project) throws CoreException {
        return !ProjectUtil.hasError((IResource)project) || LaunchUtil.continueToLaunch((String)org.tizen.web.builder.ide.Messages.DIALOG_TITLE_ERROR_IN_PROJECT, (String)LaunchMessages.DIALOG_QUESTION_CONTINUE_EVEN_IF_IT_HAS_ERROR, (String)LaunchMessages.DIALOG_TOGGLE_ALWAYS_LAUNCH_WITHOUT_ASKING, (String)"prefNoPromptOnBuild");
    }

    private LaunchContext initContext(IProject project, IDevice device, String mode) {
        LaunchContext context = new LaunchContext();
        TizenDeviceInfo devInfo = new TizenDeviceInfo(device);
        TizenWebAppInfo appInfo = new TizenWebAppInfo(project);
        ZimLaunchResource resource = new ZimLaunchResource(devInfo, appInfo, mode);
        context.setValue((Object)"resource", (Object)resource);
        return context;
    }

    protected IProject[] getBuildOrder(ILaunchConfiguration configuration, String mode) throws CoreException {
        IProject[] fOrderedProjects = null;
        IProject currentProject = LaunchUtil.getProject((ILaunchConfiguration)configuration);
        if (currentProject != null) {
            fOrderedProjects = this.computeReferencedBuildOrder(new IProject[]{currentProject.getProject()});
        }
        return fOrderedProjects;
    }
}

