/*
 * Decompiled with CFR 0.152.
 */
package json.model;

import java.util.ArrayList;
import java.util.List;
import json.editors.JsonTextEditor;
import json.model.folding.JsonFoldingPositionsBuilder;
import json.model.jsonnode.JsonNode;
import json.model.jsonnode.JsonNodeBuilder;
import json.model.node.Node;
import json.model.node.NodeBuilder;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.IReconcilingStrategyExtension;
import org.eclipse.swt.widgets.Display;

public class JsonReconcilingStrategy
implements IReconcilingStrategy,
IReconcilingStrategyExtension {
    private JsonTextEditor textEditor;
    private IDocument fDocument;
    List<Node> nodes;
    List<JsonNode> jsonNodes;
    protected final List<Position> fPositions = new ArrayList<Position>();

    public void reconcile(IRegion partition) {
        this.initialReconcile();
    }

    public void reconcile(DirtyRegion dirtyRegion, IRegion subRegion) {
        this.initialReconcile();
    }

    public void setDocument(IDocument document) {
        this.fDocument = document;
    }

    public void initialReconcile() {
        this.parse();
    }

    public void setProgressMonitor(IProgressMonitor monitor) {
    }

    private void parse() {
        this.nodes = new NodeBuilder(this.fDocument).buildNodes();
        this.jsonNodes = new JsonNodeBuilder(this.fDocument, this.nodes).buildJsonNodes();
        this.fPositions.clear();
        this.fPositions.addAll(new JsonFoldingPositionsBuilder(this.jsonNodes).buildFoldingPositions());
        if (this.textEditor != null) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    JsonReconcilingStrategy.this.textEditor.updateFoldingStructure(JsonReconcilingStrategy.this.fPositions);
                    JsonReconcilingStrategy.this.textEditor.updateContentOutlinePage(JsonReconcilingStrategy.this.jsonNodes);
                }
            });
        }
    }

    public JsonTextEditor getTextEditor() {
        return this.textEditor;
    }

    public void setTextEditor(JsonTextEditor textEditor) {
        this.textEditor = textEditor;
    }
}

