/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.zimlaunch.debug.core;

import org.eclipse.core.resources.IProject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.TizenProjectType;
import org.tizen.common.app.EclipseApplication;
import org.tizen.common.gom.launch.GomDebugAttachLaunchData;
import org.tizen.common.gom.launch.GomLaunchData;
import org.tizen.common.gom.smartlaunch.GomSmartLauncher;
import org.tizen.sdblib.SmartDevelopmentBridge;
import org.tizen.sdblib.app.IApplication;
import org.tizen.sdblib.app.IApplicationListener;
import org.tizen.sdblib.app.IApplicationType;
import org.tizen.sdblib.util.ArrayUtil;
import org.tizen.web.common.app.WebApplication;

public class HybridAppDebugListener
implements IApplicationListener {
    Logger logger = LoggerFactory.getLogger(this.getClass());

    public void onDetected(IApplication app) {
        IApplicationType type = app.getType();
        if (type instanceof TizenProjectType) {
            TizenProjectType tizenType = (TizenProjectType)type;
            if (tizenType.isWebProject() && app instanceof WebApplication) {
                this.addReferencedApps((WebApplication)app);
            } else if (tizenType.isNativeServiceApplicationProject()) {
                this.runDebugAttach(app);
            }
        }
    }

    private void addReferencedApps(WebApplication webApp) {
        Object[] referenceApps = webApp.getReferencedApps();
        if (!ArrayUtil.isEmpty((Object[])referenceApps)) {
            Object[] objectArray = referenceApps;
            int n = referenceApps.length;
            int n2 = 0;
            while (n2 < n) {
                Object referenceApp = objectArray[n2];
                this.logger.debug("Add {} appplication.", (Object)referenceApp.getName());
                SmartDevelopmentBridge.addInterestingApplication((IApplication)referenceApp);
                ++n2;
            }
        }
    }

    private void runDebugAttach(final IApplication app) {
        if (!(app instanceof EclipseApplication)) {
            return;
        }
        final IProject project = ((EclipseApplication)app).getProject();
        if (project == null) {
            this.logger.debug("Could not find {} application's project.", (Object)app.getName());
            return;
        }
        this.logger.debug("Debugging {} ...", (Object)project.getName());
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                GomDebugAttachLaunchData debugAttachData = new GomDebugAttachLaunchData(project, String.valueOf(project.getName()) + "-service_attach", null, GomSmartLauncher.MODES.DEBUG.getMode(), GomSmartLauncher.getDebugAttachShortcut((IProject)project), app.getDevice(), app.getPackageId());
                GomSmartLauncher.smartLaunch((GomLaunchData)debugAttachData);
            }
        });
        t.start();
    }

    public void onTerminated(IApplication app) {
        IApplicationType type = app.getType();
        if (type instanceof TizenProjectType) {
            TizenProjectType tizenType = (TizenProjectType)type;
            if (tizenType.isWebProject() && app instanceof WebApplication) {
                this.removeReferencedApps((WebApplication)app);
                this.logger.debug("Remove {} appplication.", (Object)app.getName());
                SmartDevelopmentBridge.removeInterestingApplication((IApplication)app);
            } else {
                tizenType.isNativeServiceApplicationProject();
            }
        }
    }

    private void removeReferencedApps(WebApplication webApp) {
        IApplication[] referenceApps;
        IApplication[] iApplicationArray = referenceApps = webApp.getReferencedApps();
        int n = referenceApps.length;
        int n2 = 0;
        while (n2 < n) {
            IApplication referenceApp = iApplicationArray[n2];
            this.logger.debug("Remove {} appplication.", (Object)referenceApp.getName());
            SmartDevelopmentBridge.removeInterestingApplication((IApplication)referenceApp);
            ++n2;
        }
    }
}

