/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.zimlaunch.step;

import java.io.File;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.osgi.util.NLS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.core.application.ProfileInfo;
import org.tizen.common.core.application.Version;
import org.tizen.common.launch.LaunchMessages;
import org.tizen.common.launch.context.ILaunchContext;
import org.tizen.common.rds.RdsMessages;
import org.tizen.common.ui.view.console.ITizenConsoleManager;
import org.tizen.common.util.log.UserLogger;
import org.tizen.sdblib.IDevice;
import org.tizen.web.common.util.ProjectUtil;
import org.tizen.web.config.schema.model.AppWidget;
import org.tizen.web.editor.configuration.ConfigurationException;
import org.tizen.web.editor.configuration.ConfiguratorFactory;
import org.tizen.web.editor.configuration.IMobileConfigurator;
import org.tizen.web.editor.configuration.ITizenConfigurator;
import org.tizen.web.zimlaunch.command.WebPackageInfoCommand;
import org.tizen.web.zimlaunch.constants.TizenWebLaunchConstants;
import org.tizen.web.zimlaunch.core.CompositeStep;
import org.tizen.web.zimlaunch.core.IStep;
import org.tizen.web.zimlaunch.exception.NoConnectedDeviceException;
import org.tizen.web.zimlaunch.exception.NoProjectException;
import org.tizen.web.zimlaunch.exception.TizenWebIDEException;
import org.tizen.web.zimlaunch.exception.TizenWebIDEExceptionCode;
import org.tizen.web.zimlaunch.notification.TizenWebConsole;
import org.tizen.web.zimlaunch.notification.TizenWebNotifier;
import org.tizen.web.zimlaunch.resource.TizenDeviceInfo;
import org.tizen.web.zimlaunch.resource.TizenWebAppInfo;
import org.tizen.web.zimlaunch.resource.ZimLaunchResource;
import org.tizen.web.zimlaunch.step.Messages;
import org.tizen.web.zimlaunch.util.CommandLauncher;
import org.tizen.web.zimlaunch.util.ExtensionUtil;
import org.tizen.web.zimlaunch.util.LaunchUtil;
import org.tizen.web.zimlaunch.util.TizenWebProjectUtil;

public class InitLaunchStep
extends CompositeStep {
    protected static final Logger logger = LoggerFactory.getLogger(InitLaunchStep.class);
    public static final String name = Messages.STEP_INITIALIZE;
    protected ILaunchConfiguration configuration;
    protected String mode;
    protected ILaunch launch;
    protected TizenWebNotifier notifier;
    protected int percent;

    public InitLaunchStep(ILaunchConfiguration configuration, String mode, ILaunch launch) {
        super(new IStep[0]);
        this.configuration = configuration;
        this.mode = mode;
        this.launch = launch;
        this.work = 100;
        this.rwork = 100;
        this.percent = 10;
    }

    @Override
    public void executeStep(ILaunchContext ctx) throws Exception {
        List appWidgetList;
        UserLogger.start((String)"web.launch", (String)".initialize");
        this.preExecuteStep(ctx);
        String errMsg = "";
        int code = 0;
        logger.debug("Setting the default context...", (Object)this.getWorkCount(10));
        ctx.setValue((Object)"config", (Object)this.configuration);
        ctx.setValue((Object)"mode", (Object)this.mode);
        ctx.setValue((Object)"launch", (Object)this.launch);
        IProject project = null;
        try {
            project = LaunchUtil.getProject((ILaunchConfiguration)this.configuration);
            if (project == null) {
                throw new NoProjectException();
            }
        }
        catch (NoProjectException noProjectException) {
            code = TizenWebIDEExceptionCode.WEB_IDE_STEPCONTEXT_CAN_NOT_FIND_PROJECT.getCode();
            errMsg = NLS.bind((String)Messages.UNEXPECTED_OPERATION, (Object)Messages.STEP_CONTEXT_HANDLE);
            TizenWebIDEException.abort(Messages.getFailMessage((String)Messages.STEP_INITIALIZE), new TizenWebIDEException(errMsg, code), this.notifier);
        }
        boolean rdsMode = LaunchUtil.isRdsMode(project);
        if (rdsMode) {
            this.notifier.notifyContents(LaunchMessages.getStepMessage((String)RdsMessages.RDS_MODE_ENABLED));
        } else {
            this.notifier.notifyContents(LaunchMessages.getStepMessage((String)RdsMessages.RDS_MODE_DISABLED));
        }
        TizenDeviceInfo devInfo = ((ZimLaunchResource)ctx.getValue((Object)"resource")).getDeviceinfo();
        this.notifier.notifyContents(String.format("Target information: %s", devInfo.getDevice().getDeviceName()), this.getWorkCount(30));
        int timeout = this.configuration.getAttribute(TizenWebLaunchConstants.ATTR_TIMEOUT_VALUE, 300);
        devInfo.setTimeout(timeout);
        TizenWebAppInfo appInfo = ((ZimLaunchResource)ctx.getValue((Object)"resource")).getAppinfo();
        ITizenConfigurator configurator = null;
        try {
            configurator = ConfiguratorFactory.unmarshalWidgetConfiguration((IProject)project);
        }
        catch (ConfigurationException configurationException) {
            code = TizenWebIDEExceptionCode.WEB_IDE_STEPCONTEXT_FAIL_WIGET_CONFIGURATOR.getCode();
            errMsg = NLS.bind((String)Messages.UNEXPECTED_OPERATION, (Object)Messages.STEP_CONTEXT_HANDLE);
            TizenWebIDEException.abort(Messages.getFailMessage((String)Messages.STEP_INITIALIZE), new TizenWebIDEException(errMsg, code), this.notifier);
        }
        if (configurator instanceof IMobileConfigurator && (appWidgetList = ((IMobileConfigurator)configurator).getDynamicBoxes()) != null && !appWidgetList.isEmpty()) {
            appInfo.setAppWidgetID(((AppWidget)appWidgetList.get(appWidgetList.size() - 1)).getId());
        }
        String appID = configurator.getApplicationAppID();
        appInfo.setAppID(appID);
        String appPKGName = configurator.getApplicationPackage();
        appInfo.setAppPackageID(appPKGName);
        String appGUID = configurator.getId();
        if (appGUID == null) {
            appGUID = "";
        }
        appInfo.setAppGUID(appGUID);
        this.notifier.notifyContents(String.format("Application information: Id(%s), Package Name(%s), Project Name(%s)", appID, appPKGName, project.getName()), this.getWorkCount(40));
        String path = TizenWebProjectUtil.getLocalWidgetLocation(project);
        File appFile = new File(path);
        appInfo.setAppFile(appFile);
        appInfo.setVersion(configurator.getVersion());
        ProfileInfo info = ProjectUtil.getTizenProjectDescription((IProject)project).getPlatformInfo();
        String profile = info.isProduct() ? info.getParentProfile() : info.getProfile();
        appInfo.setProfile(profile);
        appInfo.setTVExtension(info.isProduct(), info.getParentProfile());
        ZimLaunchResource launchResource = new ZimLaunchResource(devInfo, appInfo, this.mode);
        ctx.setValue((Object)"resource", (Object)launchResource);
        Version version = new Version(ProjectUtil.getTizenProjectDescription((IProject)project).getVersion());
        CommandLauncher launcher = this.createCommandLauncher(devInfo.getDevice(), timeout, profile, version);
        ctx.setValue((Object)"command launcher", (Object)launcher);
        WebPackageInfoCommand command = new WebPackageInfoCommand(launcher.getDevice(), (ITizenConsoleManager)TizenWebConsole.getInstance());
        boolean isInstalled = command.isInstalled(appPKGName, "wgt", launcher, launchResource);
        ctx.setValue((Object)"widget installation", (Object)isInstalled);
        logger.debug(Messages.getSuccessMessage((String)Messages.STEP_INITIALIZE), (Object)this.getWorkCount(20));
        UserLogger.end((String)"web.launch", (String)".initialize");
    }

    private CommandLauncher createCommandLauncher(IDevice device, int timeout, String profile, Version version) throws NoConnectedDeviceException, CoreException {
        CommandLauncher extendedCommandLauncher = ExtensionUtil.getExtendedExecutable(CommandLauncher.class, "commandLauncher", "org.tizen.web.zimlaunch", device, profile, version);
        if (extendedCommandLauncher != null) {
            return extendedCommandLauncher;
        }
        return new CommandLauncher(device, timeout);
    }

    protected void preExecuteStep(ILaunchContext ctx) throws Exception {
        this.notifier = (TizenWebNotifier)ctx.getValue((Object)"notifier");
        this.pwork = this.notifier.getPercentRemainWork(this.percent);
    }

    @Override
    public String getStepName() {
        return name;
    }
}

