/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.editor.configuration.tizen.account.support;

import java.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.tizen.common.util.StringUtil;
import org.tizen.web.config.schema.model.Account;
import org.tizen.web.config.schema.model.Capability;
import org.tizen.web.editor.configuration.ITizenConfigurator;
import org.tizen.web.editor.configuration.Messages;
import org.tizen.web.editor.configuration.tizen.account.support.AddAccountPage;

public class AddAccountWizard
extends Wizard {
    private IProject project;
    private ITizenConfigurator configurator;
    private Account account;
    private AddAccountPage page;

    public AddAccountWizard(ITizenConfigurator configurator) {
        this.configurator = configurator;
        this.project = configurator.getProject();
        this.account = null;
        this.setWindowTitle(Messages.AddAccountWizard_AddTitle);
    }

    public AddAccountWizard(ITizenConfigurator configurator, Account account) {
        this.configurator = configurator;
        this.project = configurator.getProject();
        this.account = account;
        this.setWindowTitle(Messages.AddAccountWizard_EditTitle);
    }

    public void addPages() {
        this.page = this.account == null ? new AddAccountPage(Messages.AddAccountWizard_AddTitle, this.configurator) : new AddAccountPage(Messages.AddAccountWizard_EditTitle, this.configurator, this.account);
        this.page.setTitle(MessageFormat.format(Messages.AddAccountWizard_PageTitle, this.project.getName()));
        this.page.setDescription(Messages.AddAccountWizard_PageDescription);
        this.addPage((IWizardPage)this.page);
    }

    public boolean performFinish() {
        Account account = this.page.getAccount();
        ArrayList contents = new ArrayList(account.getIconOrDisplayNameOrCapability());
        for (Object content : contents) {
            if (!(content instanceof Capability) || !StringUtil.isEmpty((CharSequence)((Capability)content).getContent().trim())) continue;
            account.getIconOrDisplayNameOrCapability().remove(content);
        }
        if (this.account == null) {
            this.configurator.addElement(account);
        } else {
            this.configurator.removeElement(this.account);
            this.configurator.addElement(account);
        }
        return true;
    }
}

