/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.unittest.wizards.provider;

import java.util.ArrayList;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.wst.jsdt.core.IFunction;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MethodTreeViewerContentProvider
implements ITreeContentProvider {
    private static final Logger logger = LoggerFactory.getLogger(ITreeContentProvider.class);

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public Object[] getChildren(Object parentElement) {
        try {
            ArrayList<Object> memberList = new ArrayList<Object>();
            if (parentElement instanceof IJavaScriptUnit) {
                IType[] types;
                IFunction[] funcs;
                IJavaScriptUnit jsUnit = (IJavaScriptUnit)parentElement;
                IFunction[] iFunctionArray = funcs = jsUnit.getFunctions();
                int n = funcs.length;
                int n2 = 0;
                while (n2 < n) {
                    IFunction func = iFunctionArray[n2];
                    memberList.add(func);
                    ++n2;
                }
                IType[] iTypeArray = types = jsUnit.getTypes();
                int n3 = types.length;
                n = 0;
                while (n < n3) {
                    IType type = iTypeArray[n];
                    if (this.hasChildren(type)) {
                        memberList.add(type);
                    }
                    ++n;
                }
                return memberList.toArray();
            }
            if (parentElement instanceof IType) {
                return ((IType)parentElement).getFunctions();
            }
        }
        catch (JavaScriptModelException e) {
            logger.error(e.getMessage());
        }
        return null;
    }

    public Object getParent(Object element) {
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean hasChildren(Object element) {
        try {
            IType[] types;
            if (!(element instanceof IJavaScriptUnit)) {
                if (!(element instanceof IType)) return false;
                if (((IType)element).getFunctions().length <= 0) return false;
                return true;
            }
            IJavaScriptUnit jsUnit = (IJavaScriptUnit)element;
            if (jsUnit.getFunctions().length > 0) {
                return true;
            }
            IType[] iTypeArray = types = jsUnit.getTypes();
            int n = types.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                IType type = iTypeArray[n2];
                if (this.hasChildren(type)) {
                    return true;
                }
                ++n2;
            }
        }
        catch (JavaScriptModelException e) {
            logger.error(e.getMessage());
        }
        return false;
    }
}

