/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.builder.util;

import org.mozilla.javascript.RhinoException;
import org.tizen.web.common.JSONException;
import org.tizen.web.common.JSONObject;
import org.tizen.web.common.JSONTokener;
import ro.isdc.wro.WroRuntimeException;

public class WroExceptionUtil {
    public static int getErrorLine(WroRuntimeException e) {
        if (e.getCause() instanceof RhinoException) {
            RhinoException ex = (RhinoException)e.getCause();
            return ex.lineNumber();
        }
        JSONObject jsonObj = WroExceptionUtil.getJsonInfo(e);
        int line = -1;
        if (jsonObj != null) {
            try {
                line = jsonObj.getInt("line");
                if (line > 0) {
                    return line;
                }
            }
            catch (JSONException jSONException) {}
        }
        String msg = null;
        msg = WroExceptionUtil.getMessage(e);
        if (msg == null) {
            return 0;
        }
        int idxOfLine = msg.lastIndexOf("line");
        if (idxOfLine < 0) {
            return 0;
        }
        int lastIdx = msg.lastIndexOf(":");
        if (msg.startsWith("Error message:")) {
            lastIdx = msg.indexOf(". \n");
        }
        if (lastIdx < 0) {
            return 0;
        }
        msg = msg.substring(idxOfLine, lastIdx).replace("line", "").replace(":", "").trim();
        return Integer.parseInt(msg);
    }

    public static String getErrorMessage(WroRuntimeException e) {
        if (e.getCause() instanceof RhinoException) {
            RhinoException ex = (RhinoException)e.getCause();
            return ex.getLocalizedMessage();
        }
        String unknownMsg = "unknown error";
        String msg = WroExceptionUtil.getMessage(e);
        if (msg == null) {
            return unknownMsg;
        }
        if (msg.startsWith("Error message:")) {
            msg = msg.substring(msg.indexOf(":") + 1, msg.indexOf("at line:")).trim();
        } else {
            int idx = msg.indexOf(":");
            if (idx < 0) {
                return msg;
            }
            msg = msg.substring(idx + 1);
        }
        return msg;
    }

    private static JSONObject getJsonInfo(WroRuntimeException e) {
        String originMsg = e.getMessage();
        if (originMsg == null) {
            return null;
        }
        if (originMsg.startsWith("Could not execute the script because:")) {
            int idx = originMsg.indexOf("{");
            if (idx < 0) {
                return null;
            }
            String json = originMsg.substring(idx);
            if (json == null) {
                return null;
            }
            try {
                return new JSONObject(new JSONTokener(json));
            }
            catch (JSONException jSONException) {
                return null;
            }
        }
        return null;
    }

    private static String getMessage(WroRuntimeException e) {
        JSONObject jsonObj = WroExceptionUtil.getJsonInfo(e);
        try {
            if (jsonObj != null) {
                return jsonObj.getString("message");
            }
        }
        catch (JSONException jSONException) {
            return null;
        }
        return null;
    }

    public static int getErrorColumnNum(WroRuntimeException e) {
        if (e.getCause() instanceof RhinoException) {
            RhinoException ex = (RhinoException)e.getCause();
            return ex.columnNumber();
        }
        return 0;
    }
}

