/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.localization.support;

import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.widgets.Composite;
import org.tizen.web.localization.LocaleItem;
import org.tizen.web.localization.support.AssociationsTableConnector;

public class AssociationsTableEditingSupport
extends EditingSupport {
    private int fColumnIndex;
    private AssociationsTableConnector fConnector;
    private CellEditor editor;
    private TableViewer fTableViewer;

    public AssociationsTableEditingSupport(ColumnViewer viewer, int columnIndex, AssociationsTableConnector connector) {
        super(viewer);
        this.fTableViewer = (TableViewer)viewer;
        this.fConnector = connector;
        this.fColumnIndex = columnIndex;
        this.editor = columnIndex == 0 ? new TextCellEditor((Composite)this.fTableViewer.getTable()) : new CheckboxCellEditor((Composite)this.fTableViewer.getTable(), 16777256);
        this.editor.getLayoutData().horizontalAlignment = 0x1000000;
    }

    protected boolean canEdit(Object element) {
        this.fConnector.setColumn(this.fColumnIndex);
        this.fConnector.setElement(element);
        return this.fColumnIndex != 0;
    }

    protected CellEditor getCellEditor(Object element) {
        return this.editor;
    }

    protected Object getValue(Object element) {
        if (this.fColumnIndex != 0) {
            boolean result = false;
            Locale locale = (Locale)this.fTableViewer.getTable().getColumn(this.fColumnIndex).getData();
            Map.Entry entry = (Map.Entry)element;
            List selectedLocaleItems = (List)entry.getValue();
            for (LocaleItem selectedLocaleItem : selectedLocaleItems) {
                if (selectedLocaleItem.getLocale().equals(locale)) {
                    result = false;
                    break;
                }
                result = true;
            }
            return result;
        }
        return null;
    }

    protected void setValue(Object element, Object value) {
        if (this.fColumnIndex != 0) {
            Locale locale = (Locale)this.fTableViewer.getTable().getColumn(this.fColumnIndex).getData();
            Map.Entry entry = (Map.Entry)element;
            LocaleItem foundLocaleItem = null;
            List selectedLocaleItems = (List)entry.getValue();
            for (LocaleItem selectedLocaleItem : selectedLocaleItems) {
                if (!selectedLocaleItem.getLocale().equals(locale)) continue;
                foundLocaleItem = selectedLocaleItem;
                break;
            }
            if (foundLocaleItem != null) {
                if (!foundLocaleItem.isPreSelected()) {
                    selectedLocaleItems.remove(foundLocaleItem);
                }
            } else {
                selectedLocaleItems.add(new LocaleItem(locale, false));
            }
            this.fTableViewer.refresh();
        }
    }
}

