/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.csslint.engine;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.Map;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextAction;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.Scriptable;
import org.tizen.web.csslint.engine.CssLintBuilder;
import org.tizen.web.csslint.engine.CssLintResult;
import org.tizen.web.csslint.engine.Issue;
import org.tizen.web.csslint.engine.Option;
import org.tizen.web.csslint.engine.OptionParser;
import org.tizen.web.csslint.engine.Util;

public class CssLint {
    private final Map<Option, Object> options = new EnumMap<Option, Object>(Option.class);
    private final ContextFactory contextFactory;
    private final NativeObject lintFunc;
    protected static final CssLint instance = new CssLintBuilder().fromDefault();

    public static CssLint getInstance() {
        return instance;
    }

    CssLint(ContextFactory contextFactory, NativeObject lintFunc) {
        this.contextFactory = contextFactory;
        this.lintFunc = lintFunc;
    }

    public void addOption(Option o) {
        this.options.put(o, Boolean.TRUE);
    }

    public void addOption(Option o, String arg) {
        OptionParser optionParser = new OptionParser();
        this.options.put(o, optionParser.parse(o.getType(), arg));
    }

    private CssLintResult doLint(final String css) {
        return (CssLintResult)this.contextFactory.call(new ContextAction(){

            public CssLintResult run(Context cx) {
                String src = css == null ? "" : css;
                Object[] args = new Object[]{src, CssLint.this.optionsAsCssObject()};
                NativeObject result = (NativeObject)NativeObject.callMethod((Context)cx, (Scriptable)CssLint.this.lintFunc, (String)"verify", (Object[])args);
                NativeArray nativeList = (NativeArray)result.get((Object)"messages");
                ArrayList<Issue> issueList = new ArrayList<Issue>();
                int i = 0;
                while ((long)i < nativeList.getLength()) {
                    Object obj = nativeList.get(i);
                    if (obj instanceof NativeObject) {
                        NativeObject nativeObj = (NativeObject)obj;
                        Object line = nativeObj.get((Object)"line");
                        Object col = nativeObj.get((Object)"col");
                        Object message = nativeObj.get((Object)"message");
                        Object type = nativeObj.get((Object)"type");
                        if (line != null && col != null && message != null) {
                            int row = 0;
                            if (line instanceof Integer) {
                                row = (Integer)line;
                            } else if (line instanceof Double) {
                                row = ((Double)line).intValue();
                            }
                            int column = 0;
                            if (col instanceof Integer) {
                                column = (Integer)col;
                            } else if (col instanceof Double) {
                                column = ((Double)col).intValue();
                            }
                            Issue issue = new Issue(row, column, message.toString(), (String)type);
                            issueList.add(issue);
                        }
                    }
                    ++i;
                }
                return new CssLintResult(issueList);
            }
        });
    }

    public CssLintResult lint(String systemId, Reader reader) throws IOException {
        return this.lint(systemId, Util.readerToString(reader));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CssLintResult lint(String systemId, String css) {
        CssLint cssLint = this;
        synchronized (cssLint) {
            return this.doLint(css);
        }
    }

    private Scriptable optionsAsCssObject() {
        return (Scriptable)this.contextFactory.call(new ContextAction(){

            public Object run(Context cx) {
                Scriptable opts = cx.newObject((Scriptable)CssLint.this.lintFunc);
                for (Map.Entry entry : CssLint.this.options.entrySet()) {
                    String key = ((Option)((Object)entry.getKey())).getLowerName();
                    Object value = Util.javaToJS(entry.getValue(), opts);
                    opts.put(key, opts, value);
                }
                return opts;
            }
        });
    }

    public void resetOptions() {
        this.options.clear();
    }
}

