/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.properties;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.tizen.common.FactoryWithArgument;
import org.tizen.common.file.Filter;
import org.tizen.common.file.SimpleFileFilter;
import org.tizen.common.file.filter.WildCardFilterFactory;
import org.tizen.common.util.FilenameUtil;
import org.tizen.web.common.WebConstant;
import org.tizen.web.common.util.ProjectUtil;

public class WebProjectDefaultFilter
extends ViewerFilter {
    protected SimpleFileFilter filter = new SimpleFileFilter(true);
    protected FactoryWithArgument<Filter, String> filterFactory = new WildCardFilterFactory();

    public WebProjectDefaultFilter() {
        String[] stringArray = WebConstant.DEFAULT_EXCLUDING_RESOURCES;
        int n = WebConstant.DEFAULT_EXCLUDING_RESOURCES.length;
        int n2 = 0;
        while (n2 < n) {
            String exclude = stringArray[n2];
            this.filter.addExcludes(new Filter[]{(Filter)this.filterFactory.create((Object)exclude)});
            ++n2;
        }
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        String relativePath = null;
        String cwd = null;
        if (element instanceof IWorkspaceRoot) {
            return false;
        }
        if (element instanceof IProject) {
            IProject project = (IProject)element;
            return ProjectUtil.isWebProject(project);
        }
        if (element instanceof IResource) {
            IProject project = ((IResource)element).getProject();
            if (project != null) {
                cwd = project.getLocation().toOSString();
                relativePath = FilenameUtil.getRelativePath((String)cwd, (String)((IResource)element).getLocation().toString());
            } else {
                return false;
            }
        }
        if (relativePath != null) {
            return this.filter.accept(cwd, relativePath);
        }
        return true;
    }
}

