/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.unittest.resultview.ui;

import java.util.Arrays;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Composite;
import org.tizen.web.unittest.resultview.model.WUTResult;
import org.tizen.web.unittest.resultview.model.WUTResultFailure;
import org.tizen.web.unittest.resultview.model.WUTResultParent;
import org.tizen.web.unittest.resultview.model.WUTResultTestCase;
import org.tizen.web.unittest.resultview.model.WUTResultTestSuite;
import org.tizen.web.unittest.resultview.provider.WUTResultTreeViewerContentProvider;
import org.tizen.web.unittest.resultview.provider.WUTResultTreeViewerLabelProvider;

public class WUTResultTreeViewer
extends CheckboxTreeViewer {
    private FailedOnlyFilter filter;

    public WUTResultTreeViewer(Composite parent, int style) {
        super(parent, style);
        this.setContentProvider((IContentProvider)new WUTResultTreeViewerContentProvider());
        this.setLabelProvider((IBaseLabelProvider)new WUTResultTreeViewerLabelProvider());
        this.filter = new FailedOnlyFilter();
    }

    public void setInput(WUTResult resultInfo) {
        super.setInput((Object)resultInfo);
        this.expandFailedNode();
    }

    private void expandFailedNode() {
        WUTResult resultInfo = (WUTResult)this.getInput();
        if (resultInfo == null) {
            return;
        }
        for (WUTResultTestSuite testSuite : resultInfo.getTestSuiteList()) {
            if (!testSuite.hasFailure()) continue;
            this.expandToLevel(testSuite, 1);
            for (WUTResultTestCase testCase : testSuite.getTestCaseList()) {
                if (!testCase.hasFailure()) continue;
                this.expandToLevel(testCase, 1);
                for (WUTResultFailure failure : testCase.getFailureInfoList()) {
                    this.setGrayed(failure, true);
                }
            }
        }
    }

    public void addFailedOnlyFilter() {
        this.addFilter(this.filter);
        WUTResult resultInfo = (WUTResult)this.getInput();
        if (resultInfo == null) {
            return;
        }
        for (WUTResultTestSuite testSuite : resultInfo.getTestSuiteList()) {
            if (this.getChecked(testSuite)) continue;
            boolean everyChildrenChecked = true;
            for (WUTResultTestCase testCase : testSuite.getTestCaseList()) {
                if (!this.isFilteredElement(testSuite, testCase) || this.getChecked(testCase)) continue;
                everyChildrenChecked = false;
                break;
            }
            this.setChecked(testSuite, everyChildrenChecked);
        }
    }

    public void removeFailedOnlyFilter() {
        this.removeFilter(this.filter);
        WUTResult resultInfo = (WUTResult)this.getInput();
        if (resultInfo == null) {
            return;
        }
        for (WUTResultTestSuite testSuite : resultInfo.getTestSuiteList()) {
            if (this.getChecked(testSuite) && testSuite.getTotalAssertionCount() != testSuite.getFailedAssertionCount()) {
                this.setChecked(testSuite, false);
            }
            for (WUTResultTestCase testCase : testSuite.getTestCaseList()) {
                if (!this.getChecked(testCase)) continue;
                this.setSubtreeChecked(testCase, true);
            }
        }
    }

    public boolean isFilteredElement(Object parent, Object element) {
        return Arrays.asList(this.getFilteredChildren(parent)).contains(element);
    }

    private static class FailedOnlyFilter
    extends ViewerFilter {
        private FailedOnlyFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            return !(element instanceof WUTResultParent) || ((WUTResultParent)element).hasFailure();
        }
    }
}

