/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.livereload.daemon;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Observer;
import java.util.Set;
import java.util.TreeSet;
import org.tizen.common.daemon.AbstractServer;
import org.tizen.common.daemon.ServerException;
import org.tizen.common.util.FilenameUtil;
import org.tizen.common.util.ThreadUtil;
import org.tizen.web.livereload.IResourceProvider;

public class DirectoryObserver
extends AbstractServer
implements IResourceProvider {
    protected static final long INTERVAL = 500L;
    protected static final long TIMEOUT = 1000L;
    protected IResourceProvider parent;
    protected final File root;
    protected HashMap<File, FileInfo> file2contents = new HashMap();
    protected Set<Observer> observers = new HashSet<Observer>();

    public DirectoryObserver(File root) {
        super("Direcotry Monitor");
        this.root = root;
    }

    @Override
    public void setParent(IResourceProvider parent) {
        this.parent = parent;
    }

    protected void initialize() throws ServerException {
        this.logger.info("File monitoring start");
    }

    protected void check(File file, Set<File> checked, Set<File> modified) {
        checked.add(file);
        if (file.isDirectory()) {
            long fileModifiedTime = file.lastModified();
            FileInfo info = this.file2contents.get(file);
            if (!file.equals(this.root)) {
                if (info == null) {
                    info = new FileInfo();
                    info.loadedTime = fileModifiedTime;
                    this.file2contents.put(file, info);
                    modified.add(file);
                } else if (info.loadedTime < fileModifiedTime) {
                    info.loadedTime = fileModifiedTime;
                    modified.add(file);
                }
            }
            File[] fileArray = file.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File child = fileArray[n2];
                this.check(child, checked, modified);
                ++n2;
            }
        } else {
            long fileModifiedTime = file.lastModified();
            FileInfo info = this.file2contents.get(file);
            if (info == null) {
                info = new FileInfo();
                info.loadedTime = fileModifiedTime;
                this.file2contents.put(file, info);
                modified.add(file);
            } else if (info.loadedTime < fileModifiedTime) {
                info.loadedTime = fileModifiedTime;
                modified.add(file);
            }
        }
    }

    protected void process() throws Exception {
        this.logger.trace("File monitoring start");
        HashSet<File> checked = new HashSet<File>();
        HashSet<File> modified = new HashSet<File>();
        this.check(this.root, checked, modified);
        HashSet<File> deleted = new HashSet<File>(this.file2contents.keySet());
        deleted.removeAll(checked);
        for (File f : deleted) {
            this.file2contents.remove(f);
        }
        modified.addAll(deleted);
        if (modified.isEmpty()) {
            return;
        }
        TreeSet<String> changed = new TreeSet<String>();
        String rootPath = this.root.getCanonicalPath();
        for (File f : modified) {
            String path = f.getCanonicalPath();
            if (rootPath == null && path == null || rootPath != null && rootPath.equalsIgnoreCase(path) || rootPath == null) continue;
            changed.add(FilenameUtil.getRelativePath((String)rootPath, (String)path));
        }
        this.logger.debug("Change :\n{}", changed);
        this.notifyChanged(changed);
        ThreadUtil.trySleep((long)500L);
    }

    @Override
    public long getSize(String path) throws IOException {
        this.logger.trace("Path :{}", (Object)path);
        File file = new File(this.root, path);
        FileInfo info = this.file2contents.get(file);
        this.logger.debug("File info :{}", (Object)info);
        if (info != null) {
            return info.size;
        }
        this.logger.debug("File {} - exist :{}, readability :{}, file :{}", new Object[]{file, file.exists(), file.canRead(), file.isFile()});
        long end = System.currentTimeMillis() + 1000L;
        while (!file.exists() || !file.canRead()) {
            if (System.currentTimeMillis() < end) {
                return -1L;
            }
            ThreadUtil.trySleep((long)100L);
        }
        if (!(!file.isDirectory() || (file = new File(file, "index.html")).exists() && file.isFile())) {
            return file.length();
        }
        info = new FileInfo();
        info.loadedTime = file.lastModified();
        info.size = file.length();
        this.file2contents.put(file, info);
        return info.size;
    }

    @Override
    public synchronized InputStream getContents(String path) throws IOException {
        this.logger.trace("Path :{}", (Object)path);
        File file = new File(this.root, path);
        FileInfo info = this.file2contents.get(file);
        this.logger.debug("File info :{}", (Object)info);
        this.logger.debug("File {} - exist :{}, readability :{}, file :{}", new Object[]{file, file.exists(), file.canRead(), file.isFile()});
        long end = System.currentTimeMillis() + 1000L;
        while (!file.exists() || !file.canRead()) {
            if (System.currentTimeMillis() < end) {
                return null;
            }
            ThreadUtil.trySleep((long)100L);
        }
        if (!(!file.isDirectory() || (file = new File(file, "index.html")).exists() && file.isFile())) {
            return null;
        }
        info = new FileInfo();
        info.loadedTime = file.lastModified();
        info.size = file.length();
        this.file2contents.put(file, info);
        return new FileInputStream(file);
    }

    protected void terminate() {
    }

    @Override
    public void addObserver(Observer observer) {
        this.observers.add(observer);
    }

    protected void notifyChanged(Collection<String> modified) {
        for (Observer observer : this.observers) {
            observer.update(null, modified);
        }
        this.logger.info("Changed notified to {} observers", (Object)this.observers.size());
    }

    static class FileInfo {
        long loadedTime;
        long size;

        FileInfo() {
        }
    }
}

