/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.zimlaunch.util.jsconsole;

import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.sdblib.IDevice;
import org.tizen.sdblib.IShellOutputReceiver;
import org.tizen.web.zimlaunch.constants.TizenWebLaunchConstants;
import org.tizen.web.zimlaunch.util.jsconsole.JsLogReceiver;

public class JSLogThread
extends Thread {
    private static Logger logger = LoggerFactory.getLogger(JSLogThread.class);
    private IDevice device;
    private JsLogReceiver receiver;

    public JSLogThread(IDevice device, JsLogReceiver receiver) {
        super("JSLogThread");
        this.device = device;
        this.receiver = receiver;
    }

    public void close() throws IOException {
        this.receiver.close();
    }

    public void setPackageID(String packageID) {
        this.receiver.setPackageID(packageID);
    }

    @Override
    public void run() {
        try {
            this.receiver.init();
            this.receiver.setDlogFormat(TizenWebLaunchConstants.DLOGUTIL_V_OPTION);
            this.device.executeShellCommand(TizenWebLaunchConstants.JS_CONSOLE_LOG_COMMAND, (IShellOutputReceiver)this.receiver, 0);
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }
}

