/*
 * Decompiled with CFR 0.152.
 */
package org.eclipselabs.jsdt.jquery.api;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipselabs.jsdt.jquery.api.SimpleVersion;
import org.eclipselabs.jsdt.jquery.api.Version;

public final class JQueryContainer {
    private static final char SEPARATOR = '_';
    private static final String NO_CONFLICT_CONTAINER_PREFIX = "org.eclipselabs.jsdt.jquery.core.NoCoflictLibrary";
    private static final String CONFLICT_CONTAINER_PREFIX = "org.eclipselabs.jsdt.jquery.core.CoflictLibrary";

    public static boolean isQueryContainer(String containerId) {
        return JQueryContainer.isContainer(containerId, CONFLICT_CONTAINER_PREFIX) || JQueryContainer.isContainer(containerId, NO_CONFLICT_CONTAINER_PREFIX);
    }

    private static boolean isContainer(String containerId, String expectedContainerId) {
        return containerId.startsWith(expectedContainerId) && containerId.length() > expectedContainerId.length() && containerId.charAt(expectedContainerId.length()) == '_';
    }

    public static Version extractVersion(IPath path) {
        String container = path.segment(0);
        int separatorIndex = container.indexOf(95);
        String versionString = container.substring(separatorIndex + 1);
        return SimpleVersion.fromString(versionString);
    }

    public static boolean isQueryConflict(IPath path) {
        return JQueryContainer.isContainer(path, CONFLICT_CONTAINER_PREFIX);
    }

    public static boolean isQueryNoConflict(IPath path) {
        return JQueryContainer.isContainer(path, NO_CONFLICT_CONTAINER_PREFIX);
    }

    private static boolean isContainer(IPath path, String containerId) {
        if (path == null) {
            return false;
        }
        if (path.segmentCount() != 1) {
            return false;
        }
        String segment = path.segment(0);
        return segment.startsWith(containerId);
    }

    public static boolean extractNoConflict(IPath path) {
        String container = path.segment(0);
        int separatorIndex = container.indexOf(95);
        return NO_CONFLICT_CONTAINER_PREFIX.equals(container.substring(0, separatorIndex));
    }

    public static IPath createIncludePath(Version version, boolean noConflict) {
        return new Path(JQueryContainer.createContainerId(version, noConflict));
    }

    private static String createContainerId(Version version, boolean noConflict) {
        if (noConflict) {
            return "org.eclipselabs.jsdt.jquery.core.NoCoflictLibrary_" + version.toString();
        }
        return "org.eclipselabs.jsdt.jquery.core.CoflictLibrary_" + version.toString();
    }
}

