/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.packager.ui.properties.multi;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.tizen.common.TizenProjectType;
import org.tizen.common.core.application.TizenProjectDescription;
import org.tizen.common.ui.properties.AbstractMultiPropertyPage;
import org.tizen.common.util.ProjectUtil;
import org.tizen.web.packager.ui.properties.multi.control.ReferenceController;
import org.tizen.web.packager.ui.properties.multi.model.ReferenceModel;
import org.tizen.web.packager.ui.properties.multi.view.IMultiPropertyTableColumn;
import org.tizen.web.packager.ui.properties.multi.view.NativeMultiReferenceTableColumn;
import org.tizen.web.packager.ui.properties.multi.view.NativeSingleReferenceTableColumn;
import org.tizen.web.packager.ui.properties.multi.view.WebReferenceTableColumn;
import org.tizen.web.packager.ui.properties.multi.view.provider.MultiContentProvider;
import org.tizen.web.packager.ui.util.PackageUtil;

public class MultiPropertyPage
extends AbstractMultiPropertyPage {
    public static final String PROPERTY_PAGE_ID = "org.tizen.web.packager.ui.properties.multi.MultiPropertyPage";
    ReferenceModel rm = null;
    ReferenceController rc = null;
    private TizenProjectType selectedTizenProjectType;

    protected Control createConfigurationContents(Composite parent) {
        this.selectedTizenProjectType = ProjectUtil.getTizenProjectType((IProject)this.getProject());
        this.rc = new ReferenceController(this.getProject());
        return this.createReferenceGroups(parent, this.rc);
    }

    protected List<TizenProjectDescription.RefTizenProject> getMigratingReferencedProjects(IProject project) {
        return PackageUtil.getMigratingReferencedProjectsForWeb(project);
    }

    private Control createReferenceGroups(Composite parent, ReferenceController rc) {
        ArrayList<TizenProjectType> tpts = this.getTizenProjectTypes(rc.getReferenceModels());
        for (TizenProjectType tpt : tpts) {
            Composite group = this.createReferenceGroup(parent, tpt);
            this.createReferenceTableViewer(group, tpt, rc);
        }
        return parent;
    }

    public ArrayList<TizenProjectType> getTizenProjectTypes(Collection<ReferenceModel> rms) {
        ArrayList<TizenProjectType> tpts = new ArrayList<TizenProjectType>();
        for (ReferenceModel rm : rms) {
            TizenProjectType tpt = rm.getTizenProjectType();
            if (tpts.contains(tpt)) continue;
            tpts.add(rm.getTizenProjectType());
        }
        Collections.sort(tpts, new Comparator<TizenProjectType>(){

            @Override
            public int compare(TizenProjectType type1, TizenProjectType type2) {
                int compare = type1.getProjectType().compareTo(type2.getProjectType());
                if (compare == 0) {
                    return type1.getAppType().compareTo(type2.getAppType());
                }
                return compare;
            }
        });
        return tpts;
    }

    private Control createReferenceTableViewer(Composite parent, TizenProjectType tpt, ReferenceController rc) {
        TableViewer viewer = this.createReferenceTableViewer(parent);
        IMultiPropertyTableColumn[] mptcs = null;
        if (tpt.isWebProject() && this.selectedTizenProjectType.getSelectableReferenceNum(tpt).equals((Object)TizenProjectType.SelectableReferenceNum.ONE)) {
            mptcs = new IMultiPropertyTableColumn[]{WebReferenceTableColumn.ReferenceProject};
        } else if (tpt.isWebProject() && this.selectedTizenProjectType.getSelectableReferenceNum(tpt).equals((Object)TizenProjectType.SelectableReferenceNum.NATURAL)) {
            mptcs = new IMultiPropertyTableColumn[]{WebReferenceTableColumn.MultiSelectableProject};
        } else if (tpt.isNativeProject() && this.selectedTizenProjectType.getSelectableReferenceNum(tpt).equals((Object)TizenProjectType.SelectableReferenceNum.NATURAL)) {
            mptcs = NativeMultiReferenceTableColumn.values();
        } else if (tpt.isNativeProject() && this.selectedTizenProjectType.getSelectableReferenceNum(tpt).equals((Object)TizenProjectType.SelectableReferenceNum.ONE)) {
            mptcs = NativeSingleReferenceTableColumn.values();
        }
        IMultiPropertyTableColumn[] iMultiPropertyTableColumnArray = mptcs;
        int n = mptcs.length;
        int n2 = 0;
        while (n2 < n) {
            IMultiPropertyTableColumn mptc = iMultiPropertyTableColumnArray[n2];
            this.createTableColumn(viewer, rc, mptc);
            ++n2;
        }
        viewer.setContentProvider((IContentProvider)new MultiContentProvider(rc));
        viewer.setInput((Object)tpt);
        return viewer.getTable();
    }

    private TableViewerColumn createTableColumn(TableViewer tableViewer, ReferenceController rc, IMultiPropertyTableColumn mptc) {
        TableViewerColumn column = this.createTableColumn(tableViewer, mptc.getName(), mptc.getStyle(), mptc.isResizable(), mptc.getToolTip(), mptc.getEditingSupport(tableViewer, rc), mptc.getWeight());
        CellLabelProvider labelProvider = mptc.getLabelProvider();
        if (labelProvider != null) {
            column.setLabelProvider(labelProvider);
        }
        return column;
    }

    protected List<TizenProjectDescription.RefTizenProject> getSelectedProjects() {
        ArrayList<TizenProjectDescription.RefTizenProject> selectedProjects = new ArrayList<TizenProjectDescription.RefTizenProject>();
        for (ReferenceModel rm : this.rc.getReferenceModels()) {
            if (!rm.isReferenced()) continue;
            String projectName = rm.getProjectName();
            String style = "";
            if (rm.isNativeRoot()) {
                style = "native main";
            } else if (rm.getTizenProjectType().isWebProject()) {
                style = "companion";
            }
            selectedProjects.add(new TizenProjectDescription.RefTizenProject(projectName, style));
        }
        return selectedProjects;
    }
}

