/*
 * Decompiled with CFR 0.152.
 */
package org.eclipselabs.jsdt.jquery.api.infer;

import java.util.Set;
import org.eclipse.wst.jsdt.core.ast.ASTVisitor;
import org.eclipse.wst.jsdt.core.ast.IArgument;
import org.eclipse.wst.jsdt.core.ast.IExpression;
import org.eclipse.wst.jsdt.core.ast.IFunctionCall;
import org.eclipse.wst.jsdt.core.ast.IFunctionExpression;
import org.eclipse.wst.jsdt.core.infer.InferredType;
import org.eclipselabs.jsdt.jquery.api.infer.JQueryCallbackMethods;

public class JQueryEventInferer
extends ASTVisitor {
    private static final InferredType jQueryEvent;
    private final JQueryCallbackMethods callbackMethods;
    private final boolean noConflict;

    static {
        char[] selector = "jQueryEvent".toCharArray();
        jQueryEvent = new InferredType(selector);
    }

    public JQueryEventInferer(JQueryCallbackMethods callbackMethods, boolean noConflict) {
        this.callbackMethods = callbackMethods;
        this.noConflict = noConflict;
    }

    public boolean visit(IFunctionCall functionCall) {
        String selector;
        IExpression receiver = functionCall.getReceiver();
        if (this.isJQueryObject(receiver) && this.isJQueryEventSelector(selector = new String(functionCall.getSelector()))) {
            this.inferJQueryFunctionCall(functionCall, selector);
        }
        return super.visit(functionCall);
    }

    private void inferJQueryFunctionCall(IFunctionCall functionCall, String selector) {
        IExpression[] functionCallArguments = functionCall.getArguments();
        if (functionCallArguments != null) {
            int argumentCount = functionCallArguments.length;
            Set<Integer> callbackIndices = this.getCallbackIndices(selector, argumentCount);
            int i = 0;
            while (i < argumentCount) {
                IExpression expression = functionCallArguments[i];
                if (expression.getASTType() == 44 && callbackIndices.contains(i)) {
                    this.setInferredTypeEvent(expression);
                }
                ++i;
            }
        }
    }

    private void setInferredTypeEvent(IExpression expression) {
        IFunctionExpression functionExpression = (IFunctionExpression)expression;
        IArgument[] functionExpressionArguments = functionExpression.getMethodDeclaration().getArguments();
        if (functionExpressionArguments != null && functionExpressionArguments.length == 1) {
            IArgument argument = functionExpressionArguments[0];
            argument.setInferredType(jQueryEvent);
        }
    }

    private Set<Integer> getCallbackIndices(String selector, int argumentCount) {
        return this.callbackMethods.getCallbackIndices(selector, argumentCount);
    }

    private boolean isJQueryObject(IExpression expression) {
        IExpression current = expression;
        while (current != null && current.getASTType() == 42) {
            IFunctionCall call = (IFunctionCall)current;
            if (this.isJQuery(call.getSelector())) {
                return true;
            }
            current = call.getReceiver();
        }
        return false;
    }

    private boolean isJQueryEventSelector(String selector) {
        return this.callbackMethods.isEventSelector(selector);
    }

    private boolean isJQuery(char[] token) {
        if (token == null) {
            return false;
        }
        if (!this.noConflict && token.length == 1) {
            return token[0] == '$';
        }
        if (token.length == 6) {
            return token[0] == 'j' && token[1] == 'Q' && token[2] == 'u' && token[3] == 'e' && token[4] == 'r' && token[5] == 'y';
        }
        return false;
    }
}

