/*
 * Decompiled with CFR 0.152.
 */
package org.eclipselabs.jsdt.jquery.api.infer;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.jsdt.core.IIncludePathEntry;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.core.infer.IInferEngine;
import org.eclipse.wst.jsdt.core.infer.IInferenceFile;
import org.eclipse.wst.jsdt.core.infer.InferrenceProvider;
import org.eclipse.wst.jsdt.core.infer.RefactoringSupport;
import org.eclipse.wst.jsdt.core.infer.ResolutionConfiguration;
import org.eclipselabs.jsdt.jquery.api.JQueryApiPlugin;
import org.eclipselabs.jsdt.jquery.api.JQueryContainer;
import org.eclipselabs.jsdt.jquery.api.infer.JQueryCallbackMethods;
import org.eclipselabs.jsdt.jquery.api.infer.JQueryCallbackMethodsGenerator;
import org.eclipselabs.jsdt.jquery.api.infer.JQueryEventInferEngine;

public abstract class JQueryEventInferenceProvider
implements InferrenceProvider {
    private static final String ID = JQueryEventInferenceProvider.class.getName();
    private final JQueryCallbackMethods callbackMethods = new JQueryCallbackMethodsGenerator().createCallbackMethods();

    public IInferEngine getInferEngine() {
        return new JQueryEventInferEngine(this.callbackMethods, this.getNoConflict());
    }

    abstract boolean getNoConflict();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int applysTo(IInferenceFile scriptFile) {
        char[] fileName = scriptFile.getFileName();
        if (fileName == null) {
            return 2;
        }
        Path path = new Path(new String(fileName));
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IResource member = workspaceRoot.findMember((IPath)path);
        if (member == null) {
            return 2;
        }
        IProject project = member.getProject();
        if (project == null) {
            return 2;
        }
        try {
            if (!project.hasNature("org.eclipse.wst.jsdt.core.jsNature")) {
                return 2;
            }
            IJavaScriptProject javaScriptProject = JavaScriptCore.create((IProject)project);
            if (!javaScriptProject.exists()) {
                return 2;
            }
            IIncludePathEntry[] rawIncludepath = javaScriptProject.getRawIncludepath();
            if (rawIncludepath == null) {
                return 2;
            }
            IIncludePathEntry[] iIncludePathEntryArray = rawIncludepath;
            int n = rawIncludepath.length;
            int n2 = 0;
            while (true) {
                IPath includePath;
                if (n2 >= n) {
                    return 2;
                }
                IIncludePathEntry includePathEntry = iIncludePathEntryArray[n2];
                if (includePathEntry.getEntryKind() == 5 && includePathEntry.getContentKind() == 1 && this.isHit(includePath = includePathEntry.getPath())) {
                    return 3;
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            this.logException("failed to determine whether project uses jQuery", (Exception)((Object)e));
            return 2;
        }
    }

    boolean isHit(IPath includePath) {
        return JQueryContainer.isQueryNoConflict(includePath) || !this.getNoConflict() && JQueryContainer.isQueryConflict(includePath);
    }

    private void logException(String message, Exception cause) {
        JQueryApiPlugin plugin = JQueryApiPlugin.getDefault();
        String pluginId = plugin.getBundle().getSymbolicName();
        Status status = new Status(4, pluginId, message, (Throwable)cause);
        ILog log = plugin.getLog();
        log.log((IStatus)status);
    }

    public String getID() {
        return ID;
    }

    public ResolutionConfiguration getResolutionConfiguration() {
        return new ResolutionConfiguration();
    }

    public RefactoringSupport getRefactoringSupport() {
        return null;
    }
}

