/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.unittest.resultview.parser;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jetty.xml.XmlParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.web.unittest.nls.NLSString;
import org.tizen.web.unittest.resultview.model.WUTGlobalFailure;
import org.tizen.web.unittest.resultview.model.WUTResult;
import org.tizen.web.unittest.resultview.model.WUTResultFailure;
import org.tizen.web.unittest.resultview.model.WUTResultTestCase;
import org.tizen.web.unittest.resultview.model.WUTResultTestSuite;
import org.xml.sax.SAXException;

public class WUTXmlParser {
    private static final Logger logger = LoggerFactory.getLogger(WUTXmlParser.class);
    private static final String ATTR_TESTS = "tests";
    private static final String ATTR_FAILURES = "failures";
    private static final String ATTR_FAILURE = "failure";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_TIME = "time";
    private static final String ATTR_VALUE = "value";
    private static final String ATTR_MESSAGE = "message";
    private static final String ATTR_SOURCE = "source";
    private static final Pattern FAILURE_SRC_PATTERN = Pattern.compile("file:\\S*wgt(\\S*?):(\\d*).*(\\[native code\\])*$");

    public static WUTResult parseResult(IProject project, String xml) {
        WUTResult testResult = null;
        XmlParser parser = new XmlParser();
        InputStream is = IOUtils.toInputStream((String)xml);
        try {
            XmlParser.Node testSuitesNode = parser.parse(is);
            if (testSuitesNode != null) {
                int totalAssertionCount = Integer.parseInt(testSuitesNode.getAttribute(ATTR_TESTS));
                int failedAssertionCount = Integer.parseInt(testSuitesNode.getAttribute(ATTR_FAILURES));
                long elapsedTime = (long)(Double.parseDouble(testSuitesNode.getAttribute(ATTR_TIME)) * 1000.0);
                testResult = new WUTResult(totalAssertionCount, failedAssertionCount, elapsedTime);
                WUTXmlParser.parseTS(project, testResult, testSuitesNode);
            }
        }
        catch (IOException e) {
            logger.error(NLSString.MSG_FAIL_TO_PARSE_RESULT_XML, (Throwable)e);
            testResult = null;
        }
        catch (SAXException e) {
            logger.error(NLSString.MSG_FAIL_TO_PARSE_RESULT_XML, (Throwable)e);
            testResult = null;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            testResult = null;
        }
        return testResult;
    }

    private static void parseTS(IProject project, WUTResult testResult, XmlParser.Node testSuitesNode) {
        Iterator testSuiteIterator = testSuitesNode.iterator("testsuite");
        while (testSuiteIterator.hasNext()) {
            XmlParser.Node testSuiteNode = (XmlParser.Node)testSuiteIterator.next();
            String name = testSuiteNode.getAttribute(ATTR_NAME);
            int totalAssertionCount = Integer.parseInt(testSuiteNode.getAttribute(ATTR_TESTS));
            int failedAssertionCount = Integer.parseInt(testSuiteNode.getAttribute(ATTR_FAILURES));
            long elapsedTime = (long)(Double.parseDouble(testSuiteNode.getAttribute(ATTR_TIME)) * 1000.0);
            WUTResultTestSuite testSuite = new WUTResultTestSuite(name, totalAssertionCount, failedAssertionCount, elapsedTime);
            boolean isUndefined = name.equals("undefined") && totalAssertionCount == 0;
            WUTXmlParser.parseTC(project, testResult, testSuite, testSuiteNode, isUndefined);
        }
    }

    private static void parseTC(IProject project, WUTResult testResult, WUTResultTestSuite testSuite, XmlParser.Node testSuiteNode, boolean isUndefined) {
        Iterator testCaseIterator = testSuiteNode.iterator("testcase");
        while (testCaseIterator.hasNext()) {
            XmlParser.Node testCaseNode = (XmlParser.Node)testCaseIterator.next();
            String name = testCaseNode.getAttribute(ATTR_NAME);
            if (name.equals("global failure")) {
                testResult.subtractTotalAssertionCount();
                testResult.subtractFailedAssertionCount();
                testResult.addErrorCount();
                if (!isUndefined) {
                    testSuite.addTotalAssertionCount(-1);
                    testSuite.addFailedAssertionCount(-1);
                }
                XmlParser.Node failureNode = (XmlParser.Node)testCaseNode.iterator(ATTR_FAILURE).next();
                String message = failureNode.getAttribute(ATTR_MESSAGE);
                String source = failureNode.getAttribute(ATTR_SOURCE);
                Matcher m = FAILURE_SRC_PATTERN.matcher(source);
                if (!m.find()) continue;
                IFile file = project.getFile(m.group(1));
                int lineNumber = Integer.parseInt(m.group(2));
                testResult.addGlobalFailure(new WUTGlobalFailure(message, file, lineNumber));
                continue;
            }
            int totalAssertionCount = Integer.parseInt(testCaseNode.getAttribute(ATTR_TESTS));
            int failedAssertionCount = Integer.parseInt(testCaseNode.getAttribute(ATTR_FAILURES));
            long elapsedTime = (long)(Double.parseDouble(testCaseNode.getAttribute(ATTR_TIME)) * 1000.0);
            if (isUndefined) {
                testSuite.addTotalAssertionCount(totalAssertionCount);
                testSuite.addFailedAssertionCount(failedAssertionCount);
                testSuite.addElapsedTime(elapsedTime);
            }
            WUTResultTestCase testCase = new WUTResultTestCase(testSuite, name, totalAssertionCount, failedAssertionCount, elapsedTime);
            testSuite.addTestCase(testCase);
            WUTXmlParser.parseFailure(project, testCaseNode, testCase);
        }
        if (testSuite.getTestCaseList().size() > 0) {
            testResult.addTestSuite(testSuite);
        }
    }

    private static void parseFailure(IProject project, XmlParser.Node testCaseNode, WUTResultTestCase testCase) {
        Iterator failureIterator = testCaseNode.iterator(ATTR_FAILURE);
        while (failureIterator.hasNext()) {
            XmlParser.Node failureNode = (XmlParser.Node)failureIterator.next();
            String message = failureNode.getAttribute(ATTR_MESSAGE);
            IFile file = null;
            int lineNumber = 0;
            String source = failureNode.getAttribute(ATTR_SOURCE);
            Matcher m = FAILURE_SRC_PATTERN.matcher(source);
            if (m.find()) {
                file = project.getFile(m.group(1));
                lineNumber = Integer.parseInt(m.group(2));
            } else {
                logger.error("Not supported source pattern: " + source);
            }
            WUTResultFailure failure = null;
            XmlParser.Node expectedNode = failureNode.get("expected");
            XmlParser.Node actualNode = failureNode.get("actual");
            if (expectedNode != null && actualNode != null) {
                String expected = expectedNode.getAttribute(ATTR_VALUE);
                String actual = actualNode.getAttribute(ATTR_VALUE);
                failure = new WUTResultFailure(message, expected, actual, file, lineNumber);
            } else {
                failure = new WUTResultFailure(message, file, lineNumber);
            }
            testCase.addFailureInfo(failure);
        }
    }
}

