/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.compressor.minifier.core;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.util.IOUtil;
import org.tizen.web.compressor.minifier.core.IMinifier;

public class Minifier {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final Set<IMinifier> minifiers = new HashSet<IMinifier>();

    public boolean canHandle(String name) {
        this.logger.debug("Name: {}, Minifiers: {}", (Object)name, this.minifiers);
        for (IMinifier minifier : this.minifiers) {
            if (!minifier.canHandle(name)) continue;
            return true;
        }
        return false;
    }

    public void addMinifier(IMinifier minifier) {
        this.minifiers.add(minifier);
    }

    public void compress(String name, InputStream in, OutputStream out) throws Exception {
        boolean bProcess = false;
        byte[] bytes = IOUtil.getBytes((InputStream)in, (boolean)true);
        this.logger.debug("Minifiers: {}", this.minifiers);
        for (IMinifier minifier : this.minifiers) {
            this.logger.trace("Minifier: {}", (Object)minifier);
            if (!minifier.canHandle(name)) continue;
            ByteArrayInputStream byteIn = new ByteArrayInputStream(bytes);
            ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
            minifier.compress(byteIn, byteOut);
            bytes = byteOut.toByteArray();
            bProcess = true;
        }
        if (!bProcess) {
            throw new Exception(String.valueOf(name) + " is not supported file.");
        }
        if (out != null) {
            out.write(bytes);
        }
    }
}

