/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.localization.support;

import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.tizen.web.localization.support.PatternConstructor;

public class AvailableFilter
extends ViewerFilter {
    public static final String WILDCARD = "*";
    private Pattern fPattern;
    private final Map<?, ?> selected;
    private final ILabelProvider labelProvider;

    public AvailableFilter(Map<?, ?> selected, ILabelProvider labelProvider) {
        this.setPattern(WILDCARD);
        this.selected = selected;
        this.labelProvider = labelProvider;
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        if (this.selected.containsKey(element)) {
            return false;
        }
        String displayName = this.labelProvider.getText(element);
        return this.matches(element.toString()) || this.matches(displayName);
    }

    private boolean matches(String s) {
        return this.fPattern.matcher(s.toLowerCase()).matches();
    }

    public boolean setPattern(String pattern) {
        String oldPattern;
        String newPattern = pattern.toLowerCase();
        if (!newPattern.endsWith(WILDCARD)) {
            newPattern = String.valueOf(newPattern) + WILDCARD;
        }
        if (!newPattern.startsWith(WILDCARD)) {
            newPattern = WILDCARD + newPattern;
        }
        if (this.fPattern != null && newPattern.equals(oldPattern = this.fPattern.pattern())) {
            return false;
        }
        this.fPattern = PatternConstructor.createPattern(newPattern, true);
        return true;
    }
}

