/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.project.wizard.ui;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.util.SWTUtil;
import org.tizen.web.project.wizard.model.ExtensionTemplateLoader;
import org.tizen.web.project.wizard.model.ProjectTemplate;

public class TizenWebWizardPerspectiveThread {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    public void updatePerspective(final ProjectTemplate template, final IConfigurationElement fConfigElement, IProject project) {
        SWTUtil.asyncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                ExtensionTemplateLoader extensionTemplateLoader = ExtensionTemplateLoader.getInstance();
                String finalPerspective = extensionTemplateLoader.getFinalPerspective(template);
                if (finalPerspective != null) {
                    try {
                        PlatformUI.getWorkbench().showPerspective(finalPerspective, PlatformUI.getWorkbench().getActiveWorkbenchWindow());
                    }
                    catch (WorkbenchException e) {
                        TizenWebWizardPerspectiveThread.this.logger.error("Failed to show perspective", (Throwable)e);
                    }
                } else {
                    BasicNewProjectResourceWizard.updatePerspective((IConfigurationElement)fConfigElement);
                }
            }
        });
    }
}

