/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.localization.ui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.navigator.CommonNavigator;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.progress.WorkbenchJob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.util.ViewUtil;
import org.tizen.web.localization.LocaleItem;
import org.tizen.web.localization.ui.AssociateFilesWithLocaleNamesWizardPage;
import org.tizen.web.localization.ui.FilesListSelectionWizardPage;
import org.tizen.web.localization.ui.LocalesSelectionWizardPage;
import org.tizen.web.localization.ui.Messages;

public class LocalizationWizard
extends Wizard {
    protected final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    List<IFile> fSelectedFiles = new ArrayList<IFile>();
    List<IFile> fLocalizedFiles = new ArrayList<IFile>();
    List<Locale> fSelectedLocales = new ArrayList<Locale>();
    IProject fProject;
    private FilesListSelectionWizardPage filesSelectionPage;
    private LocalesSelectionWizardPage languageSelectionPage;
    private AssociateFilesWithLocaleNamesWizardPage filesAndLocaleNamesAssoctaionPage;

    public LocalizationWizard(IProject project) {
        this.setWindowTitle(Messages.WindowTitle);
        this.fProject = project;
    }

    public IWizardPage getPage(String name) {
        return super.getPage(name);
    }

    public void pageChanged(PageChangedEvent event) {
        Object obj = event.getSelectedPage();
        if (obj instanceof AssociateFilesWithLocaleNamesWizardPage) {
            AssociateFilesWithLocaleNamesWizardPage page = (AssociateFilesWithLocaleNamesWizardPage)((Object)obj);
            page.pageChanged();
        }
    }

    public void addPages() {
        this.filesSelectionPage = new FilesListSelectionWizardPage(Messages.LocalizationWizard_0, this.fProject, this.fSelectedFiles, this.fLocalizedFiles);
        this.languageSelectionPage = new LocalesSelectionWizardPage(Messages.LocalizationWizard_1, this.fProject, this.fSelectedLocales);
        this.filesAndLocaleNamesAssoctaionPage = new AssociateFilesWithLocaleNamesWizardPage(Messages.LocalizationWizard_2, this.fProject, this.fSelectedLocales, this.fSelectedFiles, this.fLocalizedFiles);
        this.addPage((IWizardPage)this.filesSelectionPage);
        this.addPage((IWizardPage)this.languageSelectionPage);
        this.addPage((IWizardPage)this.filesAndLocaleNamesAssoctaionPage);
    }

    public boolean canFinish() {
        return this.getLocalesForInternationalization().size() > 0 && (this.getSelectedFiles().size() > 0 || this.getLocalizedFiles().size() > 0);
    }

    public boolean performFinish() {
        IFolder containerForLocalizedContent = this.getFolder("locales", (IContainer)this.fProject);
        if (containerForLocalizedContent == null) {
            return false;
        }
        this.createLocaleFolders(containerForLocalizedContent);
        try {
            this.fProject.refreshLocal(2, null);
        }
        catch (CoreException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        if (containerForLocalizedContent != null) {
            this.populateLocaleFolders(containerForLocalizedContent);
        }
        new RefreshViewerJob(PlatformUI.getWorkbench().getDisplay(), "refresh viewer").schedule();
        return true;
    }

    private void populateLocaleFolders(IFolder containerForLocalizedContent) {
        HashMap<IFile, List<LocaleItem>> model = this.filesAndLocaleNamesAssoctaionPage.getModel();
        block4: for (Map.Entry<IFile, List<LocaleItem>> entry : model.entrySet()) {
            IFile file = entry.getKey();
            for (LocaleItem localeItem : entry.getValue()) {
                if (localeItem == null) continue block4;
                String localeName = localeItem.getLocale().toString();
                IPath destPath = entry.getKey().getProjectRelativePath();
                destPath = destPath.removeLastSegments(1);
                IFolder localeFolder = containerForLocalizedContent.getFolder(localeName);
                IFolder dstFolder = this.getFolder(destPath.toString(), (IContainer)localeFolder);
                try {
                    this.fProject.refreshLocal(2, null);
                }
                catch (CoreException e) {
                    this.logger.error(e.getMessage(), (Throwable)e);
                }
                if (!file.exists()) continue;
                try {
                    if (dstFolder == null) continue;
                    IPath dstPath = dstFolder.getProjectRelativePath();
                    String fileName = file.getName();
                    if (this.fProject.getLocation().append(dstPath.append(fileName)).toFile().exists()) continue;
                    file.copy(this.fProject.getFullPath().append(dstPath.append(fileName)), 1, null);
                }
                catch (CoreException e) {
                    this.logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    private List<IFolder> createLocaleFolders(IFolder containerForLocalizedContent) {
        ArrayList<IFolder> folders = new ArrayList<IFolder>();
        for (Locale locale : this.languageSelectionPage.getLocalesForInternationalization()) {
            String name = locale.toString();
            IFolder localeFolder = containerForLocalizedContent.getFolder(name = name.replace('_', '-'));
            if (localeFolder.exists()) continue;
            try {
                localeFolder.create(1, true, null);
            }
            catch (CoreException e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
            folders.add(localeFolder);
        }
        return folders;
    }

    private IFolder getFolder(String name, IContainer parent) {
        IFolder folder = null;
        if (parent.getType() == 4) {
            IProject project = (IProject)parent;
            folder = project.getFolder(name);
        } else if (parent.getType() == 2) {
            IFolder parentFolder = (IFolder)parent;
            folder = parentFolder.getFolder(name);
        }
        if (folder != null && !folder.exists()) {
            try {
                folder.create(1, true, null);
            }
            catch (CoreException e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return folder;
    }

    private List<Locale> getLocalesForInternationalization() {
        return this.languageSelectionPage.getLocalesForInternationalization();
    }

    private List<IFile> getLocalizedFiles() {
        return this.filesSelectionPage.getLocalizedFiles();
    }

    private List<IFile> getSelectedFiles() {
        return this.filesSelectionPage.getSelectedFiles();
    }

    private static class RefreshViewerJob
    extends WorkbenchJob {
        public RefreshViewerJob(Display jobDisplay, String name) {
            super(jobDisplay, name);
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            IViewPart viewPart = ViewUtil.getView((String)"org.eclipse.ui.navigator.ProjectExplorer", (boolean)false);
            if (viewPart instanceof CommonNavigator) {
                CommonNavigator commonNavigator = (CommonNavigator)viewPart;
                CommonViewer commonViewer = commonNavigator.getCommonViewer();
                commonViewer.refresh();
            }
            return Status.OK_STATUS;
        }
    }
}

