/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.project.wizard.operation;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.tizen.common.ui.wizards.model.Category;
import org.tizen.common.util.EFSUtil;
import org.tizen.common.util.FileUtil;
import org.tizen.web.apptemplate.model.Options;
import org.tizen.web.apptemplate.model.SupportLibraries;
import org.tizen.web.apptemplate.model.TizenTemplateKindsOfLibraries;
import org.tizen.web.project.wizard.WizardMessages;
import org.tizen.web.project.wizard.model.ProjectTemplate;
import org.tizen.web.project.wizard.model.TizenTemplateLibrariesPool;
import org.tizen.web.project.wizard.model.TizenTemplateLibraryGroup;
import org.tizen.web.project.wizard.operation.AbstractProjectTemplateOperation;

public class LibraryCopyOperation
extends AbstractProjectTemplateOperation {
    private static String JAVASCRIPT_DIRECTORY = "js";
    private static String CSS_DIRECTORY = "css";
    private static String THEME_DIRECTORY = "themes";
    private static String TIZEN_WEB_UI_FW_DIRECTORY = "/tizen-web-ui-fw/latest/";
    public static String INFO_JQUERY_VERSION = "jQueryVersion";
    private int subTicks = 0;
    protected TizenTemplateLibrariesPool pool;
    protected Map<String, String> copiedInformation;

    public LibraryCopyOperation(TizenTemplateLibrariesPool pool) {
        this.pool = pool;
        this.setMainTask(WizardMessages.NewWizardCopyTemplateOperationTask);
        this.copiedInformation = new HashMap<String, String>();
    }

    public Map<String, String> getCopiedInformation() {
        return this.copiedInformation;
    }

    @Override
    public boolean operation(ProjectTemplate template, IProject project, IProgressMonitor monitor) throws CoreException, IOException {
        if (template == null || project == null) {
            this.logger.debug("The template model or project is nothing.");
            return true;
        }
        this.subTicks = 500;
        Options options = template.getTemplateOptions();
        if (options == null) {
            return true;
        }
        SupportLibraries sl = options.getSupportLibraries();
        if (sl == null) {
            return true;
        }
        if (this.pool != null) {
            List<TizenTemplateLibraryGroup> groupList = this.pool.getLibraryGroupWithDepends(sl);
            for (TizenTemplateLibraryGroup group : groupList) {
                if (this.isSampleGroup(template)) {
                    group.setSelectedMinifiedWithDependsUpdate(true);
                }
                if (group.getSelectedElement().getKindsOfLibrary() == TizenTemplateKindsOfLibraries.TIZENWEBUIFW) {
                    this.copyTizenWebUIFWLibrary(group, project, monitor);
                    continue;
                }
                this.copyNormalLibrary(group, project, monitor);
            }
        }
        project.refreshLocal(2, this.createSubMonitor(monitor, this.subTicks));
        return true;
    }

    private void copyTizenWebUIFWLibrary(TizenTemplateLibraryGroup group, IProject project, IProgressMonitor monitor) throws CoreException {
        String libraryPath = group.getSelectedLibraryPath();
        if (libraryPath == null) {
            return;
        }
        File source = new File(libraryPath);
        if (!source.exists()) {
            String errorMsg = "Cannot find template library resource : " + libraryPath;
            throw this.createCoreException(4, errorMsg);
        }
        TizenWebUIFWType type = null;
        String elementKey = group.getSelectedElementKey();
        try {
            type = TizenWebUIFWType.valueOf(elementKey);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
        URI destinationURI = null;
        switch (type) {
            case TizenWebUIFramework_Theme: 
            case TizenWebUIFramework_Theme_Images: {
                String[] themePaths = libraryPath.split("Theme/");
                destinationURI = URI.create(project.getLocationURI() + type.getDestinationPath() + themePaths[1]);
                break;
            }
            default: {
                destinationURI = URI.create(project.getLocationURI() + type.getDestinationPath());
            }
        }
        if (type != TizenWebUIFWType.TizenWebUIFramework_Theme) {
            destinationURI = URI.create(destinationURI + group.getSelectedElementValue());
        }
        if (source.isDirectory()) {
            if (!FileUtil.isExist((String)destinationURI.getPath())) {
                FileUtil.createDirectory((File)new File(destinationURI));
            }
        } else {
            File parentFile = new File(destinationURI).getParentFile();
            if (!FileUtil.isExist((String)parentFile.getPath())) {
                FileUtil.createDirectory((File)parentFile);
            }
        }
        this.copyLibrary(source.toURI(), destinationURI, monitor);
    }

    private void copyNormalLibrary(TizenTemplateLibraryGroup group, IProject project, IProgressMonitor monitor) throws CoreException {
        String libraryPath = group.getSelectedLibraryPath();
        if (libraryPath == null) {
            return;
        }
        File source = new File(libraryPath);
        if (!source.exists() || !source.isDirectory()) {
            String errorMsg = "Cannot find template library resource directory : " + libraryPath;
            throw this.createCoreException(4, errorMsg);
        }
        TizenTemplateKindsOfLibraries kindOfLibrary = group.getSelectedElement().getKindsOfLibrary();
        URI destinationURI = null;
        switch (kindOfLibrary) {
            case JAVASCRIPT: {
                destinationURI = project.getFolder(JAVASCRIPT_DIRECTORY).getLocationURI();
                break;
            }
            case CSS: {
                destinationURI = project.getFolder(CSS_DIRECTORY).getLocationURI();
                break;
            }
            default: {
                destinationURI = project.getLocationURI();
            }
        }
        this.copyLibrary(source.toURI(), destinationURI, monitor);
        if ("jQuery".equals(group.getName())) {
            this.copiedInformation.put(INFO_JQUERY_VERSION, group.getSelectedElement().getVersion());
        }
    }

    private void copyLibrary(URI source, URI destination, IProgressMonitor monitor) throws CoreException {
        EFSUtil.copy((URI)source, (URI)destination, (int)2, (IProgressMonitor)this.createSubMonitor(monitor, this.subTicks));
    }

    private boolean isSampleGroup(ProjectTemplate template) {
        Category entry = template.getParentCategory();
        while (entry != null) {
            if ("Sample".equalsIgnoreCase(entry.getName())) {
                return true;
            }
            entry = entry.getParent();
        }
        return false;
    }

    public static enum TizenWebUIFWType {
        TizenWebUIFramework_JS,
        TizenWebUIFramework_Theme,
        TizenWebUIFramework_Theme_Images,
        TizenWebUIFramework_Common,
        TizenWebUIFramework_JS_jQuery,
        TizenWebUIFramework_JS_libs;


        public String getDestinationPath() {
            String destinationPath = null;
            String base = TIZEN_WEB_UI_FW_DIRECTORY;
            switch (TizenWebUIFWType.valueOf(this.name())) {
                case TizenWebUIFramework_JS: 
                case TizenWebUIFramework_JS_jQuery: 
                case TizenWebUIFramework_JS_libs: {
                    destinationPath = String.valueOf(base) + JAVASCRIPT_DIRECTORY + "/";
                    break;
                }
                case TizenWebUIFramework_Theme: 
                case TizenWebUIFramework_Theme_Images: {
                    destinationPath = String.valueOf(base) + THEME_DIRECTORY + "/";
                    break;
                }
                default: {
                    destinationPath = base;
                }
            }
            return destinationPath;
        }
    }
}

