/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.editor.configuration.tizen.account.support;

import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.widgets.Composite;
import org.tizen.web.config.schema.model.DisplayName;
import org.tizen.web.editor.configuration.support.AbstractChangeListener;

public class DisplayNameEditingSupport
extends EditingSupport {
    private int column;
    private CellEditor editor;
    private AbstractChangeListener listener;
    private static final String EMPTY_STRING = "";

    public DisplayNameEditingSupport(ColumnViewer viewer, int column) {
        super(viewer);
        this.column = column;
        switch (column) {
            case 0: {
                if (!(viewer instanceof TableViewer)) break;
                this.editor = new TextCellEditor((Composite)((TableViewer)viewer).getTable());
                break;
            }
            case 1: {
                if (!(viewer instanceof TableViewer)) break;
                this.editor = new TextCellEditor((Composite)((TableViewer)viewer).getTable());
                break;
            }
        }
    }

    protected CellEditor getCellEditor(Object element) {
        return this.editor;
    }

    protected boolean canEdit(Object element) {
        switch (this.column) {
            case 0: {
                return false;
            }
            case 1: {
                return false;
            }
        }
        return false;
    }

    protected Object getValue(Object element) {
        if (!(element instanceof DisplayName)) {
            return null;
        }
        DisplayName displayName = (DisplayName)element;
        switch (this.column) {
            case 0: {
                String lang = displayName.getLang();
                if (lang != null) {
                    return lang;
                }
                return EMPTY_STRING;
            }
            case 1: {
                String name = displayName.getContent();
                if (name != null) {
                    return name;
                }
                return EMPTY_STRING;
            }
        }
        return null;
    }

    protected void setValue(Object element, Object value) {
        if (!(element instanceof DisplayName)) {
            return;
        }
        DisplayName displayName = (DisplayName)element;
        switch (this.column) {
            case 0: {
                displayName.setLang((String)value);
                break;
            }
            case 1: {
                displayName.setContent((String)value);
                break;
            }
        }
        this.getViewer().update(element, null);
        if (this.getListener() != null) {
            this.getListener().notifyChange();
        }
    }

    public void setListener(AbstractChangeListener listener) {
        this.listener = listener;
    }

    public void unsetListener() {
        this.listener = null;
    }

    public AbstractChangeListener getListener() {
        return this.listener;
    }
}

