/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.builder;

import java.util.Collection;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.tizen.common.builder.BuildResult;
import org.tizen.common.builder.IBuildListener;
import org.tizen.common.builder.exception.BuildException;
import org.tizen.common.file.IResource;
import org.tizen.web.builder.AbstractLintBuilder;
import org.tizen.web.webwidget.validator.HtmlCssValidatorChecker;

public class WebWidgetHtmlCssValidatorBuilder
extends AbstractLintBuilder {
    private IProject project = null;
    IProgressMonitor monitor = null;
    protected HtmlCssValidatorChecker validator = null;
    public static final String HTML = "html";

    public WebWidgetHtmlCssValidatorBuilder(IProject project, IBuildListener buildListener, IProgressMonitor monitor) {
        super(HTML, buildListener);
        this.project = project;
        this.monitor = monitor != null ? monitor : new NullProgressMonitor();
        this.validator = HtmlCssValidatorChecker.getInstance();
    }

    public HtmlCssValidatorChecker getValidator() {
        return this.validator;
    }

    protected BuildResult doBuild(IResource resource) throws BuildException {
        this.logger.debug("WebWidget HTML & CSS ValidatorBuilder: " + resource.getName());
        BuildResult buildResult = new BuildResult(BuildResult.Status.SUCCESS);
        Collection buildErrInfos = this.validator.validate(this.project, resource, this.monitor);
        if (buildErrInfos == null) {
            return buildResult;
        }
        BuildResult.Status status = BuildResult.Status.ERROR;
        if (this.validator.getSeverity() == 1) {
            status = BuildResult.Status.WARNING;
        }
        buildResult.setResult(status);
        buildResult.getBuildErrorInfos().addAll(buildErrInfos);
        return buildResult;
    }
}

