/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.jshint;

import org.tizen.common.file.IResource;
import org.tizen.common.util.StringUtil;
import org.tizen.web.jshint.Activator;
import org.tizen.web.jshint.engine.JsHint;
import org.tizen.web.jshint.engine.Option;

public class JsHintValidatorHelper {
    public static String[] getPredefinedGlobalVariables() {
        String predefinedGlobalVariables = Activator.getJsPreferenceStore().getString("org.tizen.web.jshint.preference.JsValidationPreferencePage.predef");
        return StringUtil.split((String)predefinedGlobalVariables.replaceAll(" ", ""), (String)",");
    }

    public static String[] getExcludeJsResources() {
        String excludeFiles = Activator.getJsPreferenceStore().getString("org.tizen.web.jshint.preference.JsValidationPreferencePage.exclude");
        return StringUtil.split((String)excludeFiles.replaceAll(" ", ""), (String)",");
    }

    public static String[] getExcludeFolders() {
        String excludeFiles = Activator.getJsPreferenceStore().getString("org.tizen.web.jshint.preference.JsValidationPreferencePage.excludeFolder");
        return StringUtil.split((String)excludeFiles.replaceAll(" ", ""), (String)",");
    }

    public static String getErrorLevel() {
        return Activator.getJsPreferenceStore().getString("org.tizen.web.jshint.preference.JsValidationPreferencePage.level");
    }

    public static void setPreferenceOptions(JsHint lint) {
        Option[] optionArray = Option.values();
        int n = optionArray.length;
        int n2 = 0;
        while (n2 < n) {
            int temp;
            Option o = optionArray[n2];
            if (o.getType() == Boolean.class) {
                if (Activator.getJsPreferenceStore().getBoolean(o.getLowerName())) {
                    lint.addOption(o);
                }
            } else if (o.getType() == Integer.class && (temp = Activator.getJsPreferenceStore().getInt(o.getLowerName())) > 0) {
                lint.addOption(o, Integer.toString(temp));
            }
            ++n2;
        }
    }

    public static boolean isExcludeResource(IResource res) {
        String[] excludedRes = JsHintValidatorHelper.getExcludeJsResources();
        int i = 0;
        while (i < excludedRes.length) {
            if (res.getName().indexOf(excludedRes[i].trim()) != -1) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

