/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.editor.javascript;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRewriteTarget;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.IEditorPart;
import org.eclipse.wst.sse.ui.internal.TextDropAction;
import org.tizen.web.editor.javascript.JavaScriptEditor;

public class JavaScriptTextDropAction
extends TextDropAction {
    public boolean run(DropTargetEvent event, IEditorPart targetEditor) {
        if (targetEditor instanceof JavaScriptEditor) {
            JavaScriptEditor editor = (JavaScriptEditor)targetEditor;
            ISourceViewer viewer = editor.getViewer();
            StyledText st = viewer.getTextWidget();
            int start = event.x;
            int end = event.y;
            if (event.detail == 2) {
                int caretOffset = st.getCaretOffset();
                if (start <= caretOffset && caretOffset <= end) {
                    event.detail = 0;
                    return false;
                }
                IRewriteTarget target = (IRewriteTarget)editor.getAdapter(IRewriteTarget.class);
                if (target != null) {
                    target.beginCompoundChange();
                }
            }
            if (!editor.validateEditorInputState()) {
                event.detail = 0;
                return false;
            }
            String text = (String)event.data;
            if (!editor.isBlockSelectionModeEnabled()) {
                Point newSelection = st.getSelection();
                try {
                    int modelOffset = JavaScriptTextDropAction.widgetOffset2ModelOffset(viewer, newSelection.x);
                    viewer.getDocument().replace(modelOffset, 0, text);
                }
                catch (BadLocationException badLocationException) {
                    return false;
                }
                st.setSelectionRange(newSelection.x, text.length());
            }
            return true;
        }
        return false;
    }

    protected static final int widgetOffset2ModelOffset(ISourceViewer viewer, int widgetOffset) {
        if (viewer instanceof ITextViewerExtension5) {
            ITextViewerExtension5 extension = (ITextViewerExtension5)viewer;
            return extension.widgetOffset2ModelOffset(widgetOffset);
        }
        return widgetOffset + viewer.getVisibleRegion().getOffset();
    }
}

