/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.connection;

import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UserInfo;

public class PortForwarder {
    private String userName = null;
    private String password = null;
    private String hostName = null;
    private int sshPort = 0;
    private int portInternal = 0;
    private String hostExternal = null;
    private int portExternal = 0;
    private boolean hasValidCoords = false;
    private String EXCEPTION_NOT_VALID_COORDS = "Coordinates for the tunnel are invalid.";
    private Session session = null;
    private static PortForwarder instance = null;
    private static int minPortVal = 0;
    private static int maxPortVal = 65535;

    private PortForwarder() {
    }

    public void configureHostParameters(String userName, String password, String hostName, int sshPort) {
        this.userName = userName;
        this.password = password;
        this.hostName = hostName;
        this.sshPort = sshPort;
    }

    public static PortForwarder getInstance() {
        if (instance == null) {
            instance = new PortForwarder();
        }
        return instance;
    }

    public void setTunnelCoords(int portInternal, String hostExternal, int portExternal) {
        this.hasValidCoords = false;
        if (hostExternal == null) {
            return;
        }
        if (portInternal == 0 || portExternal == 0 || hostExternal.equals("")) {
            return;
        }
        this.portInternal = portInternal;
        this.hostExternal = hostExternal;
        this.portExternal = portExternal;
        this.hasValidCoords = true;
    }

    private boolean validateTunnelCoords() {
        if (!this.hasValidCoords) {
            return false;
        }
        if (this.hostName == null || this.hostName.equals("")) {
            return false;
        }
        if (this.userName == null || this.userName.equals("")) {
            return false;
        }
        if (this.sshPort < minPortVal && this.sshPort > maxPortVal) {
            return false;
        }
        if (this.password == null) {
            return false;
        }
        if (this.portInternal < minPortVal && this.portInternal > maxPortVal) {
            return false;
        }
        if (this.hostExternal == null || this.hostExternal.equals("")) {
            return false;
        }
        return this.portExternal >= minPortVal || this.portExternal <= maxPortVal;
    }

    public void addTunnel() throws Exception {
        if (!this.validateTunnelCoords()) {
            throw new Exception(this.EXCEPTION_NOT_VALID_COORDS);
        }
        if (this.session != null) {
            this.session.disconnect();
            this.session = null;
        }
        JSch jsch = new JSch();
        this.session = jsch.getSession(this.userName, this.hostName, this.sshPort);
        this.session.setPassword(this.password);
        this.session.setUserInfo((UserInfo)new LocalUserInfo(this.password));
        this.session.connect();
        this.removeTunnel();
        this.session.setPortForwardingL(this.portInternal, this.hostExternal, this.portExternal);
    }

    public void removeTunnel() throws JSchException {
        if (this.session == null) {
            return;
        }
        if (this.isCurrentForwarded(this.session.getPortForwardingL())) {
            this.session.delPortForwardingL(this.portInternal);
        }
    }

    public void removeAllTunnels() throws JSchException {
        if (this.session == null) {
            return;
        }
        String[] establishedTunnels = this.session.getPortForwardingL();
        String localPort = null;
        int i = 0;
        while (i < establishedTunnels.length) {
            localPort = establishedTunnels[i].substring(0, establishedTunnels[i].indexOf(":") - 1);
            this.session.delPortForwardingL(Integer.parseInt(localPort));
            ++i;
        }
    }

    private boolean isCurrentForwarded(String[] establishedTunnels) {
        if (this.session == null) {
            return false;
        }
        int i = 0;
        while (i < establishedTunnels.length) {
            if (establishedTunnels[i].startsWith(Integer.toString(this.portInternal))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    class LocalUserInfo
    implements UserInfo {
        String mPasswd;

        public LocalUserInfo(String passwd) {
            this.mPasswd = passwd;
        }

        public String getPassphrase() {
            return null;
        }

        public String getPassword() {
            return this.mPasswd;
        }

        public boolean promptPassphrase(String message) {
            return true;
        }

        public boolean promptPassword(String message) {
            return true;
        }

        public boolean promptYesNo(String message) {
            return true;
        }

        public void showMessage(String message) {
            System.out.println("JSch message: " + message);
        }
    }
}

