/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.compressor.minifier.core;

import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.util.FileUtil;
import org.tizen.web.compressor.minifier.core.IMinifier;

public abstract class AbstractMinifier
implements IMinifier {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final Set<String> extensions = new HashSet<String>();

    public AbstractMinifier(String[] extensions) {
        String[] stringArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            String ext = stringArray[n2];
            this.extensions.add(ext.toLowerCase());
            ++n2;
        }
    }

    protected Set<String> getExtensions() {
        return this.extensions;
    }

    @Override
    public boolean canHandle(String name) {
        this.logger.trace("Name: {}", (Object)name);
        String fileExt = FileUtil.getFileExtension((String)name);
        this.logger.trace("Extension: {}", (Object)fileExt);
        if (fileExt == null) {
            this.logger.debug("No extension");
            return false;
        }
        fileExt = fileExt.toLowerCase();
        Set<String> exts = this.getExtensions();
        this.logger.debug("Extension candidate: {}", exts);
        return exts.contains(fileExt);
    }
}

