/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.zimlaunch.cli.command;

import java.text.MessageFormat;
import org.tizen.common.TizenPlatformConstants;
import org.tizen.common.core.command.ExecutionContext;
import org.tizen.common.core.command.Executor;
import org.tizen.common.util.StringUtil;
import org.tizen.web.zimlaunch.cli.command.GetIDCommand;
import org.tizen.web.zimlaunch.cli.command.WRTCommand;

public class UninstallCommand
extends WRTCommand {
    protected static final String WRT_UNINSTALL_COMMAND = TizenPlatformConstants.PKG_TOOL_REMOVE_COMMAND;
    protected String widgetID;

    public String getWidgetID() {
        return this.widgetID;
    }

    public UninstallCommand(String widgetID) {
        this.widgetID = widgetID;
    }

    protected String getID(Executor executor, ExecutionContext context) throws Exception {
        GetIDCommand cmd = new GetIDCommand(this.getWidgetID());
        cmd.setDevice(this.getDevice());
        cmd.run(executor, context);
        return cmd.getID();
    }

    protected String createCommand(Executor executor, ExecutionContext context) throws Exception {
        String id = this.getWidgetID();
        String[] idstr = StringUtil.split((String)id, (String)".");
        if (idstr.length > 1) {
            id = idstr[0];
        }
        String cmd = String.format(WRT_UNINSTALL_COMMAND, "wgt", id);
        return cmd;
    }

    @Override
    protected boolean checkCommandReturnCode() {
        return super.checkCommandReturnCode();
    }

    @Override
    public void run(Executor executor, ExecutionContext context) throws Exception {
        this.setCommand(this.createCommand(executor, context));
        super.run(executor, context);
        String msg = this.checkCommandReturnCode() ? MessageFormat.format("''{0}'' uninstall successful.", this.getWidgetID()) : MessageFormat.format("''{0}'' uninstall failed.", this.getWidgetID());
        if (this.isPrintOption()) {
            context.getPrompter().notify(msg);
        }
    }

    @Override
    public void undo(Executor executor, ExecutionContext context) throws Exception {
        super.undo(executor, context);
    }
}

