/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.builder;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.TizenPlatformConstants;
import org.tizen.common.builder.BuildResult;
import org.tizen.common.builder.core.AbstractBuilder;
import org.tizen.common.builder.exception.BuildException;
import org.tizen.common.file.FileHandler;
import org.tizen.common.file.IResource;
import org.tizen.common.util.Assert;
import org.tizen.common.util.FileUtil;
import org.tizen.common.util.FilenameUtil;
import org.tizen.common.util.IOUtil;
import org.tizen.web.builder.ConfigurationParserHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class HybridAppCLIBuilder
extends AbstractBuilder {
    protected final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    public static final String RESOURCE_LAYER_NAME = "Hybrid CLI Resource Layer";
    public static final String RESOURCE_LAYER_REFERENCE_NAME = "Hybrid CLI Referenced Resource Layer";
    public static final String ERROR_PKG_ID_NOT_FOUND = "Couldn't find a package ID in the widget configuration file(config.xml).";
    public static final String ERROR_CONFIG_NOT_FOUND = "Couldn't find the widget configuration file(config.xml) in your project.";
    public static final String ERROR_MANIFEST_NOT_FOUND = "Couldn't find the manifest file(manifest.xml) in the referenced project.";
    public static final String ERROR_BINARY_NOT_FOUND = "Couldn't find the binary file. Please make sure if your referenced native project is built successfully.";
    private static final String NATIVE_FOLDER_MANIFEST = "info";
    private static final String NATIVE_FOLDER_BINARY = "bin";
    private static final String NATIVE_FOLDER_RESOURCE = "res";
    private static final String[] NATIVE_MOVABLE_FOLDER = new String[]{"shared", "setting", "data", "icons", "lib", "llvm", "res"};
    public static final String[] NATIVE_BINARY_FOLDER = new String[]{"bin", "Debug", "Release", "CommandLineBuild"};
    private static final String NATIVE_MANIFEST = TizenPlatformConstants.MANIFEST_XML_FILE_NAME;
    private static final String APPID_ELEMENT_NAME = "Id";
    private static final String APPID_OPEN_ELEMENT = "<Id>";
    private static final String APPID_CLOSE_ELEMENT = "</Id>";
    protected boolean binaryFound = false;
    protected boolean manifestFound = false;
    private String refPath;
    private String webPath;

    public HybridAppCLIBuilder(String output, String webPath, String refPath) {
        super(output);
        Assert.notNull((Object)refPath);
        this.webPath = webPath;
        this.refPath = refPath;
    }

    public HybridAppCLIBuilder(FileHandler fh, String webPath, String refPath) {
        Assert.notNull((Object)refPath);
        this.fileHandler = fh;
        this.webPath = webPath;
        this.refPath = refPath;
    }

    public boolean canBuild(IResource resource) {
        return true;
    }

    protected BuildResult doBuild(IResource resource) throws BuildException {
        BuildResult result = new BuildResult(BuildResult.Status.UNKNOWN);
        String pathStr = FilenameUtil.getCanonicalForm((String)resource.getPath());
        String[] fragments = FilenameUtil.getCanonicalFragments((String)pathStr);
        String segment = fragments[0];
        InputStream contents = null;
        try {
            try {
                contents = resource.getContents();
                String path = FileUtil.appendPath((String)resource.getFileHandler().getCurrentWorkingDirectory(), (String)resource.getPath());
                if (!path.startsWith(this.refPath)) {
                    String newPath = "res/wgt";
                    newPath = FileUtil.appendPath((String)newPath, (String)pathStr);
                    this.addOutputResource(result, resource, newPath, IOUtil.getBytes((InputStream)contents));
                } else if (fragments.length > 1) {
                    String segment2nd = fragments[1];
                    if (this.isMovableFolder(segment)) {
                        this.addOutputResource(result, resource, pathStr, IOUtil.getBytes((InputStream)contents));
                    } else if (this.isBinaryFolder(segment) && this.isBinaryFile(resource.getName())) {
                        String newPath = FileUtil.appendPath((String)NATIVE_FOLDER_BINARY, (String)segment2nd);
                        this.addOutputResource(result, resource, newPath, IOUtil.getBytes((InputStream)contents));
                        this.binaryFound = true;
                    }
                } else if (this.isManifestFile(segment)) {
                    String newPath = FileUtil.appendPath((String)NATIVE_FOLDER_MANIFEST, (String)pathStr);
                    byte[] modifiedBytes = this.synchronizeAppID(contents);
                    this.addOutputResource(result, resource, newPath, modifiedBytes);
                    this.manifestFound = true;
                }
            }
            catch (IOException e) {
                throw new BuildException((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            IOUtil.tryClose((Object[])new Object[]{contents});
            throw throwable;
        }
        IOUtil.tryClose((Object[])new Object[]{contents});
        return result;
    }

    protected boolean isBinaryFolder(String name) {
        String[] stringArray = NATIVE_BINARY_FOLDER;
        int n = NATIVE_BINARY_FOLDER.length;
        int n2 = 0;
        while (n2 < n) {
            String binFolder = stringArray[n2];
            if (binFolder.equals(name)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected boolean isBinaryFile(String name) {
        return FilenameUtil.hasExtension((String)name, (String)"exe");
    }

    protected boolean isMovableFolder(String name) {
        String[] stringArray = NATIVE_MOVABLE_FOLDER;
        int n = NATIVE_MOVABLE_FOLDER.length;
        int n2 = 0;
        while (n2 < n) {
            String folder = stringArray[n2];
            if (folder.equals(name)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected boolean isManifestFile(String name) {
        return NATIVE_MANIFEST.equals(name);
    }

    public String getPackageIDFromConfiguration() throws IOException, ParserConfigurationException, SAXException {
        if (!FileUtil.isExist((String)this.webPath)) {
            throw new IOException(ERROR_CONFIG_NOT_FOUND);
        }
        ConfigurationParserHandler parserHandler = new ConfigurationParserHandler();
        FileInputStream contents = null;
        try {
            File file = new File(FileUtil.appendPath((String)this.webPath, (String)"config.xml"));
            contents = new FileInputStream(file);
            SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
            parser.parse((InputStream)contents, (DefaultHandler)parserHandler);
        }
        catch (Throwable throwable) {
            IOUtil.tryClose((Object[])new Object[]{contents});
            throw throwable;
        }
        IOUtil.tryClose((Object[])new Object[]{contents});
        return parserHandler.getPkgID();
    }

    protected byte[] synchronizeAppID(InputStream inputStream) throws BuildException {
        try {
            String inputString = new String(IOUtil.getBytes((InputStream)inputStream, (boolean)true));
            String applicationPkgID = this.getPackageIDFromConfiguration();
            if (applicationPkgID != null) {
                this.logger.debug("Change the package id : {}", (Object)applicationPkgID);
                String replacedString = inputString.replaceFirst("<Id>.*</Id>", APPID_OPEN_ELEMENT + applicationPkgID + APPID_CLOSE_ELEMENT);
                return replacedString.getBytes();
            }
            throw new IOException(ERROR_PKG_ID_NOT_FOUND);
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e);
        }
        catch (ParserConfigurationException e) {
            throw new BuildException((Throwable)e);
        }
        catch (SAXException e) {
            throw new BuildException((Throwable)e);
        }
    }

    public boolean isBinaryFound() {
        return this.binaryFound;
    }

    public boolean isManifestFound() {
        return this.manifestFound;
    }
}

