/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.localization.support;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.web.localization.support.PatternConstructor;
import org.tizen.web.localization.support.ProjectFileItem;

public class ProjectFilesContentProvider
extends ArrayContentProvider {
    protected final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    public static final String WILDCARD = "*";
    public static final String DELIMITER = ":";

    public Object[] getElements(Object inputElement) {
        IProject project = (IProject)inputElement;
        List<IFile> projectFiles = this.getProjectFileList(project);
        if (projectFiles == null) {
            return null;
        }
        String patterns = "*.css:*.html:*.js:*.png";
        String ignoreFilter = ".*:locales/*";
        List<IFile> filteredFiles = this.findFilesMatchingPattern(projectFiles, patterns, ignoreFilter);
        List<IFile> localizedFiles = null;
        localizedFiles = this.findFilesMatchingPattern(projectFiles, "locales/*", ".*");
        localizedFiles = this.findFilesMatchingPattern(localizedFiles, "*.css:*.html:*.js:*.png", ".*");
        ArrayList<ProjectFileItem> projectFileList = new ArrayList<ProjectFileItem>();
        for (IFile iFile : filteredFiles) {
            ProjectFileItem pf = new ProjectFileItem();
            pf.setFile(iFile);
            pf.setLoclized(false);
            for (IFile iLoclizedFile : localizedFiles) {
                if (!iFile.getName().equals(iLoclizedFile.getName())) continue;
                pf.setLoclized(true);
                break;
            }
            projectFileList.add(pf);
        }
        return projectFileList.toArray();
    }

    private List<IFile> getProjectFileList(IProject project) {
        if (project == null) {
            return null;
        }
        ArrayList<IFile> files = new ArrayList<IFile>();
        IResource[] resources = null;
        try {
            resources = project.members();
            int i = 0;
            while (i < resources.length) {
                if (resources[i] instanceof IFile) {
                    files.add((IFile)resources[i]);
                } else if (resources[i] instanceof IFolder) {
                    files.addAll(this.getFiles((IFolder)resources[i]));
                }
                ++i;
            }
        }
        catch (CoreException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        return files;
    }

    private List<IFile> getFiles(IFolder folder) {
        ArrayList<IFile> files = new ArrayList<IFile>();
        IResource[] resources = null;
        try {
            resources = folder.members();
            int i = 0;
            while (i < resources.length) {
                if (resources[i] instanceof IFile) {
                    files.add((IFile)resources[i]);
                } else if (resources[i] instanceof IFolder) {
                    files.addAll(this.getFiles((IFolder)resources[i]));
                }
                ++i;
            }
        }
        catch (CoreException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        return files;
    }

    private List<IFile> findFilesMatchingPattern(List<IFile> files, String patterns, String ignore) {
        ArrayList<IFile> outputFiles = new ArrayList<IFile>();
        block0: for (IFile file : files) {
            String[] patternArray;
            String pattern;
            int n;
            int n2;
            String[] stringArray;
            String name = file.getProjectRelativePath().toString();
            boolean ignorePatternMatched = false;
            if (ignore != null && !ignore.isEmpty()) {
                String[] patternIgnore;
                stringArray = patternIgnore = ignore.split(DELIMITER);
                n2 = patternIgnore.length;
                n = 0;
                while (n < n2) {
                    pattern = stringArray[n];
                    if (PatternConstructor.createPattern(pattern, true).matcher(name.toLowerCase()).matches()) {
                        ignorePatternMatched = true;
                        break;
                    }
                    ++n;
                }
                if (ignorePatternMatched) continue;
            }
            if (patterns == null || patterns.isEmpty()) {
                patterns = WILDCARD;
            }
            stringArray = patternArray = patterns.split(DELIMITER);
            n2 = patternArray.length;
            n = 0;
            while (n < n2) {
                pattern = stringArray[n];
                if (PatternConstructor.createPattern(pattern, true).matcher(name.toLowerCase()).matches()) {
                    outputFiles.add(file);
                    continue block0;
                }
                ++n;
            }
        }
        return outputFiles;
    }
}

