/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.unittest.step;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.tizen.sdblib.util.LogLevel;
import org.tizen.web.unittest.resultview.ui.ShowViews;
import org.tizen.web.unittest.resultview.ui.WUTResultView;
import org.tizen.web.zimlaunch.util.jsconsole.JsLogInfo;
import org.tizen.web.zimlaunch.util.jsconsole.JsLogReceiver;

public class WUTJsLogReceiver
extends JsLogReceiver {
    private static final String PATTERN = ".*==WUT==.*";
    private String resultXML = "";
    private ILaunchConfiguration config;
    private String mode;
    private IProject project;

    public WUTJsLogReceiver(IProject project, String packageID, ILaunchConfiguration config, String mode) {
        super(packageID);
        this.project = project;
        this.config = config;
        this.mode = mode;
    }

    public synchronized void processNewLines(String[] lines) {
        if (this.isCancelled()) {
            return;
        }
        this.logger.trace("Process new lines({})", (Object)lines.length);
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            this.logger.trace("line: {}", (Object)line);
            ++n2;
        }
        List logMessageList = this.parseJsLog(lines);
        if (logMessageList == null) {
            return;
        }
        for (JsLogInfo jsLogInfo : logMessageList) {
            LogLevel level = jsLogInfo.getDlogInfo().getLogLevel();
            if (level == null) continue;
            String consoleMessage = jsLogInfo.toString();
            Matcher m = Pattern.compile(PATTERN).matcher(consoleMessage);
            if (!m.find()) continue;
            this.parseWUTLog(consoleMessage);
        }
    }

    private void parseWUTLog(String message) {
        if (message == null) {
            return;
        }
        String[] splitMessage = message.split("==WUT==");
        if (splitMessage.length == 2) {
            if (splitMessage[1].equals("*starts*")) {
                this.resultXML = "";
            } else if (splitMessage[1].equals("*ends*")) {
                this.showResultView();
                this.sendResultXmlData(this.resultXML);
            } else {
                this.resultXML = String.valueOf(this.resultXML) + splitMessage[1];
            }
        }
    }

    private void showResultView() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                IWorkbenchPage page = window.getActivePage();
                try {
                    page.showView("org.tizen.web.unittest.views.resultView");
                }
                catch (PartInitException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void sendResultXmlData(String xml) {
        ShowViews job = new ShowViews();
        job.schedule();
        try {
            job.join();
        }
        catch (InterruptedException interruptedException) {}
        WUTResultView resultView = WUTResultView.getWUTResultView();
        resultView.displayResult(xml, this.project, this.config, this.mode);
    }
}

