/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.editor.javascript.decorator;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DecorationContext;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.IDecorationContext;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.util.ImageUtil;
import org.tizen.common.util.SWTUtil;
import org.tizen.web.editor.javascript.Activator;

public class JavascriptFileDecorator
implements ILightweightLabelDecorator {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final String JAVASCRIPT_FILE_ICON_PATH = "icons/javascript_file.png";
    public static final String JAVASCRIPT_FILE_ICON_WARNING_PATH = "icons/javascript_file_warning.png";
    public static final String JAVASCRIPT_FILE_ICON_ERROR_PATH = "icons/javascript_file_error.png";
    public static final Image JAVASCRIPT_FILE_ICON_IMAGE = ImageUtil.getImage((Plugin)Activator.getDefault(), (String)"icons/javascript_file.png");
    public static final Image JAVASCRIPT_FILE_ICON_WARNING_IMAGE = ImageUtil.getImage((Plugin)Activator.getDefault(), (String)"icons/javascript_file_warning.png");
    public static final Image JAVASCRIPT_FILE_ICON_ERROR_IMAGE = ImageUtil.getImage((Plugin)Activator.getDefault(), (String)"icons/javascript_file_error.png");

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
        SWTUtil.tryDispose((Resource[])new Resource[]{JAVASCRIPT_FILE_ICON_IMAGE, JAVASCRIPT_FILE_ICON_WARNING_IMAGE, JAVASCRIPT_FILE_ICON_ERROR_IMAGE});
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public void decorate(Object element, IDecoration decoration) {
        IFile file = (IFile)element;
        if (!file.exists()) {
            return;
        }
        int severity = 0;
        try {
            severity = file.findMaxProblemSeverity("org.eclipse.core.resources.problemmarker", true, 2);
        }
        catch (CoreException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        Image decorateImage = JAVASCRIPT_FILE_ICON_IMAGE;
        if (severity == 1) {
            decorateImage = JAVASCRIPT_FILE_ICON_WARNING_IMAGE;
        } else if (severity == 2) {
            decorateImage = JAVASCRIPT_FILE_ICON_ERROR_IMAGE;
        }
        if (decorateImage != null) {
            ImageDescriptor imageDescriptor = ImageDescriptor.createFromImage((Image)decorateImage);
            IDecorationContext decorationCtx = decoration.getDecorationContext();
            if (decorationCtx instanceof DecorationContext) {
                DecorationContext decorationImpl = (DecorationContext)decorationCtx;
                decorationImpl.putProperty("org.eclipse.jface.viewers.IDecoration.disableReplace", (Object)Boolean.TRUE);
            }
            decoration.addOverlay(imageDescriptor, 5);
        }
    }
}

